/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;

class FailFast
implements Iterator {
    private static final WeakHashMap MAP = new WeakHashMap();
    private Object parent;
    private Iterator wrapped;

    static synchronized void invalidate(Object object) {
        Set set = (Set)MAP.get(object);
        if (set != null) {
            set.clear();
        }
    }

    private static synchronized void add(FailFast failFast) {
        HashSet<FailFast> hashSet = (HashSet<FailFast>)MAP.get(failFast.parent);
        if (hashSet == null) {
            hashSet = new HashSet<FailFast>();
            MAP.put(failFast.parent, hashSet);
        }
        hashSet.add(failFast);
    }

    private static synchronized void remove(FailFast failFast) {
        Set set = (Set)MAP.get(failFast.parent);
        if (set != null) {
            set.remove(failFast);
        }
    }

    private static synchronized void failFast(FailFast failFast) {
        Set set = (Set)MAP.get(failFast.parent);
        if (!set.contains(failFast)) {
            throw new ConcurrentModificationException();
        }
    }

    FailFast(Object object, Iterator iterator) {
        if (object == null) {
            throw new IllegalArgumentException("parent object is null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("cannot wrap null iterator");
        }
        this.parent = object;
        if (iterator.hasNext()) {
            this.wrapped = iterator;
            FailFast.add(this);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.wrapped == null) {
            return false;
        }
        FailFast.failFast(this);
        return this.wrapped.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        if (this.wrapped == null || !this.wrapped.hasNext()) {
            throw new NoSuchElementException();
        }
        FailFast.failFast(this);
        try {
            Object e = this.wrapped.next();
            return e;
        }
        finally {
            if (!this.wrapped.hasNext()) {
                this.wrapped = null;
                FailFast.remove(this);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

