/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.util.FileUtils;

public abstract class CompressedResource
extends Resource {
    private static final int BUFFER_SIZE = 8192;
    private Resource resource;

    public CompressedResource() {
    }

    public CompressedResource(ResourceCollection resourceCollection) {
        this.addConfigured(resourceCollection);
    }

    public void addConfigured(ResourceCollection resourceCollection) {
        this.checkChildrenAllowed();
        if (this.resource != null) {
            throw new BuildException("you must not specify more than one resource");
        }
        if (resourceCollection.size() != 1) {
            throw new BuildException("only single argument resource collections are supported");
        }
        this.resource = (Resource)resourceCollection.iterator().next();
    }

    @Override
    public String getName() {
        return this.getResource().getName();
    }

    @Override
    public void setName(String string) throws BuildException {
        throw new BuildException("you can't change the name of a compressed resource");
    }

    @Override
    public boolean isExists() {
        return this.getResource().isExists();
    }

    @Override
    public void setExists(boolean bl) {
        throw new BuildException("you can't change the exists state of a  compressed resource");
    }

    @Override
    public long getLastModified() {
        return this.getResource().getLastModified();
    }

    @Override
    public void setLastModified(long l) throws BuildException {
        throw new BuildException("you can't change the timestamp of a  compressed resource");
    }

    @Override
    public boolean isDirectory() {
        return this.getResource().isDirectory();
    }

    @Override
    public void setDirectory(boolean bl) throws BuildException {
        throw new BuildException("you can't change the directory state of a  compressed resource");
    }

    @Override
    public long getSize() {
        if (this.isExists()) {
            InputStream inputStream = null;
            try {
                int n;
                inputStream = this.getInputStream();
                byte[] byArray = new byte[8192];
                int n2 = 0;
                while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    n2 += n;
                }
                long l = n2;
                return l;
            }
            catch (IOException iOException) {
                throw new BuildException("caught exception while reading " + this.getName(), iOException);
            }
            finally {
                FileUtils.close(inputStream);
            }
        }
        return 0L;
    }

    @Override
    public void setSize(long l) throws BuildException {
        throw new BuildException("you can't change the size of a  compressed resource");
    }

    @Override
    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (object instanceof CompressedResource) {
            return this.getResource().compareTo(((CompressedResource)object).getResource());
        }
        return this.getResource().compareTo(object);
    }

    @Override
    public int hashCode() {
        return this.getResource().hashCode();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = this.getResource().getInputStream();
        if (inputStream != null) {
            inputStream = this.wrapStream(inputStream);
        }
        return inputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream outputStream = this.getResource().getOutputStream();
        if (outputStream != null) {
            outputStream = this.wrapStream(outputStream);
        }
        return outputStream;
    }

    @Override
    public boolean isFilesystemOnly() {
        return false;
    }

    @Override
    public String toString() {
        return this.getCompressionName() + " compressed " + this.getResource().toString();
    }

    @Override
    public void setRefid(Reference reference) {
        if (this.resource != null) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(reference);
    }

    protected abstract InputStream wrapStream(InputStream var1) throws IOException;

    protected abstract OutputStream wrapStream(OutputStream var1) throws IOException;

    protected abstract String getCompressionName();

    private Resource getResource() {
        if (this.isReference()) {
            return (Resource)this.getCheckedRef();
        }
        if (this.resource == null) {
            throw new BuildException("no resource specified");
        }
        return this.resource;
    }
}

