/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FailFast;
import org.apache.tools.ant.types.resources.FileResource;

public abstract class BaseResourceCollectionContainer
extends DataType
implements ResourceCollection,
Cloneable {
    private List rc = new ArrayList();
    private Collection coll = null;
    private boolean cache = true;

    public synchronized void setCache(boolean bl) {
        this.cache = bl;
    }

    public synchronized boolean isCache() {
        return this.cache;
    }

    public synchronized void clear() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.rc.clear();
        FailFast.invalidate(this);
        this.coll = null;
        this.setChecked(false);
    }

    public synchronized void add(ResourceCollection resourceCollection) throws BuildException {
        Project project;
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (resourceCollection == null) {
            return;
        }
        if (Project.getProject(resourceCollection) == null && (project = this.getProject()) != null) {
            project.setProjectReference(resourceCollection);
        }
        this.rc.add(resourceCollection);
        FailFast.invalidate(this);
        this.coll = null;
        this.setChecked(false);
    }

    public synchronized void addAll(Collection collection) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.add((ResourceCollection)iterator.next());
            }
        }
        catch (ClassCastException classCastException) {
            throw new BuildException(classCastException);
        }
    }

    @Override
    public final synchronized Iterator iterator() {
        if (this.isReference()) {
            return ((BaseResourceCollectionContainer)this.getCheckedRef()).iterator();
        }
        this.dieOnCircularReference();
        return new FailFast(this, this.cacheCollection().iterator());
    }

    @Override
    public synchronized int size() {
        if (this.isReference()) {
            return ((BaseResourceCollectionContainer)this.getCheckedRef()).size();
        }
        this.dieOnCircularReference();
        return this.cacheCollection().size();
    }

    @Override
    public synchronized boolean isFilesystemOnly() {
        if (this.isReference()) {
            return ((BaseResourceCollectionContainer)this.getCheckedRef()).isFilesystemOnly();
        }
        this.dieOnCircularReference();
        boolean bl = true;
        Iterator iterator = this.rc.iterator();
        while (bl && iterator.hasNext()) {
            bl = ((ResourceCollection)iterator.next()).isFilesystemOnly();
        }
        if (bl) {
            return true;
        }
        iterator = this.cacheCollection().iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof FileResource) continue;
            return false;
        }
        return true;
    }

    @Override
    protected synchronized void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stack, project);
        } else {
            for (Object e : this.rc) {
                if (!(e instanceof DataType)) continue;
                stack.push(e);
                BaseResourceCollectionContainer.invokeCircularReferenceCheck((DataType)e, stack, project);
                stack.pop();
            }
            this.setChecked(true);
        }
    }

    protected final synchronized List getResourceCollections() {
        this.dieOnCircularReference();
        return Collections.unmodifiableList(this.rc);
    }

    protected abstract Collection getCollection();

    @Override
    public Object clone() {
        try {
            BaseResourceCollectionContainer baseResourceCollectionContainer = (BaseResourceCollectionContainer)super.clone();
            baseResourceCollectionContainer.rc = new ArrayList(this.rc);
            baseResourceCollectionContainer.coll = null;
            return baseResourceCollectionContainer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new BuildException(cloneNotSupportedException);
        }
    }

    @Override
    public synchronized String toString() {
        if (this.isReference()) {
            return this.getCheckedRef().toString();
        }
        if (this.cacheCollection().size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.coll.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    private synchronized Collection cacheCollection() {
        if (this.coll == null || !this.isCache()) {
            this.coll = this.getCollection();
        }
        return this.coll;
    }
}

