/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.CompressedResource;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class BZip2Resource
extends CompressedResource {
    private static final char[] MAGIC = new char[]{'B', 'Z'};

    public BZip2Resource() {
    }

    public BZip2Resource(ResourceCollection resourceCollection) {
        super(resourceCollection);
    }

    @Override
    protected InputStream wrapStream(InputStream inputStream) throws IOException {
        for (int i = 0; i < MAGIC.length; ++i) {
            if (inputStream.read() == MAGIC[i]) continue;
            throw new IOException("Invalid bz2 stream.");
        }
        return new CBZip2InputStream(inputStream);
    }

    @Override
    protected OutputStream wrapStream(OutputStream outputStream) throws IOException {
        for (int i = 0; i < MAGIC.length; ++i) {
            outputStream.write(MAGIC[i]);
        }
        return new CBZip2OutputStream(outputStream);
    }

    @Override
    protected String getCompressionName() {
        return "Bzip2";
    }
}

