/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.ArchiveScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipScanner;

public class ZipFileSet
extends ArchiveFileSet {
    private String encoding = null;

    public ZipFileSet() {
    }

    protected ZipFileSet(FileSet fileSet) {
        super(fileSet);
    }

    protected ZipFileSet(ZipFileSet zipFileSet) {
        super(zipFileSet);
        this.encoding = zipFileSet.encoding;
    }

    public void setEncoding(String string) {
        this.checkZipFileSetAttributesAllowed();
        this.encoding = string;
    }

    public String getEncoding() {
        if (this.isReference()) {
            AbstractFileSet abstractFileSet = this.getRef(this.getProject());
            if (abstractFileSet instanceof ZipFileSet) {
                return ((ZipFileSet)abstractFileSet).getEncoding();
            }
            return null;
        }
        return this.encoding;
    }

    @Override
    protected ArchiveScanner newArchiveScanner() {
        ZipScanner zipScanner = new ZipScanner();
        zipScanner.setEncoding(this.encoding);
        return zipScanner;
    }

    @Override
    protected AbstractFileSet getRef(Project project) {
        this.dieOnCircularReference(project);
        Object object = this.getRefid().getReferencedObject(project);
        if (object instanceof ZipFileSet) {
            return (AbstractFileSet)object;
        }
        if (object instanceof FileSet) {
            ZipFileSet zipFileSet = new ZipFileSet((FileSet)object);
            this.configureFileSet(zipFileSet);
            return zipFileSet;
        }
        String string = this.getRefid().getRefId() + " doesn't denote a zipfileset or a fileset";
        throw new BuildException(string);
    }

    @Override
    public Object clone() {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(this.getProject())).clone();
        }
        return super.clone();
    }

    private void checkZipFileSetAttributesAllowed() {
        if (this.getProject() == null || this.isReference() && this.getRefid().getReferencedObject(this.getProject()) instanceof ZipFileSet) {
            this.checkAttributesAllowed();
        }
    }
}

