/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.IOException;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.ArchiveScanner;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.TarResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class TarScanner
extends ArchiveScanner {
    @Override
    protected void fillMapsFromArchive(Resource resource, String string, Map map, Map map2, Map map3, Map map4) {
        TarEntry tarEntry = null;
        TarInputStream tarInputStream = null;
        try {
            try {
                tarInputStream = new TarInputStream(resource.getInputStream());
            }
            catch (IOException iOException) {
                throw new BuildException("problem opening " + this.srcFile, iOException);
            }
            while ((tarEntry = tarInputStream.getNextEntry()) != null) {
                TarResource tarResource = new TarResource(resource, tarEntry);
                String string2 = tarEntry.getName();
                if (tarEntry.isDirectory()) {
                    string2 = TarScanner.trimSeparator(string2);
                    map3.put(string2, tarResource);
                    if (!this.match(string2)) continue;
                    map4.put(string2, tarResource);
                    continue;
                }
                map.put(string2, tarResource);
                if (!this.match(string2)) continue;
                map2.put(string2, tarResource);
            }
        }
        catch (IOException iOException) {
            try {
                throw new BuildException("problem reading " + this.srcFile, iOException);
            }
            catch (Throwable throwable) {
                FileUtils.close(tarInputStream);
                throw throwable;
            }
        }
        FileUtils.close(tarInputStream);
    }
}

