/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.MergingMapper;

public class RedirectorElement
extends DataType {
    private boolean usingInput = false;
    private boolean usingOutput = false;
    private boolean usingError = false;
    private Boolean logError;
    private String outputProperty;
    private String errorProperty;
    private String inputString;
    private Boolean append;
    private Boolean alwaysLog;
    private Boolean createEmptyFiles;
    private Mapper inputMapper;
    private Mapper outputMapper;
    private Mapper errorMapper;
    private Vector inputFilterChains = new Vector();
    private Vector outputFilterChains = new Vector();
    private Vector errorFilterChains = new Vector();
    private String outputEncoding;
    private String errorEncoding;
    private String inputEncoding;
    private Boolean logInputString;

    public void addConfiguredInputMapper(Mapper mapper) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.inputMapper != null) {
            if (this.usingInput) {
                throw new BuildException("attribute \"input\" cannot coexist with a nested <inputmapper>");
            }
            throw new BuildException("Cannot have > 1 <inputmapper>");
        }
        this.inputMapper = mapper;
    }

    public void addConfiguredOutputMapper(Mapper mapper) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.outputMapper != null) {
            if (this.usingOutput) {
                throw new BuildException("attribute \"output\" cannot coexist with a nested <outputmapper>");
            }
            throw new BuildException("Cannot have > 1 <outputmapper>");
        }
        this.outputMapper = mapper;
    }

    public void addConfiguredErrorMapper(Mapper mapper) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.errorMapper != null) {
            if (this.usingError) {
                throw new BuildException("attribute \"error\" cannot coexist with a nested <errormapper>");
            }
            throw new BuildException("Cannot have > 1 <errormapper>");
        }
        this.errorMapper = mapper;
    }

    @Override
    public void setRefid(Reference reference) throws BuildException {
        if (this.usingInput || this.usingOutput || this.usingError || this.inputString != null || this.logError != null || this.append != null || this.createEmptyFiles != null || this.inputEncoding != null || this.outputEncoding != null || this.errorEncoding != null || this.outputProperty != null || this.errorProperty != null || this.logInputString != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    public void setInput(File file) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.inputString != null) {
            throw new BuildException("The \"input\" and \"inputstring\" attributes cannot both be specified");
        }
        this.usingInput = true;
        this.inputMapper = this.createMergeMapper(file);
    }

    public void setInputString(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.usingInput) {
            throw new BuildException("The \"input\" and \"inputstring\" attributes cannot both be specified");
        }
        this.inputString = string;
    }

    public void setLogInputString(boolean bl) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.logInputString = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setOutput(File file) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (file == null) {
            throw new IllegalArgumentException("output file specified as null");
        }
        this.usingOutput = true;
        this.outputMapper = this.createMergeMapper(file);
    }

    public void setOutputEncoding(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.outputEncoding = string;
    }

    public void setErrorEncoding(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.errorEncoding = string;
    }

    public void setInputEncoding(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.inputEncoding = string;
    }

    public void setLogError(boolean bl) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.logError = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setError(File file) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (file == null) {
            throw new IllegalArgumentException("error file specified as null");
        }
        this.usingError = true;
        this.errorMapper = this.createMergeMapper(file);
    }

    public void setOutputProperty(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.outputProperty = string;
    }

    public void setAppend(boolean bl) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.append = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAlwaysLog(boolean bl) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.alwaysLog = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setCreateEmptyFiles(boolean bl) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createEmptyFiles = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setErrorProperty(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.errorProperty = string;
    }

    public FilterChain createInputFilterChain() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        FilterChain filterChain = new FilterChain();
        filterChain.setProject(this.getProject());
        this.inputFilterChains.add(filterChain);
        return filterChain;
    }

    public FilterChain createOutputFilterChain() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        FilterChain filterChain = new FilterChain();
        filterChain.setProject(this.getProject());
        this.outputFilterChains.add(filterChain);
        return filterChain;
    }

    public FilterChain createErrorFilterChain() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        FilterChain filterChain = new FilterChain();
        filterChain.setProject(this.getProject());
        this.errorFilterChains.add(filterChain);
        return filterChain;
    }

    public void configure(Redirector redirector) {
        this.configure(redirector, null);
    }

    public void configure(Redirector redirector, String string) {
        String[] stringArray;
        if (this.isReference()) {
            this.getRef().configure(redirector, string);
            return;
        }
        if (this.alwaysLog != null) {
            redirector.setAlwaysLog(this.alwaysLog);
        }
        if (this.logError != null) {
            redirector.setLogError(this.logError);
        }
        if (this.append != null) {
            redirector.setAppend(this.append);
        }
        if (this.createEmptyFiles != null) {
            redirector.setCreateEmptyFiles(this.createEmptyFiles);
        }
        if (this.outputProperty != null) {
            redirector.setOutputProperty(this.outputProperty);
        }
        if (this.errorProperty != null) {
            redirector.setErrorProperty(this.errorProperty);
        }
        if (this.inputString != null) {
            redirector.setInputString(this.inputString);
        }
        if (this.logInputString != null) {
            redirector.setLogInputString(this.logInputString);
        }
        if (this.inputMapper != null) {
            block27: {
                stringArray = null;
                try {
                    stringArray = this.inputMapper.getImplementation().mapFileName(string);
                }
                catch (NullPointerException nullPointerException) {
                    if (string == null) break block27;
                    throw nullPointerException;
                }
            }
            if (stringArray != null && stringArray.length > 0) {
                redirector.setInput(this.toFileArray(stringArray));
            }
        }
        if (this.outputMapper != null) {
            block28: {
                stringArray = null;
                try {
                    stringArray = this.outputMapper.getImplementation().mapFileName(string);
                }
                catch (NullPointerException nullPointerException) {
                    if (string == null) break block28;
                    throw nullPointerException;
                }
            }
            if (stringArray != null && stringArray.length > 0) {
                redirector.setOutput(this.toFileArray(stringArray));
            }
        }
        if (this.errorMapper != null) {
            block29: {
                stringArray = null;
                try {
                    stringArray = this.errorMapper.getImplementation().mapFileName(string);
                }
                catch (NullPointerException nullPointerException) {
                    if (string == null) break block29;
                    throw nullPointerException;
                }
            }
            if (stringArray != null && stringArray.length > 0) {
                redirector.setError(this.toFileArray(stringArray));
            }
        }
        if (this.inputFilterChains.size() > 0) {
            redirector.setInputFilterChains(this.inputFilterChains);
        }
        if (this.outputFilterChains.size() > 0) {
            redirector.setOutputFilterChains(this.outputFilterChains);
        }
        if (this.errorFilterChains.size() > 0) {
            redirector.setErrorFilterChains(this.errorFilterChains);
        }
        if (this.inputEncoding != null) {
            redirector.setInputEncoding(this.inputEncoding);
        }
        if (this.outputEncoding != null) {
            redirector.setOutputEncoding(this.outputEncoding);
        }
        if (this.errorEncoding != null) {
            redirector.setErrorEncoding(this.errorEncoding);
        }
    }

    protected Mapper createMergeMapper(File file) {
        Mapper mapper = new Mapper(this.getProject());
        mapper.setClassname(MergingMapper.class.getName());
        mapper.setTo(file.getAbsolutePath());
        return mapper;
    }

    protected File[] toFileArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            arrayList.add(this.getProject().resolveFile(stringArray[i]));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    @Override
    protected void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stack, project);
        } else {
            Mapper[] mapperArray = new Mapper[]{this.inputMapper, this.outputMapper, this.errorMapper};
            for (int i = 0; i < mapperArray.length; ++i) {
                if (mapperArray[i] == null) continue;
                stack.push(mapperArray[i]);
                mapperArray[i].dieOnCircularReference(stack, project);
                stack.pop();
            }
            Vector[] vectorArray = new Vector[]{this.inputFilterChains, this.outputFilterChains, this.errorFilterChains};
            for (int i = 0; i < vectorArray.length; ++i) {
                if (vectorArray[i] == null) continue;
                for (FilterChain filterChain : vectorArray[i]) {
                    stack.push(filterChain);
                    filterChain.dieOnCircularReference(stack, project);
                    stack.pop();
                }
            }
            this.setChecked(true);
        }
    }

    private RedirectorElement getRef() {
        return (RedirectorElement)this.getCheckedRef();
    }
}

