/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class PatternSet
extends DataType
implements Cloneable {
    private Vector includeList = new Vector();
    private Vector excludeList = new Vector();
    private Vector includesFileList = new Vector();
    private Vector excludesFileList = new Vector();

    @Override
    public void setRefid(Reference reference) throws BuildException {
        if (!this.includeList.isEmpty() || !this.excludeList.isEmpty()) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    public void addConfiguredPatternset(PatternSet patternSet) {
        int n;
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        String[] stringArray = patternSet.getIncludePatterns(this.getProject());
        String[] stringArray2 = patternSet.getExcludePatterns(this.getProject());
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                this.createInclude().setName(stringArray[n]);
            }
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                this.createExclude().setName(stringArray2[n]);
            }
        }
    }

    public NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.includeList);
    }

    public NameEntry createIncludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.includesFileList);
    }

    public NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.excludeList);
    }

    public NameEntry createExcludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.excludesFileList);
    }

    public void setIncludes(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.createInclude().setName(stringTokenizer.nextToken());
            }
        }
    }

    public void setExcludes(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.createExclude().setName(stringTokenizer.nextToken());
            }
        }
    }

    private NameEntry addPatternToList(Vector vector) {
        NameEntry nameEntry = new NameEntry();
        vector.addElement(nameEntry);
        return nameEntry;
    }

    public void setIncludesfile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createIncludesFile().setName(file.getAbsolutePath());
    }

    public void setExcludesfile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createExcludesFile().setName(file.getAbsolutePath());
    }

    private void readPatterns(File file, Vector vector, Project project) throws BuildException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() > 0) {
                    string = project.replaceProperties(string);
                    this.addPatternToList(vector).setName(string);
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            String string = "An error occurred while reading from pattern file: " + file;
            throw new BuildException(string, iOException);
        }
        finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void append(PatternSet patternSet, Project project) {
        String[] stringArray;
        if (this.isReference()) {
            throw new BuildException("Cannot append to a reference");
        }
        String[] stringArray2 = patternSet.getIncludePatterns(project);
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                this.createInclude().setName(stringArray2[i]);
            }
        }
        if ((stringArray = patternSet.getExcludePatterns(project)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.createExclude().setName(stringArray[i]);
            }
        }
    }

    public String[] getIncludePatterns(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getIncludePatterns(project);
        }
        this.readFiles(project);
        return this.makeArray(this.includeList, project);
    }

    public String[] getExcludePatterns(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getExcludePatterns(project);
        }
        this.readFiles(project);
        return this.makeArray(this.excludeList, project);
    }

    public boolean hasPatterns(Project project) {
        if (this.isReference()) {
            return this.getRef(project).hasPatterns(project);
        }
        return this.includesFileList.size() > 0 || this.excludesFileList.size() > 0 || this.includeList.size() > 0 || this.excludeList.size() > 0;
    }

    private PatternSet getRef(Project project) {
        return (PatternSet)this.getCheckedRef(project);
    }

    private String[] makeArray(Vector vector, Project project) {
        if (vector.size() == 0) {
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        Object[] objectArray = vector.elements();
        while (objectArray.hasMoreElements()) {
            NameEntry nameEntry = (NameEntry)objectArray.nextElement();
            String string = nameEntry.evalName(project);
            if (string == null || string.length() <= 0) continue;
            vector2.addElement(string);
        }
        objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    private void readFiles(Project project) {
        File file;
        String string;
        NameEntry nameEntry;
        Enumeration enumeration;
        if (this.includesFileList.size() > 0) {
            enumeration = this.includesFileList.elements();
            while (enumeration.hasMoreElements()) {
                nameEntry = (NameEntry)enumeration.nextElement();
                string = nameEntry.evalName(project);
                if (string == null) continue;
                file = project.resolveFile(string);
                if (!file.exists()) {
                    throw new BuildException("Includesfile " + file.getAbsolutePath() + " not found.");
                }
                this.readPatterns(file, this.includeList, project);
            }
            this.includesFileList.removeAllElements();
        }
        if (this.excludesFileList.size() > 0) {
            enumeration = this.excludesFileList.elements();
            while (enumeration.hasMoreElements()) {
                nameEntry = (NameEntry)enumeration.nextElement();
                string = nameEntry.evalName(project);
                if (string == null) continue;
                file = project.resolveFile(string);
                if (!file.exists()) {
                    throw new BuildException("Excludesfile " + file.getAbsolutePath() + " not found.");
                }
                this.readPatterns(file, this.excludeList, project);
            }
            this.excludesFileList.removeAllElements();
        }
    }

    @Override
    public String toString() {
        return "patternSet{ includes: " + this.includeList + " excludes: " + this.excludeList + " }";
    }

    @Override
    public Object clone() {
        try {
            PatternSet patternSet = (PatternSet)super.clone();
            patternSet.includeList = (Vector)this.includeList.clone();
            patternSet.excludeList = (Vector)this.excludeList.clone();
            patternSet.includesFileList = (Vector)this.includesFileList.clone();
            patternSet.excludesFileList = (Vector)this.excludesFileList.clone();
            return patternSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new BuildException(cloneNotSupportedException);
        }
    }

    public void addConfiguredInvert(PatternSet patternSet) {
        this.addConfiguredPatternset(new InvertedPatternSet(patternSet));
    }

    private static final class InvertedPatternSet
    extends PatternSet {
        private InvertedPatternSet(PatternSet patternSet) {
            this.setProject(patternSet.getProject());
            this.addConfiguredPatternset(patternSet);
        }

        @Override
        public String[] getIncludePatterns(Project project) {
            return super.getExcludePatterns(project);
        }

        @Override
        public String[] getExcludePatterns(Project project) {
            return super.getIncludePatterns(project);
        }
    }

    public class NameEntry {
        private String name;
        private String ifCond;
        private String unlessCond;

        public void setName(String string) {
            this.name = string;
        }

        public void setIf(String string) {
            this.ifCond = string;
        }

        public void setUnless(String string) {
            this.unlessCond = string;
        }

        public String getName() {
            return this.name;
        }

        public String evalName(Project project) {
            return this.valid(project) ? this.name : null;
        }

        private boolean valid(Project project) {
            if (this.ifCond != null && project.getProperty(this.ifCond) == null) {
                return false;
            }
            return this.unlessCond == null || project.getProperty(this.unlessCond) == null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.name == null) {
                stringBuffer.append("noname");
            } else {
                stringBuffer.append(this.name);
            }
            if (this.ifCond != null || this.unlessCond != null) {
                stringBuffer.append(":");
                String string = "";
                if (this.ifCond != null) {
                    stringBuffer.append("if->");
                    stringBuffer.append(this.ifCond);
                    string = ";";
                }
                if (this.unlessCond != null) {
                    stringBuffer.append(string);
                    stringBuffer.append("unless->");
                    stringBuffer.append(this.unlessCond);
                }
            }
            return stringBuffer.toString();
        }
    }
}

