/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResourceIterator;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Path
extends DataType
implements Cloneable,
ResourceCollection {
    public static Path systemClasspath = new Path(null, System.getProperty("java.class.path"));
    public static Path systemBootClasspath = new Path(null, System.getProperty("sun.boot.class.path"));
    private static final Iterator EMPTY_ITERATOR = Collections.EMPTY_SET.iterator();
    private Boolean preserveBC;
    private Union union = null;

    public Path(Project project, String string) {
        this(project);
        this.createPathElement().setPath(string);
    }

    public Path(Project project) {
        this.setProject(project);
    }

    public void setLocation(File file) throws BuildException {
        this.checkAttributesAllowed();
        this.createPathElement().setLocation(file);
    }

    public void setPath(String string) throws BuildException {
        this.checkAttributesAllowed();
        this.createPathElement().setPath(string);
    }

    @Override
    public void setRefid(Reference reference) throws BuildException {
        if (this.union != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    public PathElement createPathElement() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PathElement pathElement = new PathElement();
        this.add(pathElement);
        return pathElement;
    }

    public void addFileset(FileSet fileSet) throws BuildException {
        if (fileSet.getProject() == null) {
            fileSet.setProject(this.getProject());
        }
        this.add(fileSet);
    }

    public void addFilelist(FileList fileList) throws BuildException {
        if (fileList.getProject() == null) {
            fileList.setProject(this.getProject());
        }
        this.add(fileList);
    }

    public void addDirset(DirSet dirSet) throws BuildException {
        if (dirSet.getProject() == null) {
            dirSet.setProject(this.getProject());
        }
        this.add(dirSet);
    }

    public void add(Path path) throws BuildException {
        if (path == this) {
            throw this.circularReference();
        }
        if (path.getProject() == null) {
            path.setProject(this.getProject());
        }
        this.add((ResourceCollection)path);
    }

    public void add(ResourceCollection resourceCollection) {
        this.checkChildrenAllowed();
        if (resourceCollection == null) {
            return;
        }
        if (this.union == null) {
            this.union = new Union();
            this.union.setProject(this.getProject());
            this.union.setCache(false);
        }
        this.union.add(resourceCollection);
        this.setChecked(false);
    }

    public Path createPath() throws BuildException {
        Path path = new Path(this.getProject());
        this.add(path);
        return path;
    }

    public void append(Path path) {
        if (path == null) {
            return;
        }
        this.add(path);
    }

    public void addExisting(Path path) {
        this.addExisting(path, false);
    }

    public void addExisting(Path path, boolean bl) {
        String[] stringArray = path.list();
        File file = bl ? new File(System.getProperty("user.dir")) : null;
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = Path.resolveFile(this.getProject(), stringArray[i]);
            if (bl && !file2.exists()) {
                file2 = new File(file, stringArray[i]);
            }
            if (file2.exists()) {
                this.setLocation(file2);
                continue;
            }
            this.log("dropping " + file2 + " from path as it doesn't exist", 3);
        }
    }

    public String[] list() {
        if (this.isReference()) {
            return ((Path)this.getCheckedRef()).list();
        }
        return this.assertFilesystemOnly(this.union) == null ? new String[]{} : this.union.list();
    }

    @Override
    public String toString() {
        return this.isReference() ? this.getCheckedRef().toString() : (this.union == null ? "" : this.union.toString());
    }

    public static String[] translatePath(Project project, String string) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        if (string == null) {
            return new String[0];
        }
        PathTokenizer pathTokenizer = new PathTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (pathTokenizer.hasMoreTokens()) {
            objectArray = pathTokenizer.nextToken();
            try {
                stringBuffer.append(Path.resolveFile(project, (String)objectArray).getPath());
            }
            catch (BuildException buildException) {
                project.log("Dropping path element " + (String)objectArray + " as it is not valid relative to the project", 3);
            }
            for (int i = 0; i < stringBuffer.length(); ++i) {
                Path.translateFileSep(stringBuffer, i);
            }
            vector.addElement(stringBuffer.toString());
            stringBuffer = new StringBuffer();
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String translateFile(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            Path.translateFileSep(stringBuffer, i);
        }
        return stringBuffer.toString();
    }

    protected static boolean translateFileSep(StringBuffer stringBuffer, int n) {
        if (stringBuffer.charAt(n) == '/' || stringBuffer.charAt(n) == '\\') {
            stringBuffer.setCharAt(n, File.separatorChar);
            return true;
        }
        return false;
    }

    @Override
    public synchronized int size() {
        if (this.isReference()) {
            return ((Path)this.getCheckedRef()).size();
        }
        this.dieOnCircularReference();
        return this.union == null ? 0 : this.assertFilesystemOnly(this.union).size();
    }

    @Override
    public Object clone() {
        try {
            Path path = (Path)super.clone();
            path.union = this.union == null ? this.union : (Union)this.union.clone();
            return path;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new BuildException(cloneNotSupportedException);
        }
    }

    @Override
    protected synchronized void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stack, project);
        } else {
            if (this.union != null) {
                stack.push(this.union);
                Path.invokeCircularReferenceCheck(this.union, stack, project);
                stack.pop();
            }
            this.setChecked(true);
        }
    }

    private static File resolveFile(Project project, String string) {
        return FileUtils.getFileUtils().resolveFile(project == null ? null : project.getBaseDir(), string);
    }

    public Path concatSystemClasspath() {
        return this.concatSystemClasspath("last");
    }

    public Path concatSystemClasspath(String string) {
        return this.concatSpecialPath(string, systemClasspath);
    }

    public Path concatSystemBootClasspath(String string) {
        return this.concatSpecialPath(string, systemBootClasspath);
    }

    private Path concatSpecialPath(String string, Path path) {
        String string2;
        Path path2 = new Path(this.getProject());
        String string3 = string;
        if (this.getProject() != null && (string2 = this.getProject().getProperty("build.sysclasspath")) != null) {
            string3 = string2;
        }
        if (string3.equals("only")) {
            path2.addExisting(path, true);
        } else if (string3.equals("first")) {
            path2.addExisting(path, true);
            path2.addExisting(this);
        } else if (string3.equals("ignore")) {
            path2.addExisting(this);
        } else {
            if (!string3.equals("last")) {
                this.log("invalid value for build.sysclasspath: " + string3, 1);
            }
            path2.addExisting(this);
            path2.addExisting(path, true);
        }
        return path2;
    }

    public void addJavaRuntime() {
        Object object;
        if (JavaEnvUtils.isKaffe()) {
            object = new File(System.getProperty("java.home") + File.separator + "share" + File.separator + "kaffe");
            if (object.isDirectory()) {
                FileSet fileSet = new FileSet();
                fileSet.setDir((File)object);
                fileSet.setIncludes("*.jar");
                this.addFileset(fileSet);
            }
        } else if ("GNU libgcj".equals(System.getProperty("java.vm.name"))) {
            this.addExisting(systemBootClasspath);
        }
        if (System.getProperty("java.vendor").toLowerCase(Locale.US).indexOf("microsoft") >= 0) {
            object = new FileSet();
            object.setDir(new File(System.getProperty("java.home") + File.separator + "Packages"));
            object.setIncludes("*.ZIP");
            this.addFileset((FileSet)object);
        } else {
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
            object = new String[]{"jce", "jsse"};
            for (int i = 0; i < ((String[])object).length; ++i) {
                this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + object[i] + ".jar"));
                this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator + object[i] + ".jar"));
            }
            String[] stringArray = new String[]{"core", "graphics", "security", "server", "xml"};
            for (int i = 0; i < stringArray.length; ++i) {
                this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + stringArray[i] + ".jar"));
            }
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator + "classes.jar"));
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator + "ui.jar"));
        }
    }

    public void addExtdirs(Path path) {
        String[] stringArray;
        if (path == null) {
            stringArray = System.getProperty("java.ext.dirs");
            if (stringArray != null) {
                path = new Path(this.getProject(), (String)stringArray);
            } else {
                return;
            }
        }
        stringArray = path.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = Path.resolveFile(this.getProject(), stringArray[i]);
            if (!file.exists() || !file.isDirectory()) continue;
            FileSet fileSet = new FileSet();
            fileSet.setDir(file);
            fileSet.setIncludes("*");
            this.addFileset(fileSet);
        }
    }

    @Override
    public final synchronized Iterator iterator() {
        if (this.isReference()) {
            return ((Path)this.getCheckedRef()).iterator();
        }
        this.dieOnCircularReference();
        if (this.getPreserveBC()) {
            return new FileResourceIterator(null, this.list());
        }
        return this.union == null ? EMPTY_ITERATOR : this.assertFilesystemOnly(this.union).iterator();
    }

    @Override
    public synchronized boolean isFilesystemOnly() {
        if (this.isReference()) {
            return ((Path)this.getCheckedRef()).isFilesystemOnly();
        }
        this.dieOnCircularReference();
        this.assertFilesystemOnly(this.union);
        return true;
    }

    protected ResourceCollection assertFilesystemOnly(ResourceCollection resourceCollection) {
        if (resourceCollection != null && !resourceCollection.isFilesystemOnly()) {
            throw new BuildException(this.getDataTypeName() + " allows only filesystem resources.");
        }
        return resourceCollection;
    }

    protected boolean delegateIteratorToList() {
        if (this.getClass().equals(Path.class)) {
            return false;
        }
        try {
            Method method = this.getClass().getMethod("list", null);
            return !method.getDeclaringClass().equals(Path.class);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private synchronized boolean getPreserveBC() {
        if (this.preserveBC == null) {
            this.preserveBC = this.delegateIteratorToList() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.preserveBC;
    }

    public class PathElement
    implements ResourceCollection {
        private String[] parts;

        public void setLocation(File file) {
            this.parts = new String[]{Path.translateFile(file.getAbsolutePath())};
        }

        public void setPath(String string) {
            this.parts = Path.translatePath(Path.this.getProject(), string);
        }

        public String[] getParts() {
            return this.parts;
        }

        @Override
        public Iterator iterator() {
            return new FileResourceIterator(null, this.parts);
        }

        @Override
        public boolean isFilesystemOnly() {
            return true;
        }

        @Override
        public int size() {
            return this.parts == null ? 0 : this.parts.length;
        }
    }
}

