/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;

public class FilterSet
extends DataType
implements Cloneable {
    public static final String DEFAULT_TOKEN_START = "@";
    public static final String DEFAULT_TOKEN_END = "@";
    private String startOfToken = "@";
    private String endOfToken = "@";
    private Vector passedTokens;
    private boolean duplicateToken = false;
    private boolean recurse = true;
    private Hashtable filterHash = null;
    private Vector filtersFiles = new Vector();
    private OnMissing onMissingFiltersFile = OnMissing.FAIL;
    private boolean readingFiles = false;
    private int recurseDepth = 0;
    private Vector filters = new Vector();

    public FilterSet() {
    }

    protected FilterSet(FilterSet filterSet) {
        this.filters = (Vector)filterSet.getFilters().clone();
    }

    protected synchronized Vector getFilters() {
        if (this.isReference()) {
            return this.getRef().getFilters();
        }
        if (!this.readingFiles) {
            this.readingFiles = true;
            int n = this.filtersFiles.size();
            for (int i = 0; i < n; ++i) {
                this.readFiltersFromFile((File)this.filtersFiles.get(i));
            }
            this.filtersFiles.clear();
            this.readingFiles = false;
        }
        return this.filters;
    }

    protected FilterSet getRef() {
        return (FilterSet)this.getCheckedRef(FilterSet.class, "filterset");
    }

    public synchronized Hashtable getFilterHash() {
        if (this.filterHash == null) {
            this.filterHash = new Hashtable(this.getFilters().size());
            Enumeration enumeration = this.getFilters().elements();
            while (enumeration.hasMoreElements()) {
                Filter filter = (Filter)enumeration.nextElement();
                this.filterHash.put(filter.getToken(), filter.getValue());
            }
        }
        return this.filterHash;
    }

    public void setFiltersfile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filtersFiles.add(file);
    }

    public void setBeginToken(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (string == null || "".equals(string)) {
            throw new BuildException("beginToken must not be empty");
        }
        this.startOfToken = string;
    }

    public String getBeginToken() {
        if (this.isReference()) {
            return this.getRef().getBeginToken();
        }
        return this.startOfToken;
    }

    public void setEndToken(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (string == null || "".equals(string)) {
            throw new BuildException("endToken must not be empty");
        }
        this.endOfToken = string;
    }

    public String getEndToken() {
        if (this.isReference()) {
            return this.getRef().getEndToken();
        }
        return this.endOfToken;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public synchronized void readFiltersFromFile(File file) throws BuildException {
        block8: {
            block7: {
                if (this.isReference()) {
                    throw this.tooManyAttributes();
                }
                if (!file.exists()) {
                    this.handleMissingFile("Could not read filters from file " + file + " as it doesn't exist.");
                }
                if (!file.isFile()) break block7;
                this.log("Reading filters from " + file, 3);
                FileInputStream fileInputStream = null;
                try {
                    Properties properties = new Properties();
                    fileInputStream = new FileInputStream(file);
                    properties.load(fileInputStream);
                    Enumeration<?> enumeration = properties.propertyNames();
                    Vector vector = this.getFilters();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String string2 = properties.getProperty(string);
                        vector.addElement(new Filter(string, string2));
                    }
                }
                catch (Exception exception) {
                    try {
                        throw new BuildException("Could not read filters from file: " + file, exception);
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(fileInputStream);
                        throw throwable;
                    }
                }
                FileUtils.close(fileInputStream);
                break block8;
            }
            this.handleMissingFile("Must specify a file rather than a directory in the filtersfile attribute:" + file);
        }
        this.filterHash = null;
    }

    public synchronized String replaceTokens(String string) {
        return this.iReplaceTokens(string);
    }

    public synchronized void addFilter(Filter filter) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.filters.addElement(filter);
        this.filterHash = null;
    }

    public FiltersFile createFiltersfile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return new FiltersFile();
    }

    public synchronized void addFilter(String string, String string2) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.addFilter(new Filter(string, string2));
    }

    public synchronized void addConfiguredFilterSet(FilterSet filterSet) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        Enumeration enumeration = filterSet.getFilters().elements();
        while (enumeration.hasMoreElements()) {
            this.addFilter((Filter)enumeration.nextElement());
        }
    }

    public synchronized boolean hasFilters() {
        return this.getFilters().size() > 0;
    }

    @Override
    public synchronized Object clone() throws BuildException {
        if (this.isReference()) {
            return this.getRef().clone();
        }
        try {
            FilterSet filterSet = (FilterSet)super.clone();
            filterSet.filters = (Vector)this.getFilters().clone();
            filterSet.setProject(this.getProject());
            return filterSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new BuildException(cloneNotSupportedException);
        }
    }

    public void setOnMissingFiltersFile(OnMissing onMissing) {
        this.onMissingFiltersFile = onMissing;
    }

    public OnMissing getOnMissingFiltersFile() {
        return this.onMissingFiltersFile;
    }

    private synchronized String iReplaceTokens(String string) {
        String string2 = this.getBeginToken();
        String string3 = this.getEndToken();
        int n = string.indexOf(string2);
        if (n > -1) {
            Hashtable hashtable = this.getFilterHash();
            try {
                int n2;
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                String string4 = null;
                String string5 = null;
                while (n > -1 && (n2 = string.indexOf(string3, n + string2.length() + 1)) != -1) {
                    string4 = string.substring(n + string2.length(), n2);
                    stringBuffer.append(string.substring(n3, n));
                    if (hashtable.containsKey(string4)) {
                        string5 = (String)hashtable.get(string4);
                        if (this.recurse && !string5.equals(string4)) {
                            string5 = this.replaceTokens(string5, string4);
                        }
                        this.log("Replacing: " + string2 + string4 + string3 + " -> " + string5, 3);
                        stringBuffer.append(string5);
                        n3 = n + string2.length() + string4.length() + string3.length();
                    } else {
                        stringBuffer.append(string2);
                        n3 = n + string2.length();
                    }
                    n = string.indexOf(string2, n3);
                }
                stringBuffer.append(string.substring(n3));
                return stringBuffer.toString();
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return string;
            }
        }
        return string;
    }

    private synchronized String replaceTokens(String string, String string2) throws BuildException {
        String string3 = this.getBeginToken();
        String string4 = this.getEndToken();
        if (this.recurseDepth == 0) {
            this.passedTokens = new Vector();
        }
        ++this.recurseDepth;
        if (this.passedTokens.contains(string2) && !this.duplicateToken) {
            this.duplicateToken = true;
            System.out.println("Infinite loop in tokens. Currently known tokens : " + this.passedTokens.toString() + "\nProblem token : " + string3 + string2 + string4 + " called from " + string3 + this.passedTokens.lastElement().toString() + string4);
            --this.recurseDepth;
            return string2;
        }
        this.passedTokens.addElement(string2);
        String string5 = this.iReplaceTokens(string);
        if (string5.indexOf(string3) == -1 && !this.duplicateToken && this.recurseDepth == 1) {
            this.passedTokens = null;
        } else if (this.duplicateToken && this.passedTokens.size() > 0) {
            string5 = (String)this.passedTokens.remove(this.passedTokens.size() - 1);
            if (this.passedTokens.size() == 0) {
                string5 = string3 + string5 + string4;
                this.duplicateToken = false;
            }
        }
        --this.recurseDepth;
        return string5;
    }

    private void handleMissingFile(String string) {
        switch (this.onMissingFiltersFile.getIndex()) {
            case 2: {
                return;
            }
            case 0: {
                throw new BuildException(string);
            }
            case 1: {
                this.log(string, 1);
                return;
            }
        }
        throw new BuildException("Invalid value for onMissingFiltersFile");
    }

    public static class OnMissing
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"fail", "warn", "ignore"};
        public static final OnMissing FAIL = new OnMissing("fail");
        public static final OnMissing WARN = new OnMissing("warn");
        public static final OnMissing IGNORE = new OnMissing("ignore");
        private static final int FAIL_INDEX = 0;
        private static final int WARN_INDEX = 1;
        private static final int IGNORE_INDEX = 2;

        public OnMissing() {
        }

        public OnMissing(String string) {
            this.setValue(string);
        }

        @Override
        public String[] getValues() {
            return VALUES;
        }
    }

    public class FiltersFile {
        public void setFile(File file) {
            FilterSet.this.filtersFiles.add(file);
        }
    }

    public static class Filter {
        String token;
        String value;

        public Filter(String string, String string2) {
            this.setToken(string);
            this.setValue(string2);
        }

        public Filter() {
        }

        public void setToken(String string) {
            this.token = string;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getToken() {
            return this.token;
        }

        public String getValue() {
            return this.value;
        }
    }
}

