/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResourceIterator;

public class FileList
extends DataType
implements ResourceCollection {
    private Vector filenames = new Vector();
    private File dir;

    public FileList() {
    }

    protected FileList(FileList fileList) {
        this.dir = fileList.dir;
        this.filenames = fileList.filenames;
        this.setProject(fileList.getProject());
    }

    @Override
    public void setRefid(Reference reference) throws BuildException {
        if (this.dir != null || this.filenames.size() != 0) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    public void setDir(File file) throws BuildException {
        this.checkAttributesAllowed();
        this.dir = file;
    }

    public File getDir(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getDir(project);
        }
        return this.dir;
    }

    public void setFiles(String string) {
        this.checkAttributesAllowed();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n\r\f", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.filenames.addElement(stringTokenizer.nextToken());
            }
        }
    }

    public String[] getFiles(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getFiles(project);
        }
        if (this.dir == null) {
            throw new BuildException("No directory specified for filelist.");
        }
        if (this.filenames.size() == 0) {
            throw new BuildException("No files specified for filelist.");
        }
        Object[] objectArray = new String[this.filenames.size()];
        this.filenames.copyInto(objectArray);
        return objectArray;
    }

    protected FileList getRef(Project project) {
        return (FileList)this.getCheckedRef(project);
    }

    public void addConfiguredFile(FileName fileName) {
        if (fileName.getName() == null) {
            throw new BuildException("No name specified in nested file element");
        }
        this.filenames.addElement(fileName.getName());
    }

    @Override
    public Iterator iterator() {
        if (this.isReference()) {
            return this.getRef(this.getProject()).iterator();
        }
        return new FileResourceIterator(this.dir, this.filenames.toArray(new String[this.filenames.size()]));
    }

    @Override
    public int size() {
        if (this.isReference()) {
            return this.getRef(this.getProject()).size();
        }
        return this.filenames.size();
    }

    @Override
    public boolean isFilesystemOnly() {
        return true;
    }

    public static class FileName {
        private String name;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }
    }
}

