/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;

public class Environment {
    protected Vector variables = new Vector();

    public void addVariable(Variable variable) {
        this.variables.addElement(variable);
    }

    public String[] getVariables() throws BuildException {
        if (this.variables.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.variables.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((Variable)this.variables.elementAt(i)).getContent();
        }
        return stringArray;
    }

    public Vector getVariablesVector() {
        return this.variables;
    }

    public static class Variable {
        private String key;
        private String value;

        public void setKey(String string) {
            this.key = string;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setPath(Path path) {
            this.value = path.toString();
        }

        public void setFile(File file) {
            this.value = file.getAbsolutePath();
        }

        public String getContent() throws BuildException {
            this.validate();
            StringBuffer stringBuffer = new StringBuffer(this.key.trim());
            stringBuffer.append("=").append(this.value.trim());
            return stringBuffer.toString();
        }

        public void validate() {
            if (this.key == null || this.value == null) {
                throw new BuildException("key and value must be specified for environment variables.");
            }
        }
    }
}

