/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import org.apache.tools.ant.BuildException;

public abstract class EnumeratedAttribute {
    protected String value;
    private int index = -1;

    public abstract String[] getValues();

    protected EnumeratedAttribute() {
    }

    public static EnumeratedAttribute getInstance(Class clazz, String string) throws BuildException {
        if (!EnumeratedAttribute.class.isAssignableFrom(clazz)) {
            throw new BuildException("You have to provide a subclass from EnumeratedAttribut as clazz-parameter.");
        }
        EnumeratedAttribute enumeratedAttribute = null;
        try {
            enumeratedAttribute = (EnumeratedAttribute)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new BuildException(exception);
        }
        enumeratedAttribute.setValue(string);
        return enumeratedAttribute;
    }

    public final void setValue(String string) throws BuildException {
        int n = this.indexOfValue(string);
        if (n == -1) {
            throw new BuildException(string + " is not a legal value for this attribute");
        }
        this.index = n;
        this.value = string;
    }

    public final boolean containsValue(String string) {
        return this.indexOfValue(string) != -1;
    }

    public final int indexOfValue(String string) {
        String[] stringArray = this.getValues();
        if (stringArray == null || string == null) {
            return -1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    public final String getValue() {
        return this.value;
    }

    public final int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.getValue();
    }
}

