/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.StringUtils;

public class Commandline
implements Cloneable {
    private static final boolean IS_WIN_9X = Os.isFamily("win9x");
    private Vector arguments = new Vector();
    private String executable = null;
    protected static final String DISCLAIMER = StringUtils.LINE_SEP + "The ' characters around the executable and arguments are" + StringUtils.LINE_SEP + "not part of the command." + StringUtils.LINE_SEP;

    public Commandline(String string) {
        String[] stringArray = Commandline.translateCommandline(string);
        if (stringArray != null && stringArray.length > 0) {
            this.setExecutable(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                this.createArgument().setValue(stringArray[i]);
            }
        }
    }

    public Commandline() {
    }

    public Argument createArgument() {
        return this.createArgument(false);
    }

    public Argument createArgument(boolean bl) {
        Argument argument = new Argument();
        if (bl) {
            this.arguments.insertElementAt(argument, 0);
        } else {
            this.arguments.addElement(argument);
        }
        return argument;
    }

    public void setExecutable(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.executable = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void addArguments(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.createArgument().setValue(stringArray[i]);
        }
    }

    public String[] getCommandline() {
        LinkedList linkedList = new LinkedList();
        ListIterator listIterator = linkedList.listIterator();
        this.addCommandToList(listIterator);
        String[] stringArray = new String[linkedList.size()];
        return linkedList.toArray(stringArray);
    }

    public void addCommandToList(ListIterator listIterator) {
        if (this.executable != null) {
            listIterator.add(this.executable);
        }
        this.addArgumentsToList(listIterator);
    }

    public String[] getArguments() {
        ArrayList arrayList = new ArrayList(this.arguments.size() * 2);
        this.addArgumentsToList(arrayList.listIterator());
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addArgumentsToList(ListIterator listIterator) {
        for (int i = 0; i < this.arguments.size(); ++i) {
            Argument argument = (Argument)this.arguments.elementAt(i);
            String[] stringArray = argument.getParts();
            if (stringArray == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                listIterator.add(stringArray[j]);
            }
        }
    }

    public String toString() {
        return Commandline.toString(this.getCommandline());
    }

    public static String quoteArgument(String string) {
        if (string.indexOf("\"") > -1) {
            if (string.indexOf("'") > -1) {
                throw new BuildException("Can't handle single and double quotes in same argument");
            }
            return '\'' + string + '\'';
        }
        if (string.indexOf("'") > -1 || string.indexOf(" ") > -1 || IS_WIN_9X && string.indexOf(59) != -1) {
            return '\"' + string + '\"';
        }
        return string;
    }

    public static String toString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(Commandline.quoteArgument(stringArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String[] translateCommandline(String string) {
        Object[] objectArray;
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"' ", true);
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        block4: while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            switch (n) {
                case 1: {
                    if ("'".equals(objectArray)) {
                        bl = true;
                        n = 0;
                        continue block4;
                    }
                    stringBuffer.append((String)objectArray);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(objectArray)) {
                        bl = true;
                        n = 0;
                        continue block4;
                    }
                    stringBuffer.append((String)objectArray);
                    continue block4;
                }
            }
            if ("'".equals(objectArray)) {
                n = 1;
            } else if ("\"".equals(objectArray)) {
                n = 2;
            } else if (" ".equals(objectArray)) {
                if (bl || stringBuffer.length() != 0) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                }
            } else {
                stringBuffer.append((String)objectArray);
            }
            bl = false;
        }
        if (bl || stringBuffer.length() != 0) {
            vector.addElement(stringBuffer.toString());
        }
        if (n == 1 || n == 2) {
            throw new BuildException("unbalanced quotes in " + string);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int size() {
        return this.getCommandline().length;
    }

    public Object clone() {
        try {
            Commandline commandline = (Commandline)super.clone();
            commandline.arguments = (Vector)this.arguments.clone();
            return commandline;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new BuildException(cloneNotSupportedException);
        }
    }

    public void clear() {
        this.executable = null;
        this.arguments.removeAllElements();
    }

    public void clearArgs() {
        this.arguments.removeAllElements();
    }

    public Marker createMarker() {
        return new Marker(this.arguments.size());
    }

    public String describeCommand() {
        return Commandline.describeCommand(this);
    }

    public String describeArguments() {
        return Commandline.describeArguments(this);
    }

    public static String describeCommand(Commandline commandline) {
        return Commandline.describeCommand(commandline.getCommandline());
    }

    public static String describeArguments(Commandline commandline) {
        return Commandline.describeArguments(commandline.getArguments());
    }

    public static String describeCommand(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("Executing '");
        stringBuffer.append(stringArray[0]);
        stringBuffer.append("'");
        if (stringArray.length > 1) {
            stringBuffer.append(" with ");
            stringBuffer.append(Commandline.describeArguments(stringArray, 1));
        } else {
            stringBuffer.append(DISCLAIMER);
        }
        return stringBuffer.toString();
    }

    public static String describeArguments(String[] stringArray) {
        return Commandline.describeArguments(stringArray, 0);
    }

    protected static String describeArguments(String[] stringArray, int n) {
        if (stringArray == null || stringArray.length <= n) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("argument");
        if (stringArray.length > n) {
            stringBuffer.append("s");
        }
        stringBuffer.append(":").append(StringUtils.LINE_SEP);
        for (int i = n; i < stringArray.length; ++i) {
            stringBuffer.append("'").append(stringArray[i]).append("'").append(StringUtils.LINE_SEP);
        }
        stringBuffer.append(DISCLAIMER);
        return stringBuffer.toString();
    }

    public Iterator iterator() {
        return this.arguments.iterator();
    }

    public class Marker {
        private int position;
        private int realPos = -1;

        Marker(int n) {
            this.position = n;
        }

        public int getPosition() {
            if (this.realPos == -1) {
                this.realPos = Commandline.this.executable == null ? 0 : 1;
                for (int i = 0; i < this.position; ++i) {
                    Argument argument = (Argument)Commandline.this.arguments.elementAt(i);
                    this.realPos += argument.getParts().length;
                }
            }
            return this.realPos;
        }
    }

    public static class Argument
    extends ProjectComponent {
        private String[] parts;

        public void setValue(String string) {
            this.parts = new String[]{string};
        }

        public void setLine(String string) {
            if (string == null) {
                return;
            }
            this.parts = Commandline.translateCommandline(string);
        }

        public void setPath(Path path) {
            this.parts = new String[]{path.toString()};
        }

        public void setPathref(Reference reference) {
            Path path = new Path(this.getProject());
            path.setRefid(reference);
            this.parts = new String[]{path.toString()};
        }

        public void setFile(File file) {
            this.parts = new String[]{file.getAbsolutePath()};
        }

        public String[] getParts() {
            return this.parts;
        }
    }
}

