/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.FileResourceIterator;

public abstract class ArchiveScanner
extends DirectoryScanner {
    protected File srcFile;
    private Resource src;
    private Resource lastScannedResource;
    private TreeMap fileEntries = new TreeMap();
    private TreeMap dirEntries = new TreeMap();
    private TreeMap matchFileEntries = new TreeMap();
    private TreeMap matchDirEntries = new TreeMap();
    private String encoding;

    @Override
    public void scan() {
        if (this.src == null) {
            return;
        }
        super.scan();
    }

    public void setSrc(File file) {
        this.setSrc(new FileResource(file));
    }

    public void setSrc(Resource resource) {
        this.src = resource;
        if (resource instanceof FileResource) {
            this.srcFile = ((FileResource)resource).getFile();
        }
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public String[] getIncludedFiles() {
        if (this.src == null) {
            return super.getIncludedFiles();
        }
        this.scanme();
        Set set = this.matchFileEntries.keySet();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public int getIncludedFilesCount() {
        if (this.src == null) {
            return super.getIncludedFilesCount();
        }
        this.scanme();
        return this.matchFileEntries.size();
    }

    @Override
    public String[] getIncludedDirectories() {
        if (this.src == null) {
            return super.getIncludedDirectories();
        }
        this.scanme();
        Set set = this.matchDirEntries.keySet();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public int getIncludedDirsCount() {
        if (this.src == null) {
            return super.getIncludedDirsCount();
        }
        this.scanme();
        return this.matchDirEntries.size();
    }

    Iterator getResourceFiles() {
        if (this.src == null) {
            return new FileResourceIterator(this.getBasedir(), this.getIncludedFiles());
        }
        this.scanme();
        return this.matchFileEntries.values().iterator();
    }

    Iterator getResourceDirectories() {
        if (this.src == null) {
            return new FileResourceIterator(this.getBasedir(), this.getIncludedDirectories());
        }
        this.scanme();
        return this.matchDirEntries.values().iterator();
    }

    public void init() {
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
    }

    public boolean match(String string) {
        String string2 = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return this.isIncluded(string2) && !this.isExcluded(string2);
    }

    @Override
    public Resource getResource(String string) {
        if (this.src == null) {
            return super.getResource(string);
        }
        if (string.equals("")) {
            return new Resource("", true, Long.MAX_VALUE, true);
        }
        this.scanme();
        if (this.fileEntries.containsKey(string)) {
            return (Resource)this.fileEntries.get(string);
        }
        if (this.dirEntries.containsKey(string = ArchiveScanner.trimSeparator(string))) {
            return (Resource)this.dirEntries.get(string);
        }
        return new Resource(string);
    }

    protected abstract void fillMapsFromArchive(Resource var1, String var2, Map var3, Map var4, Map var5, Map var6);

    private void scanme() {
        Resource resource = new Resource(this.src.getName(), this.src.isExists(), this.src.getLastModified());
        if (this.lastScannedResource != null && this.lastScannedResource.getName().equals(resource.getName()) && this.lastScannedResource.getLastModified() == resource.getLastModified()) {
            return;
        }
        this.init();
        this.fileEntries.clear();
        this.dirEntries.clear();
        this.matchFileEntries.clear();
        this.matchDirEntries.clear();
        this.fillMapsFromArchive(this.src, this.encoding, this.fileEntries, this.matchFileEntries, this.dirEntries, this.matchDirEntries);
        this.lastScannedResource = resource;
    }

    protected static final String trimSeparator(String string) {
        return string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
    }
}

