/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.ArchiveScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public abstract class ArchiveFileSet
extends FileSet {
    private static final int BASE_OCTAL = 8;
    public static final int DEFAULT_DIR_MODE = 16877;
    public static final int DEFAULT_FILE_MODE = 33188;
    private Resource src = null;
    private String prefix = "";
    private String fullpath = "";
    private boolean hasDir = false;
    private int fileMode = 33188;
    private int dirMode = 16877;
    private boolean fileModeHasBeenSet = false;
    private boolean dirModeHasBeenSet = false;

    public ArchiveFileSet() {
    }

    protected ArchiveFileSet(FileSet fileSet) {
        super(fileSet);
    }

    protected ArchiveFileSet(ArchiveFileSet archiveFileSet) {
        super(archiveFileSet);
        this.src = archiveFileSet.src;
        this.prefix = archiveFileSet.prefix;
        this.fullpath = archiveFileSet.fullpath;
        this.hasDir = archiveFileSet.hasDir;
        this.fileMode = archiveFileSet.fileMode;
        this.dirMode = archiveFileSet.dirMode;
        this.fileModeHasBeenSet = archiveFileSet.fileModeHasBeenSet;
        this.dirModeHasBeenSet = archiveFileSet.dirModeHasBeenSet;
    }

    @Override
    public void setDir(File file) throws BuildException {
        this.checkAttributesAllowed();
        if (this.src != null) {
            throw new BuildException("Cannot set both dir and src attributes");
        }
        super.setDir(file);
        this.hasDir = true;
    }

    public void addConfigured(ResourceCollection resourceCollection) {
        this.checkChildrenAllowed();
        if (resourceCollection.size() != 1) {
            throw new BuildException("only single argument resource collections are supported as archives");
        }
        this.setSrcResource((Resource)resourceCollection.iterator().next());
    }

    public void setSrc(File file) {
        this.setSrcResource(new FileResource(file));
    }

    public void setSrcResource(Resource resource) {
        this.checkArchiveAttributesAllowed();
        if (this.hasDir) {
            throw new BuildException("Cannot set both dir and src attributes");
        }
        this.src = resource;
    }

    public File getSrc(Project project) {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(project)).getSrc(project);
        }
        return this.getSrc();
    }

    public File getSrc() {
        if (this.src instanceof FileResource) {
            return ((FileResource)this.src).getFile();
        }
        return null;
    }

    public void setPrefix(String string) {
        this.checkArchiveAttributesAllowed();
        if (!"".equals(string) && !"".equals(this.fullpath)) {
            throw new BuildException("Cannot set both fullpath and prefix attributes");
        }
        this.prefix = string;
    }

    public String getPrefix(Project project) {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(project)).getPrefix(project);
        }
        return this.prefix;
    }

    public void setFullpath(String string) {
        this.checkArchiveAttributesAllowed();
        if (!"".equals(this.prefix) && !"".equals(string)) {
            throw new BuildException("Cannot set both fullpath and prefix attributes");
        }
        this.fullpath = string;
    }

    public String getFullpath(Project project) {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(project)).getFullpath(project);
        }
        return this.fullpath;
    }

    protected abstract ArchiveScanner newArchiveScanner();

    @Override
    public DirectoryScanner getDirectoryScanner(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getDirectoryScanner(project);
        }
        if (this.src == null) {
            return super.getDirectoryScanner(project);
        }
        if (!this.src.isExists()) {
            throw new BuildException("the archive " + this.src.getName() + " doesn't exist");
        }
        if (this.src.isDirectory()) {
            throw new BuildException("the archive " + this.src.getName() + " can't be a directory");
        }
        ArchiveScanner archiveScanner = this.newArchiveScanner();
        archiveScanner.setSrc(this.src);
        super.setDir(project.getBaseDir());
        this.setupDirectoryScanner(archiveScanner, project);
        archiveScanner.init();
        return archiveScanner;
    }

    @Override
    public Iterator iterator() {
        if (this.isReference()) {
            return ((ResourceCollection)((Object)this.getRef(this.getProject()))).iterator();
        }
        if (this.src == null) {
            return super.iterator();
        }
        ArchiveScanner archiveScanner = (ArchiveScanner)this.getDirectoryScanner(this.getProject());
        return archiveScanner.getResourceFiles();
    }

    @Override
    public int size() {
        if (this.isReference()) {
            return ((ResourceCollection)((Object)this.getRef(this.getProject()))).size();
        }
        if (this.src == null) {
            return super.size();
        }
        ArchiveScanner archiveScanner = (ArchiveScanner)this.getDirectoryScanner(this.getProject());
        return archiveScanner.getIncludedFilesCount();
    }

    @Override
    public boolean isFilesystemOnly() {
        return this.src == null;
    }

    public void setFileMode(String string) {
        this.checkArchiveAttributesAllowed();
        this.integerSetFileMode(Integer.parseInt(string, 8));
    }

    public void integerSetFileMode(int n) {
        this.fileModeHasBeenSet = true;
        this.fileMode = 0x8000 | n;
    }

    public int getFileMode(Project project) {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(project)).getFileMode(project);
        }
        return this.fileMode;
    }

    public boolean hasFileModeBeenSet() {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(this.getProject())).hasFileModeBeenSet();
        }
        return this.fileModeHasBeenSet;
    }

    public void setDirMode(String string) {
        this.checkArchiveAttributesAllowed();
        this.integerSetDirMode(Integer.parseInt(string, 8));
    }

    public void integerSetDirMode(int n) {
        this.dirModeHasBeenSet = true;
        this.dirMode = 0x4000 | n;
    }

    public int getDirMode(Project project) {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(project)).getDirMode(project);
        }
        return this.dirMode;
    }

    public boolean hasDirModeBeenSet() {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(this.getProject())).hasDirModeBeenSet();
        }
        return this.dirModeHasBeenSet;
    }

    protected void configureFileSet(ArchiveFileSet archiveFileSet) {
        archiveFileSet.setPrefix(this.prefix);
        archiveFileSet.setFullpath(this.fullpath);
        archiveFileSet.fileModeHasBeenSet = this.fileModeHasBeenSet;
        archiveFileSet.fileMode = this.fileMode;
        archiveFileSet.dirModeHasBeenSet = this.dirModeHasBeenSet;
        archiveFileSet.dirMode = this.dirMode;
    }

    @Override
    public Object clone() {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(this.getProject())).clone();
        }
        return super.clone();
    }

    @Override
    public String toString() {
        if (this.hasDir && this.getProject() != null) {
            return super.toString();
        }
        return this.src == null ? null : this.src.getName();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getFullpath() {
        return this.fullpath;
    }

    public int getFileMode() {
        return this.fileMode;
    }

    public int getDirMode() {
        return this.dirMode;
    }

    private void checkArchiveAttributesAllowed() {
        if (this.getProject() == null || this.isReference() && this.getRefid().getReferencedObject(this.getProject()) instanceof ArchiveFileSet) {
            this.checkAttributesAllowed();
        }
    }
}

