/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.selectors.AndSelector;
import org.apache.tools.ant.types.selectors.ContainsRegexpSelector;
import org.apache.tools.ant.types.selectors.ContainsSelector;
import org.apache.tools.ant.types.selectors.DateSelector;
import org.apache.tools.ant.types.selectors.DependSelector;
import org.apache.tools.ant.types.selectors.DepthSelector;
import org.apache.tools.ant.types.selectors.DifferentSelector;
import org.apache.tools.ant.types.selectors.ExtendSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.MajoritySelector;
import org.apache.tools.ant.types.selectors.NoneSelector;
import org.apache.tools.ant.types.selectors.NotSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.apache.tools.ant.types.selectors.PresentSelector;
import org.apache.tools.ant.types.selectors.SelectSelector;
import org.apache.tools.ant.types.selectors.SelectorContainer;
import org.apache.tools.ant.types.selectors.SelectorScanner;
import org.apache.tools.ant.types.selectors.SizeSelector;
import org.apache.tools.ant.types.selectors.TypeSelector;
import org.apache.tools.ant.types.selectors.modifiedselector.ModifiedSelector;

public abstract class AbstractFileSet
extends DataType
implements Cloneable,
SelectorContainer {
    private PatternSet defaultPatterns = new PatternSet();
    private Vector additionalPatterns = new Vector();
    private Vector selectors = new Vector();
    private File dir;
    private boolean useDefaultExcludes = true;
    private boolean caseSensitive = true;
    private boolean followSymlinks = true;
    private boolean errorOnMissingDir = true;
    private DirectoryScanner directoryScanner = null;

    public AbstractFileSet() {
    }

    protected AbstractFileSet(AbstractFileSet abstractFileSet) {
        this.dir = abstractFileSet.dir;
        this.defaultPatterns = abstractFileSet.defaultPatterns;
        this.additionalPatterns = abstractFileSet.additionalPatterns;
        this.selectors = abstractFileSet.selectors;
        this.useDefaultExcludes = abstractFileSet.useDefaultExcludes;
        this.caseSensitive = abstractFileSet.caseSensitive;
        this.followSymlinks = abstractFileSet.followSymlinks;
        this.errorOnMissingDir = abstractFileSet.errorOnMissingDir;
        this.setProject(abstractFileSet.getProject());
    }

    @Override
    public void setRefid(Reference reference) throws BuildException {
        if (this.dir != null || this.defaultPatterns.hasPatterns(this.getProject())) {
            throw this.tooManyAttributes();
        }
        if (!this.additionalPatterns.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        if (!this.selectors.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(reference);
    }

    public synchronized void setDir(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.dir = file;
        this.directoryScanner = null;
    }

    public File getDir() {
        return this.getDir(this.getProject());
    }

    public synchronized File getDir(Project project) {
        return this.isReference() ? this.getRef(project).getDir(project) : this.dir;
    }

    public synchronized PatternSet createPatternSet() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PatternSet patternSet = new PatternSet();
        this.additionalPatterns.addElement(patternSet);
        this.directoryScanner = null;
        return patternSet;
    }

    public synchronized PatternSet.NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.directoryScanner = null;
        return this.defaultPatterns.createInclude();
    }

    public synchronized PatternSet.NameEntry createIncludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.directoryScanner = null;
        return this.defaultPatterns.createIncludesFile();
    }

    public synchronized PatternSet.NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.directoryScanner = null;
        return this.defaultPatterns.createExclude();
    }

    public synchronized PatternSet.NameEntry createExcludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.directoryScanner = null;
        return this.defaultPatterns.createExcludesFile();
    }

    public synchronized void setFile(File file) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.setDir(file.getParentFile());
        this.createInclude().setName(file.getName());
    }

    public synchronized void setIncludes(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setIncludes(string);
        this.directoryScanner = null;
    }

    public synchronized void appendIncludes(String[] stringArray) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.defaultPatterns.createInclude().setName(stringArray[i]);
            }
            this.directoryScanner = null;
        }
    }

    public synchronized void setExcludes(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setExcludes(string);
        this.directoryScanner = null;
    }

    public synchronized void appendExcludes(String[] stringArray) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.defaultPatterns.createExclude().setName(stringArray[i]);
            }
            this.directoryScanner = null;
        }
    }

    public synchronized void setIncludesfile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setIncludesfile(file);
        this.directoryScanner = null;
    }

    public synchronized void setExcludesfile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setExcludesfile(file);
        this.directoryScanner = null;
    }

    public synchronized void setDefaultexcludes(boolean bl) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.useDefaultExcludes = bl;
        this.directoryScanner = null;
    }

    public synchronized boolean getDefaultexcludes() {
        return this.isReference() ? this.getRef(this.getProject()).getDefaultexcludes() : this.useDefaultExcludes;
    }

    public synchronized void setCaseSensitive(boolean bl) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.caseSensitive = bl;
        this.directoryScanner = null;
    }

    public synchronized boolean isCaseSensitive() {
        return this.isReference() ? this.getRef(this.getProject()).isCaseSensitive() : this.caseSensitive;
    }

    public synchronized void setFollowSymlinks(boolean bl) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.followSymlinks = bl;
        this.directoryScanner = null;
    }

    public synchronized boolean isFollowSymlinks() {
        return this.isReference() ? this.getRef(this.getProject()).isFollowSymlinks() : this.followSymlinks;
    }

    public void setErrorOnMissingDir(boolean bl) {
        this.errorOnMissingDir = bl;
    }

    public DirectoryScanner getDirectoryScanner() {
        return this.getDirectoryScanner(this.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryScanner getDirectoryScanner(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getDirectoryScanner(project);
        }
        DirectoryScanner directoryScanner = null;
        AbstractFileSet abstractFileSet = this;
        synchronized (abstractFileSet) {
            if (this.directoryScanner != null && project == this.getProject()) {
                directoryScanner = this.directoryScanner;
            } else {
                if (this.dir == null) {
                    throw new BuildException("No directory specified for " + this.getDataTypeName() + ".");
                }
                if (!this.dir.exists() && this.errorOnMissingDir) {
                    throw new BuildException(this.dir.getAbsolutePath() + " not found.");
                }
                if (!this.dir.isDirectory() && this.dir.exists()) {
                    throw new BuildException(this.dir.getAbsolutePath() + " is not a directory.");
                }
                directoryScanner = new DirectoryScanner();
                this.setupDirectoryScanner(directoryScanner, project);
                directoryScanner.setFollowSymlinks(this.followSymlinks);
                directoryScanner.setErrorOnMissingDir(this.errorOnMissingDir);
                this.directoryScanner = project == this.getProject() ? directoryScanner : this.directoryScanner;
            }
        }
        directoryScanner.scan();
        return directoryScanner;
    }

    public void setupDirectoryScanner(FileScanner fileScanner) {
        this.setupDirectoryScanner(fileScanner, this.getProject());
    }

    public synchronized void setupDirectoryScanner(FileScanner fileScanner, Project project) {
        if (this.isReference()) {
            this.getRef(project).setupDirectoryScanner(fileScanner, project);
            return;
        }
        if (fileScanner == null) {
            throw new IllegalArgumentException("ds cannot be null");
        }
        fileScanner.setBasedir(this.dir);
        PatternSet patternSet = this.mergePatterns(project);
        project.log(this.getDataTypeName() + ": Setup scanner in dir " + this.dir + " with " + patternSet, 4);
        fileScanner.setIncludes(patternSet.getIncludePatterns(project));
        fileScanner.setExcludes(patternSet.getExcludePatterns(project));
        if (fileScanner instanceof SelectorScanner) {
            SelectorScanner selectorScanner = (SelectorScanner)((Object)fileScanner);
            selectorScanner.setSelectors(this.getSelectors(project));
        }
        if (this.useDefaultExcludes) {
            fileScanner.addDefaultExcludes();
        }
        fileScanner.setCaseSensitive(this.caseSensitive);
    }

    protected AbstractFileSet getRef(Project project) {
        return (AbstractFileSet)this.getCheckedRef(project);
    }

    @Override
    public synchronized boolean hasSelectors() {
        return this.isReference() && this.getProject() != null ? this.getRef(this.getProject()).hasSelectors() : !this.selectors.isEmpty();
    }

    public synchronized boolean hasPatterns() {
        if (this.isReference() && this.getProject() != null) {
            return this.getRef(this.getProject()).hasPatterns();
        }
        if (this.defaultPatterns.hasPatterns(this.getProject())) {
            return true;
        }
        Enumeration enumeration = this.additionalPatterns.elements();
        while (enumeration.hasMoreElements()) {
            PatternSet patternSet = (PatternSet)enumeration.nextElement();
            if (!patternSet.hasPatterns(this.getProject())) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized int selectorCount() {
        return this.isReference() && this.getProject() != null ? this.getRef(this.getProject()).selectorCount() : this.selectors.size();
    }

    @Override
    public synchronized FileSelector[] getSelectors(Project project) {
        return this.isReference() ? this.getRef(project).getSelectors(project) : this.selectors.toArray(new FileSelector[this.selectors.size()]);
    }

    @Override
    public synchronized Enumeration selectorElements() {
        return this.isReference() && this.getProject() != null ? this.getRef(this.getProject()).selectorElements() : this.selectors.elements();
    }

    @Override
    public synchronized void appendSelector(FileSelector fileSelector) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.selectors.addElement(fileSelector);
        this.directoryScanner = null;
    }

    @Override
    public void addSelector(SelectSelector selectSelector) {
        this.appendSelector(selectSelector);
    }

    @Override
    public void addAnd(AndSelector andSelector) {
        this.appendSelector(andSelector);
    }

    @Override
    public void addOr(OrSelector orSelector) {
        this.appendSelector(orSelector);
    }

    @Override
    public void addNot(NotSelector notSelector) {
        this.appendSelector(notSelector);
    }

    @Override
    public void addNone(NoneSelector noneSelector) {
        this.appendSelector(noneSelector);
    }

    @Override
    public void addMajority(MajoritySelector majoritySelector) {
        this.appendSelector(majoritySelector);
    }

    @Override
    public void addDate(DateSelector dateSelector) {
        this.appendSelector(dateSelector);
    }

    @Override
    public void addSize(SizeSelector sizeSelector) {
        this.appendSelector(sizeSelector);
    }

    @Override
    public void addDifferent(DifferentSelector differentSelector) {
        this.appendSelector(differentSelector);
    }

    @Override
    public void addFilename(FilenameSelector filenameSelector) {
        this.appendSelector(filenameSelector);
    }

    @Override
    public void addType(TypeSelector typeSelector) {
        this.appendSelector(typeSelector);
    }

    @Override
    public void addCustom(ExtendSelector extendSelector) {
        this.appendSelector(extendSelector);
    }

    @Override
    public void addContains(ContainsSelector containsSelector) {
        this.appendSelector(containsSelector);
    }

    @Override
    public void addPresent(PresentSelector presentSelector) {
        this.appendSelector(presentSelector);
    }

    @Override
    public void addDepth(DepthSelector depthSelector) {
        this.appendSelector(depthSelector);
    }

    @Override
    public void addDepend(DependSelector dependSelector) {
        this.appendSelector(dependSelector);
    }

    @Override
    public void addContainsRegexp(ContainsRegexpSelector containsRegexpSelector) {
        this.appendSelector(containsRegexpSelector);
    }

    @Override
    public void addModified(ModifiedSelector modifiedSelector) {
        this.appendSelector(modifiedSelector);
    }

    @Override
    public void add(FileSelector fileSelector) {
        this.appendSelector(fileSelector);
    }

    @Override
    public String toString() {
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    @Override
    public synchronized Object clone() {
        if (this.isReference()) {
            return this.getRef(this.getProject()).clone();
        }
        try {
            AbstractFileSet abstractFileSet = (AbstractFileSet)super.clone();
            abstractFileSet.defaultPatterns = (PatternSet)this.defaultPatterns.clone();
            abstractFileSet.additionalPatterns = new Vector(this.additionalPatterns.size());
            Enumeration enumeration = this.additionalPatterns.elements();
            while (enumeration.hasMoreElements()) {
                abstractFileSet.additionalPatterns.addElement(((PatternSet)enumeration.nextElement()).clone());
            }
            abstractFileSet.selectors = new Vector(this.selectors);
            return abstractFileSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new BuildException(cloneNotSupportedException);
        }
    }

    public String[] mergeIncludes(Project project) {
        return this.mergePatterns(project).getIncludePatterns(project);
    }

    public String[] mergeExcludes(Project project) {
        return this.mergePatterns(project).getExcludePatterns(project);
    }

    public synchronized PatternSet mergePatterns(Project project) {
        if (this.isReference()) {
            return this.getRef(project).mergePatterns(project);
        }
        PatternSet patternSet = (PatternSet)this.defaultPatterns.clone();
        int n = this.additionalPatterns.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.additionalPatterns.elementAt(i);
            patternSet.append((PatternSet)e, project);
        }
        return patternSet;
    }
}

