/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.rmic;

import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.rmic.DefaultRmicAdapter;
import org.apache.tools.ant.types.Commandline;

public class WLRmic
extends DefaultRmicAdapter {
    public static final String WLRMIC_CLASSNAME = "weblogic.rmic";
    public static final String COMPILER_NAME = "weblogic";
    public static final String ERROR_NO_WLRMIC_ON_CLASSPATH = "Cannot use WebLogic rmic, as it is not available. Add it to Ant's classpath with the -lib option";
    public static final String ERROR_WLRMIC_FAILED = "Error starting WebLogic rmic: ";
    public static final String WL_RMI_STUB_SUFFIX = "_WLStub";
    public static final String WL_RMI_SKEL_SUFFIX = "_WLSkel";
    public static final String UNSUPPORTED_STUB_OPTION = "Unsupported stub option: ";

    @Override
    public boolean execute() throws BuildException {
        this.getRmic().log("Using WebLogic rmic", 3);
        Commandline commandline = this.setupRmicCommand(new String[]{"-noexit"});
        AntClassLoader antClassLoader = null;
        try {
            Class<?> clazz = null;
            if (this.getRmic().getClasspath() == null) {
                clazz = Class.forName(WLRMIC_CLASSNAME);
            } else {
                antClassLoader = this.getRmic().getProject().createClassLoader(this.getRmic().getClasspath());
                clazz = Class.forName(WLRMIC_CLASSNAME, true, antClassLoader);
            }
            Method method = clazz.getMethod("main", String[].class);
            method.invoke(null, new Object[]{commandline.getArguments()});
            boolean bl = true;
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException(ERROR_NO_WLRMIC_ON_CLASSPATH, this.getRmic().getLocation());
        }
        catch (Exception exception) {
            if (exception instanceof BuildException) {
                throw (BuildException)exception;
            }
            throw new BuildException(ERROR_WLRMIC_FAILED, exception, this.getRmic().getLocation());
        }
        finally {
            if (antClassLoader != null) {
                antClassLoader.cleanup();
            }
        }
    }

    @Override
    public String getStubClassSuffix() {
        return WL_RMI_STUB_SUFFIX;
    }

    @Override
    public String getSkelClassSuffix() {
        return WL_RMI_SKEL_SUFFIX;
    }

    @Override
    protected String[] preprocessCompilerArgs(String[] stringArray) {
        return this.filterJvmCompilerArgs(stringArray);
    }

    @Override
    protected String addStubVersionOptions() {
        String string = this.getRmic().getStubVersion();
        if (null != string) {
            this.getRmic().log(UNSUPPORTED_STUB_OPTION + string, 1);
        }
        return null;
    }
}

