/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.rmic;

import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.rmic.ForkingSunRmic;
import org.apache.tools.ant.taskdefs.rmic.KaffeRmic;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapter;
import org.apache.tools.ant.taskdefs.rmic.SunRmic;
import org.apache.tools.ant.taskdefs.rmic.WLRmic;
import org.apache.tools.ant.taskdefs.rmic.XNewRmic;
import org.apache.tools.ant.util.ClasspathUtils;

public final class RmicAdapterFactory {
    public static final String ERROR_UNKNOWN_COMPILER = "Class not found: ";
    public static final String ERROR_NOT_RMIC_ADAPTER = "Class of unexpected Type: ";
    public static final String DEFAULT_COMPILER = "default";

    private RmicAdapterFactory() {
    }

    public static RmicAdapter getRmic(String string, Task task) throws BuildException {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (DEFAULT_COMPILER.equals(string2) || string2.length() == 0) {
            String string3 = string2 = KaffeRmic.isAvailable() ? "kaffe" : "sun";
        }
        if ("sun".equals(string2)) {
            return new SunRmic();
        }
        if ("kaffe".equals(string2)) {
            return new KaffeRmic();
        }
        if ("weblogic".equals(string2)) {
            return new WLRmic();
        }
        if ("forking".equals(string2)) {
            return new ForkingSunRmic();
        }
        if ("xnew".equals(string2)) {
            return new XNewRmic();
        }
        return RmicAdapterFactory.resolveClassName(string);
    }

    private static RmicAdapter resolveClassName(String string) throws BuildException {
        return (RmicAdapter)ClasspathUtils.newInstance(string, RmicAdapterFactory.class.getClassLoader(), RmicAdapter.class);
    }
}

