/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.ResourceUtils;

public class ResourcesMatch
implements Condition {
    private Union resources = null;
    private boolean asText = false;

    public void setAsText(boolean bl) {
        this.asText = bl;
    }

    public void add(ResourceCollection resourceCollection) {
        if (resourceCollection == null) {
            return;
        }
        this.resources = this.resources == null ? new Union() : this.resources;
        this.resources.add(resourceCollection);
    }

    @Override
    public boolean eval() throws BuildException {
        if (this.resources == null) {
            throw new BuildException("You must specify one or more nested resource collections");
        }
        if (this.resources.size() > 1) {
            Iterator iterator = this.resources.iterator();
            Resource resource = (Resource)iterator.next();
            Resource resource2 = null;
            while (iterator.hasNext()) {
                resource2 = (Resource)iterator.next();
                try {
                    if (!ResourceUtils.contentEquals(resource, resource2, this.asText)) {
                        return false;
                    }
                }
                catch (IOException iOException) {
                    throw new BuildException("when comparing resources " + resource.toString() + " and " + resource2.toString(), iOException);
                }
                resource = resource2;
            }
        }
        return true;
    }
}

