/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class IsSigned
extends DataType
implements Condition {
    private static final String SIG_START = "META-INF/";
    private static final String SIG_END = ".SF";
    private static final int SHORT_SIG_LIMIT = 8;
    private String name;
    private File file;

    public void setFile(File file) {
        this.file = file;
    }

    public void setName(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSigned(File file, String string) throws IOException {
        boolean bl;
        ZipFile zipFile;
        block8: {
            boolean bl2;
            zipFile = null;
            try {
                Enumeration enumeration;
                zipFile = new ZipFile(file);
                if (null == string) {
                    enumeration = zipFile.getEntries();
                } else {
                    boolean bl3 = zipFile.getEntry(SIG_START + string.toUpperCase() + SIG_END) != null;
                    boolean bl4 = false;
                    if (string.length() > 8) {
                        bl4 = zipFile.getEntry(SIG_START + string.substring(0, 8).toUpperCase() + SIG_END) != null;
                    }
                    boolean bl5 = bl3 || bl4;
                    ZipFile.closeQuietly(zipFile);
                    return bl5;
                }
                while (enumeration.hasMoreElements()) {
                    String string2 = ((ZipEntry)enumeration.nextElement()).getName();
                    if (!string2.startsWith(SIG_START) || !string2.endsWith(SIG_END)) continue;
                    bl = true;
                    break block8;
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                ZipFile.closeQuietly(zipFile);
                throw throwable;
            }
            ZipFile.closeQuietly(zipFile);
            return bl2;
        }
        ZipFile.closeQuietly(zipFile);
        return bl;
    }

    @Override
    public boolean eval() {
        if (this.file == null) {
            throw new BuildException("The file attribute must be set.");
        }
        if (!this.file.exists()) {
            this.log("The file \"" + this.file.getAbsolutePath() + "\" does not exist.", 3);
            return false;
        }
        boolean bl = false;
        try {
            bl = IsSigned.isSigned(this.file, this.name);
        }
        catch (IOException iOException) {
            this.log("Got IOException reading file \"" + this.file.getAbsolutePath() + "\"" + iOException, 1);
        }
        if (bl) {
            this.log("File \"" + this.file.getAbsolutePath() + "\" is signed.", 3);
        }
        return bl;
    }
}

