/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class IsReachable
extends ProjectComponent
implements Condition {
    private static final int SECOND = 1000;
    private String host;
    private String url;
    public static final int DEFAULT_TIMEOUT = 30;
    private int timeout = 30;
    public static final String ERROR_NO_HOSTNAME = "No hostname defined";
    public static final String ERROR_BAD_TIMEOUT = "Invalid timeout value";
    private static final String WARN_UNKNOWN_HOST = "Unknown host: ";
    public static final String ERROR_ON_NETWORK = "network error to ";
    public static final String ERROR_BOTH_TARGETS = "Both url and host have been specified";
    public static final String MSG_NO_REACHABLE_TEST = "cannot do a proper reachability test on this Java version";
    public static final String ERROR_BAD_URL = "Bad URL ";
    public static final String ERROR_NO_HOST_IN_URL = "No hostname in URL ";
    public static final String METHOD_NAME = "isReachable";
    private static Class[] parameterTypes = new Class[]{Integer.TYPE};

    public void setHost(String string) {
        this.host = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    private boolean empty(String string) {
        return string == null || string.length() == 0;
    }

    @Override
    public boolean eval() throws BuildException {
        boolean bl;
        Serializable serializable;
        if (this.empty(this.host) && this.empty(this.url)) {
            throw new BuildException(ERROR_NO_HOSTNAME);
        }
        if (this.timeout < 0) {
            throw new BuildException(ERROR_BAD_TIMEOUT);
        }
        String string = this.host;
        if (!this.empty(this.url)) {
            if (!this.empty(this.host)) {
                throw new BuildException(ERROR_BOTH_TARGETS);
            }
            try {
                serializable = new URL(this.url);
                string = ((URL)serializable).getHost();
                if (this.empty(string)) {
                    throw new BuildException(ERROR_NO_HOST_IN_URL + this.url);
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new BuildException(ERROR_BAD_URL + this.url, malformedURLException);
            }
        }
        this.log("Probing host " + string, 3);
        try {
            serializable = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            this.log(WARN_UNKNOWN_HOST + string);
            return false;
        }
        this.log("Host address = " + ((InetAddress)serializable).getHostAddress(), 3);
        Method method = null;
        try {
            method = InetAddress.class.getMethod(METHOD_NAME, parameterTypes);
            Object[] objectArray = new Object[]{new Integer(this.timeout * 1000)};
            try {
                bl = (Boolean)method.invoke((Object)serializable, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new BuildException("When calling " + method);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                this.log(ERROR_ON_NETWORK + string + ": " + throwable.toString());
                bl = false;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.log("Not found: InetAddress.isReachable", 3);
            this.log(MSG_NO_REACHABLE_TEST);
            bl = true;
        }
        this.log("host is" + (bl ? "" : " not") + " reachable", 3);
        return bl;
    }
}

