/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class HasMethod
extends ProjectComponent
implements Condition {
    private String classname;
    private String method;
    private String field;
    private Path classpath;
    private AntClassLoader loader;
    private boolean ignoreSystemClasses = false;

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public void setField(String string) {
        this.field = string;
    }

    public void setIgnoreSystemClasses(boolean bl) {
        this.ignoreSystemClasses = bl;
    }

    private Class loadClass(String string) {
        try {
            if (this.ignoreSystemClasses) {
                this.loader = this.getProject().createClassLoader(this.classpath);
                this.loader.setParentFirst(false);
                this.loader.addJavaLibraries();
                if (this.loader != null) {
                    try {
                        return this.loader.findClass(string);
                    }
                    catch (SecurityException securityException) {
                        return null;
                    }
                }
                return null;
            }
            if (this.loader != null) {
                return this.loader.loadClass(string);
            }
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader != null) {
                return Class.forName(string, true, classLoader);
            }
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException("class \"" + string + "\" was not found");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new BuildException("Could not load dependent class \"" + noClassDefFoundError.getMessage() + "\" for class \"" + string + "\"");
        }
    }

    @Override
    public boolean eval() throws BuildException {
        if (this.classname == null) {
            throw new BuildException("No classname defined");
        }
        Class clazz = this.loadClass(this.classname);
        if (this.method != null) {
            return this.isMethodFound(clazz);
        }
        if (this.field != null) {
            return this.isFieldFound(clazz);
        }
        throw new BuildException("Neither method nor field defined");
    }

    private boolean isFieldFound(Class clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (!field.getName().equals(this.field)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodFound(Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().equals(this.method)) continue;
            return true;
        }
        return false;
    }
}

