/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.util.FileUtils;

public class FilesMatch
implements Condition {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File file1;
    private File file2;
    private boolean textfile = false;

    public void setFile1(File file) {
        this.file1 = file;
    }

    public void setFile2(File file) {
        this.file2 = file;
    }

    public void setTextfile(boolean bl) {
        this.textfile = bl;
    }

    @Override
    public boolean eval() throws BuildException {
        if (this.file1 == null || this.file2 == null) {
            throw new BuildException("both file1 and file2 are required in filesmatch");
        }
        boolean bl = false;
        try {
            bl = FILE_UTILS.contentEquals(this.file1, this.file2, this.textfile);
        }
        catch (IOException iOException) {
            throw new BuildException("when comparing files: " + iOException.getMessage(), iOException);
        }
        return bl;
    }
}

