/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.util.DeweyDecimal;

public class AntVersion
extends Task
implements Condition {
    private String atLeast = null;
    private String exactly = null;
    private String propertyname = null;

    @Override
    public void execute() throws BuildException {
        if (this.propertyname == null) {
            throw new BuildException("'property' must be set.");
        }
        if (this.atLeast != null || this.exactly != null) {
            if (this.eval()) {
                this.getProject().setNewProperty(this.propertyname, this.getVersion().toString());
            }
        } else {
            this.getProject().setNewProperty(this.propertyname, this.getVersion().toString());
        }
    }

    @Override
    public boolean eval() throws BuildException {
        this.validate();
        DeweyDecimal deweyDecimal = this.getVersion();
        if (null != this.atLeast) {
            return deweyDecimal.isGreaterThanOrEqual(new DeweyDecimal(this.atLeast));
        }
        if (null != this.exactly) {
            return deweyDecimal.isEqual(new DeweyDecimal(this.exactly));
        }
        return false;
    }

    private void validate() throws BuildException {
        if (this.atLeast != null && this.exactly != null) {
            throw new BuildException("Only one of atleast or exactly may be set.");
        }
        if (null == this.atLeast && null == this.exactly) {
            throw new BuildException("One of atleast or exactly must be set.");
        }
        if (this.atLeast != null) {
            try {
                new DeweyDecimal(this.atLeast);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BuildException("The 'atleast' attribute is not a Dewey Decimal eg 1.1.0 : " + this.atLeast);
            }
        }
        try {
            new DeweyDecimal(this.exactly);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("The 'exactly' attribute is not a Dewey Decimal eg 1.1.0 : " + this.exactly);
        }
    }

    private DeweyDecimal getVersion() {
        Project project = new Project();
        project.init();
        char[] cArray = project.getProperty("ant.version").toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isDigit(cArray[i])) {
                stringBuffer.append(cArray[i]);
                bl = true;
            }
            if (cArray[i] == '.' && bl) {
                stringBuffer.append(cArray[i]);
            }
            if (Character.isLetter(cArray[i]) && bl) break;
        }
        return new DeweyDecimal(stringBuffer.toString());
    }

    public String getAtLeast() {
        return this.atLeast;
    }

    public void setAtLeast(String string) {
        this.atLeast = string;
    }

    public String getExactly() {
        return this.exactly;
    }

    public void setExactly(String string) {
        this.exactly = string;
    }

    public String getProperty() {
        return this.propertyname;
    }

    public void setProperty(String string) {
        this.propertyname = string;
    }
}

