/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class Jikes
extends DefaultCompilerAdapter {
    @Override
    public boolean execute() throws BuildException {
        String string;
        String string2;
        this.attributes.log("Using jikes compiler", 3);
        Commandline commandline = new Commandline();
        Path path = null;
        path = this.compileSourcepath != null ? this.compileSourcepath : this.src;
        if (path.size() > 0) {
            commandline.createArgument().setValue("-sourcepath");
            commandline.createArgument().setPath(path);
        }
        Path path2 = new Path(this.project);
        if (this.bootclasspath == null || this.bootclasspath.size() == 0) {
            this.includeJavaRuntime = true;
        }
        path2.append(this.getCompileClasspath());
        String string3 = System.getProperty("jikes.class.path");
        if (string3 != null) {
            path2.append(new Path(this.project, string3));
        }
        if (this.extdirs != null && this.extdirs.size() > 0) {
            commandline.createArgument().setValue("-extdirs");
            commandline.createArgument().setPath(this.extdirs);
        }
        commandline.setExecutable((string2 = this.getJavac().getExecutable()) == null ? "jikes" : string2);
        if (this.deprecation) {
            commandline.createArgument().setValue("-deprecation");
        }
        if (this.destDir != null) {
            commandline.createArgument().setValue("-d");
            commandline.createArgument().setFile(this.destDir);
        }
        commandline.createArgument().setValue("-classpath");
        commandline.createArgument().setPath(path2);
        if (this.encoding != null) {
            commandline.createArgument().setValue("-encoding");
            commandline.createArgument().setValue(this.encoding);
        }
        if (this.debug) {
            string = this.attributes.getDebugLevel();
            if (string != null) {
                commandline.createArgument().setValue("-g:" + string);
            } else {
                commandline.createArgument().setValue("-g");
            }
        } else {
            commandline.createArgument().setValue("-g:none");
        }
        if (this.optimize) {
            commandline.createArgument().setValue("-O");
        }
        if (this.verbose) {
            commandline.createArgument().setValue("-verbose");
        }
        if (this.depend) {
            commandline.createArgument().setValue("-depend");
        }
        if (this.target != null) {
            commandline.createArgument().setValue("-target");
            commandline.createArgument().setValue(this.target);
        }
        this.addPropertyParams(commandline);
        if (this.attributes.getSource() != null) {
            commandline.createArgument().setValue("-source");
            string = this.attributes.getSource();
            if (string.equals("1.1") || string.equals("1.2")) {
                this.attributes.log("Jikes doesn't support '-source " + string + "', will use '-source 1.3' instead");
                commandline.createArgument().setValue("1.3");
            } else {
                commandline.createArgument().setValue(string);
            }
        }
        this.addCurrentCompilerArgs(commandline);
        int n = commandline.size();
        Path path3 = this.getBootClassPath();
        if (path3.size() > 0) {
            commandline.createArgument().setValue("-bootclasspath");
            commandline.createArgument().setPath(path3);
        }
        this.logAndAddFilesToCompile(commandline);
        return this.executeExternalCompile(commandline.getCommandline(), n) == 0;
    }

    private void addPropertyParams(Commandline commandline) {
        String string;
        String string2;
        String string3;
        String string4 = this.project.getProperty("build.compiler.emacs");
        if (string4 != null && Project.toBoolean(string4)) {
            commandline.createArgument().setValue("+E");
        }
        if ((string3 = this.project.getProperty("build.compiler.warnings")) != null) {
            this.attributes.log("!! the build.compiler.warnings property is deprecated. !!", 1);
            this.attributes.log("!! Use the nowarn attribute instead. !!", 1);
            if (!Project.toBoolean(string3)) {
                commandline.createArgument().setValue("-nowarn");
            }
        }
        if (this.attributes.getNowarn()) {
            commandline.createArgument().setValue("-nowarn");
        }
        if ((string2 = this.project.getProperty("build.compiler.pedantic")) != null && Project.toBoolean(string2)) {
            commandline.createArgument().setValue("+P");
        }
        if ((string = this.project.getProperty("build.compiler.fulldepend")) != null && Project.toBoolean(string)) {
            commandline.createArgument().setValue("+F");
        }
    }
}

