/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public class JavacExternal
extends DefaultCompilerAdapter {
    @Override
    public boolean execute() throws BuildException {
        this.attributes.log("Using external javac compiler", 3);
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.getJavac().getJavacExecutable());
        if (!this.assumeJava11() && !this.assumeJava12()) {
            this.setupModernJavacCommandlineSwitches(commandline);
        } else {
            this.setupJavacCommandlineSwitches(commandline, true);
        }
        int n = this.assumeJava11() ? -1 : commandline.size();
        this.logAndAddFilesToCompile(commandline);
        if (Os.isFamily("openvms")) {
            return this.execOnVMS(commandline, n);
        }
        return this.executeExternalCompile(commandline.getCommandline(), n, true) == 0;
    }

    private boolean execOnVMS(Commandline commandline, int n) {
        File file = null;
        try {
            file = JavaEnvUtils.createVmsJavaOptionFile(commandline.getArguments());
            String[] stringArray = new String[]{commandline.getExecutable(), "-V", file.getPath()};
            boolean bl = 0 == this.executeExternalCompile(stringArray, n, true);
            return bl;
        }
        catch (IOException iOException) {
            throw new BuildException("Failed to create a temporary file for \"-V\" switch");
        }
        finally {
            FileUtils.delete(file);
        }
    }
}

