/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Javac12
extends DefaultCompilerAdapter {
    protected static final String CLASSIC_COMPILER_CLASSNAME = "sun.tools.javac.Main";

    @Override
    public boolean execute() throws BuildException {
        this.attributes.log("Using classic compiler", 3);
        Commandline commandline = this.setupJavacCommand(true);
        LogOutputStream logOutputStream = new LogOutputStream(this.attributes, 1);
        try {
            Class<?> clazz = Class.forName(CLASSIC_COMPILER_CLASSNAME);
            Constructor<?> constructor = clazz.getConstructor(OutputStream.class, String.class);
            Object obj = constructor.newInstance(logOutputStream, "javac");
            Method method = clazz.getMethod("compile", String[].class);
            Boolean bl = (Boolean)method.invoke(obj, new Object[]{commandline.getArguments()});
            boolean bl2 = bl;
            return bl2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException("Cannot use classic compiler , as it is not available. \n A common solution is to set the environment variable JAVA_HOME to your jdk directory.\nIt is currently set to \"" + JavaEnvUtils.getJavaHome() + "\"", this.location);
        }
        catch (Exception exception) {
            if (exception instanceof BuildException) {
                throw (BuildException)exception;
            }
            throw new BuildException("Error starting classic compiler: ", exception, this.location);
        }
        finally {
            FileUtils.close(logOutputStream);
        }
    }
}

