/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipOutputStream;

public class War
extends Jar {
    private File deploymentDescriptor;
    private boolean needxmlfile = true;
    private File addedWebXmlFile;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final String XML_DESCRIPTOR_PATH = "WEB-INF/web.xml";
    private static final String XML_DESCRIPTOR_PATH_LC = "WEB-INF/web.xml".toLowerCase(Locale.ENGLISH);

    public War() {
        this.archiveType = "war";
        this.emptyBehavior = "create";
    }

    public void setWarfile(File file) {
        this.setDestFile(file);
    }

    public void setWebxml(File file) {
        this.deploymentDescriptor = file;
        if (!this.deploymentDescriptor.exists()) {
            throw new BuildException("Deployment descriptor: " + this.deploymentDescriptor + " does not exist.");
        }
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setFile(this.deploymentDescriptor);
        zipFileSet.setFullpath(XML_DESCRIPTOR_PATH);
        super.addFileset(zipFileSet);
    }

    public void setNeedxmlfile(boolean bl) {
        this.needxmlfile = bl;
    }

    public void addLib(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("WEB-INF/lib/");
        super.addFileset(zipFileSet);
    }

    public void addClasses(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("WEB-INF/classes/");
        super.addFileset(zipFileSet);
    }

    public void addWebinf(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("WEB-INF/");
        super.addFileset(zipFileSet);
    }

    @Override
    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        super.initZipOutputStream(zipOutputStream);
    }

    @Override
    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string, int n) throws IOException {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        boolean bl = true;
        if (XML_DESCRIPTOR_PATH_LC.equals(string2)) {
            if (this.addedWebXmlFile != null) {
                bl = false;
                if (!FILE_UTILS.fileNameEquals(this.addedWebXmlFile, file)) {
                    this.log("Warning: selected " + this.archiveType + " files include a second " + XML_DESCRIPTOR_PATH + " which will be ignored.\n" + "The duplicate entry is at " + file + '\n' + "The file that will be used is " + this.addedWebXmlFile, 1);
                }
            } else {
                this.addedWebXmlFile = file;
                bl = true;
                this.deploymentDescriptor = file;
            }
        }
        if (bl) {
            super.zipFile(file, zipOutputStream, string, n);
        }
    }

    @Override
    protected void cleanUp() {
        if (this.addedWebXmlFile == null && this.deploymentDescriptor == null && this.needxmlfile && !this.isInUpdateMode() && this.hasUpdatedFile()) {
            throw new BuildException("No WEB-INF/web.xml file was added.\nIf this is your intent, set needxmlfile='false' ");
        }
        this.addedWebXmlFile = null;
        super.cleanUp();
    }
}

