/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.taskdefs.AbstractJarSignerTask;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.RedirectorElement;
import org.apache.tools.ant.types.resources.FileResource;

public class VerifyJar
extends AbstractJarSignerTask {
    public static final String ERROR_NO_FILE = "Not found :";
    private static final String VERIFIED_TEXT = "jar verified.";
    private boolean certificates = false;
    private BufferingOutputFilter outputCache = new BufferingOutputFilter();
    public static final String ERROR_NO_VERIFY = "Failed to verify ";

    public void setCertificates(boolean bl) {
        this.certificates = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        boolean bl;
        boolean bl2 = bl = this.jar != null;
        if (!bl && !this.hasResources()) {
            throw new BuildException("jar must be set through jar attribute or nested filesets");
        }
        this.beginExecution();
        RedirectorElement redirectorElement = this.getRedirector();
        redirectorElement.setAlwaysLog(true);
        FilterChain filterChain = redirectorElement.createOutputFilterChain();
        filterChain.add(this.outputCache);
        try {
            Path path = this.createUnifiedSourcePath();
            Iterator iterator = path.iterator();
            while (iterator.hasNext()) {
                FileResource fileResource = (FileResource)iterator.next();
                this.verifyOneJar(fileResource.getFile());
            }
        }
        finally {
            this.endExecution();
        }
    }

    private void verifyOneJar(File file) {
        if (!file.exists()) {
            throw new BuildException(ERROR_NO_FILE + file);
        }
        ExecTask execTask = this.createJarSigner();
        this.setCommonOptions(execTask);
        this.bindToKeystore(execTask);
        this.addValue(execTask, "-verify");
        if (this.certificates) {
            this.addValue(execTask, "-certs");
        }
        this.addValue(execTask, file.getPath());
        this.log("Verifying JAR: " + file.getAbsolutePath());
        this.outputCache.clear();
        BuildException buildException = null;
        try {
            execTask.execute();
        }
        catch (BuildException buildException2) {
            buildException = buildException2;
        }
        String string = this.outputCache.toString();
        if (buildException != null) {
            if (string.indexOf("zip file closed") >= 0) {
                this.log("You are running jarsigner against a JVM with a known bug that manifests as an IllegalStateException.", 1);
            } else {
                throw buildException;
            }
        }
        if (string.indexOf(VERIFIED_TEXT) < 0) {
            throw new BuildException(ERROR_NO_VERIFY + file);
        }
    }

    private static class BufferingOutputFilterReader
    extends Reader {
        private Reader next;
        private StringBuffer buffer = new StringBuffer();

        public BufferingOutputFilterReader(Reader reader) {
            this.next = reader;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = this.next.read(cArray, n, n2);
            this.buffer.append(cArray, n, n2);
            return n3;
        }

        @Override
        public void close() throws IOException {
            this.next.close();
        }

        public String toString() {
            return this.buffer.toString();
        }

        public void clear() {
            this.buffer = new StringBuffer();
        }
    }

    private static class BufferingOutputFilter
    implements ChainableReader {
        private BufferingOutputFilterReader buffer;

        private BufferingOutputFilter() {
        }

        @Override
        public Reader chain(Reader reader) {
            this.buffer = new BufferingOutputFilterReader(reader);
            return this.buffer;
        }

        public String toString() {
            return this.buffer.toString();
        }

        public void clear() {
            if (this.buffer != null) {
                this.buffer.clear();
            }
        }
    }
}

