/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.ResourceUtils;
import org.apache.tools.ant.util.SourceFileScanner;

public class UpToDate
extends Task
implements Condition {
    private String property;
    private String value;
    private File sourceFile;
    private File targetFile;
    private Vector sourceFileSets = new Vector();
    private Union sourceResources = new Union();
    protected Mapper mapperElement = null;

    public void setProperty(String string) {
        this.property = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    private String getValue() {
        return this.value != null ? this.value : "true";
    }

    public void setTargetFile(File file) {
        this.targetFile = file;
    }

    public void setSrcfile(File file) {
        this.sourceFile = file;
    }

    public void addSrcfiles(FileSet fileSet) {
        this.sourceFileSets.addElement(fileSet);
    }

    public Union createSrcResources() {
        return this.sourceResources;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    @Override
    public boolean eval() {
        Object object;
        Object object2;
        if (this.sourceFileSets.size() == 0 && this.sourceResources.size() == 0 && this.sourceFile == null) {
            throw new BuildException("At least one srcfile or a nested <srcfiles> or <srcresources> element must be set.");
        }
        if ((this.sourceFileSets.size() > 0 || this.sourceResources.size() > 0) && this.sourceFile != null) {
            throw new BuildException("Cannot specify both the srcfile attribute and a nested <srcfiles> or <srcresources> element.");
        }
        if (this.targetFile == null && this.mapperElement == null) {
            throw new BuildException("The targetfile attribute or a nested mapper element must be set.");
        }
        if (this.targetFile != null && !this.targetFile.exists()) {
            this.log("The targetfile \"" + this.targetFile.getAbsolutePath() + "\" does not exist.", 3);
            return false;
        }
        if (this.sourceFile != null && !this.sourceFile.exists()) {
            throw new BuildException(this.sourceFile.getAbsolutePath() + " not found.");
        }
        boolean bl = true;
        if (this.sourceFile != null) {
            if (this.mapperElement == null) {
                bl = this.targetFile.lastModified() >= this.sourceFile.lastModified();
            } else {
                object2 = new SourceFileScanner(this);
                bl = ((SourceFileScanner)object2).restrict(new String[]{this.sourceFile.getAbsolutePath()}, null, null, this.mapperElement.getImplementation()).length == 0;
            }
        }
        object2 = this.sourceFileSets.elements();
        while (bl && object2.hasMoreElements()) {
            object = (FileSet)object2.nextElement();
            DirectoryScanner directoryScanner = ((AbstractFileSet)object).getDirectoryScanner(this.getProject());
            bl = this.scanDir(((AbstractFileSet)object).getDir(this.getProject()), directoryScanner.getIncludedFiles());
        }
        if (bl) {
            object = this.sourceResources.listResources();
            bl = ResourceUtils.selectOutOfDateSources(this, (Resource[])object, this.getMapper(), this.getProject()).length == 0;
        }
        return bl;
    }

    @Override
    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("property attribute is required.", this.getLocation());
        }
        boolean bl = this.eval();
        if (bl) {
            this.getProject().setNewProperty(this.property, this.getValue());
            if (this.mapperElement == null) {
                this.log("File \"" + this.targetFile.getAbsolutePath() + "\" is up-to-date.", 3);
            } else {
                this.log("All target files are up-to-date.", 3);
            }
        }
    }

    protected boolean scanDir(File file, String[] stringArray) {
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        FileNameMapper fileNameMapper = this.getMapper();
        File file2 = file;
        if (this.mapperElement == null) {
            file2 = null;
        }
        return sourceFileScanner.restrict(stringArray, file, file2, fileNameMapper).length == 0;
    }

    private FileNameMapper getMapper() {
        FileNameMapper fileNameMapper = null;
        if (this.mapperElement == null) {
            MergingMapper mergingMapper = new MergingMapper();
            mergingMapper.setTo(this.targetFile.getAbsolutePath());
            fileNameMapper = mergingMapper;
        } else {
            fileNameMapper = this.mapperElement.getImplementation();
        }
        return fileNameMapper;
    }
}

