/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.ArchiveResource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.TarResource;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.bzip2.CBZip2OutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public class Tar
extends MatchingTask {
    private static final int BUFFER_SIZE = 8192;
    public static final String WARN = "warn";
    public static final String FAIL = "fail";
    public static final String TRUNCATE = "truncate";
    public static final String GNU = "gnu";
    public static final String OMIT = "omit";
    File tarFile;
    File baseDir;
    private TarLongFileMode longFileMode = new TarLongFileMode();
    Vector filesets = new Vector();
    private Vector resourceCollections = new Vector();
    Vector fileSetFiles = new Vector();
    private boolean longWarningGiven = false;
    private TarCompressionMethod compression = new TarCompressionMethod();

    public TarFileSet createTarFileSet() {
        TarFileSet tarFileSet = new TarFileSet();
        tarFileSet.setProject(this.getProject());
        this.filesets.addElement(tarFileSet);
        return tarFileSet;
    }

    public void add(ResourceCollection resourceCollection) {
        this.resourceCollections.add(resourceCollection);
    }

    public void setTarfile(File file) {
        this.tarFile = file;
    }

    public void setDestFile(File file) {
        this.tarFile = file;
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setLongfile(String string) {
        this.log("DEPRECATED - The setLongfile(String) method has been deprecated. Use setLongfile(Tar.TarLongFileMode) instead.");
        this.longFileMode = new TarLongFileMode();
        this.longFileMode.setValue(string);
    }

    public void setLongfile(TarLongFileMode tarLongFileMode) {
        this.longFileMode = tarLongFileMode;
    }

    public void setCompression(TarCompressionMethod tarCompressionMethod) {
        this.compression = tarCompressionMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        if (this.tarFile == null) {
            throw new BuildException("tarfile attribute must be set!", this.getLocation());
        }
        if (this.tarFile.exists() && this.tarFile.isDirectory()) {
            throw new BuildException("tarfile is a directory!", this.getLocation());
        }
        if (this.tarFile.exists() && !this.tarFile.canWrite()) {
            throw new BuildException("Can not write to the specified tarfile!", this.getLocation());
        }
        Vector vector = (Vector)this.filesets.clone();
        try {
            if (this.baseDir != null) {
                if (!this.baseDir.exists()) {
                    throw new BuildException("basedir does not exist!", this.getLocation());
                }
                TarFileSet tarFileSet = new TarFileSet(this.fileset);
                tarFileSet.setDir(this.baseDir);
                this.filesets.addElement(tarFileSet);
            }
            if (this.filesets.size() == 0 && this.resourceCollections.size() == 0) {
                throw new BuildException("You must supply either a basedir attribute or some nested resource collections.", this.getLocation());
            }
            boolean bl = true;
            Object object = this.filesets.elements();
            while (object.hasMoreElements()) {
                bl &= this.check((TarFileSet)object.nextElement());
            }
            object = this.resourceCollections.elements();
            while (object.hasMoreElements()) {
                bl &= this.check((ResourceCollection)object.nextElement());
            }
            if (bl) {
                this.log("Nothing to do: " + this.tarFile.getAbsolutePath() + " is up to date.", 2);
                return;
            }
            this.log("Building tar: " + this.tarFile.getAbsolutePath(), 2);
            object = null;
            try {
                object = new TarOutputStream(this.compression.compress(new BufferedOutputStream(new FileOutputStream(this.tarFile))));
                ((TarOutputStream)object).setDebug(true);
                if (this.longFileMode.isTruncateMode()) {
                    ((TarOutputStream)object).setLongFileMode(1);
                } else if (this.longFileMode.isFailMode() || this.longFileMode.isOmitMode()) {
                    ((TarOutputStream)object).setLongFileMode(0);
                } else {
                    ((TarOutputStream)object).setLongFileMode(2);
                }
                this.longWarningGiven = false;
                Enumeration enumeration = this.filesets.elements();
                while (enumeration.hasMoreElements()) {
                    this.tar((TarFileSet)enumeration.nextElement(), (TarOutputStream)object);
                }
                enumeration = this.resourceCollections.elements();
                while (enumeration.hasMoreElements()) {
                    this.tar((ResourceCollection)enumeration.nextElement(), (TarOutputStream)object);
                }
            }
            catch (IOException iOException) {
                try {
                    String string = "Problem creating TAR: " + iOException.getMessage();
                    throw new BuildException(string, iOException, this.getLocation());
                }
                catch (Throwable throwable) {
                    FileUtils.close(object);
                    throw throwable;
                }
            }
            FileUtils.close((OutputStream)object);
        }
        finally {
            this.filesets = vector;
        }
    }

    protected void tarFile(File file, TarOutputStream tarOutputStream, String string, TarFileSet tarFileSet) throws IOException {
        if (file.equals(this.tarFile)) {
            return;
        }
        this.tarResource(new FileResource(file), tarOutputStream, string, tarFileSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tarResource(Resource resource, TarOutputStream tarOutputStream, String string, TarFileSet tarFileSet) throws IOException {
        Object object;
        Object object2;
        if (!resource.isExists()) {
            return;
        }
        if (tarFileSet != null) {
            object2 = tarFileSet.getFullpath(this.getProject());
            if (((String)object2).length() > 0) {
                string = object2;
            } else {
                if (string.length() <= 0) {
                    return;
                }
                String string2 = tarFileSet.getPrefix(this.getProject());
                if (string2.length() > 0 && !string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                string = string2 + string;
            }
            if (string.startsWith("/") && !tarFileSet.getPreserveLeadingSlashes()) {
                int n = string.length();
                if (n <= 1) {
                    return;
                }
                string = string.substring(1, n);
            }
        }
        if (resource.isDirectory() && !string.endsWith("/")) {
            string = string + "/";
        }
        if (string.length() >= 100) {
            if (this.longFileMode.isOmitMode()) {
                this.log("Omitting: " + string, 2);
                return;
            }
            if (this.longFileMode.isWarnMode()) {
                this.log("Entry: " + string + " longer than " + 100 + " characters.", 1);
                if (!this.longWarningGiven) {
                    this.log("Resulting tar file can only be processed successfully by GNU compatible tar commands", 1);
                    this.longWarningGiven = true;
                }
            } else if (this.longFileMode.isFailMode()) {
                throw new BuildException("Entry: " + string + " longer than " + 100 + "characters.", this.getLocation());
            }
        }
        object2 = new TarEntry(string);
        ((TarEntry)object2).setModTime(resource.getLastModified());
        if (resource instanceof ArchiveResource) {
            ArchiveResource archiveResource = (ArchiveResource)resource;
            ((TarEntry)object2).setMode(archiveResource.getMode());
            if (resource instanceof TarResource) {
                object = (TarResource)resource;
                ((TarEntry)object2).setUserName(((TarResource)object).getUserName());
                ((TarEntry)object2).setUserId(((TarResource)object).getUid());
                ((TarEntry)object2).setGroupName(((TarResource)object).getGroup());
                ((TarEntry)object2).setGroupId(((TarResource)object).getGid());
            }
        }
        if (!resource.isDirectory()) {
            if ((long)resource.size() > 0x1FFFFFFFFL) {
                throw new BuildException("Resource: " + resource + " larger than " + 0x1FFFFFFFFL + " bytes.");
            }
            ((TarEntry)object2).setSize(resource.getSize());
            if (tarFileSet != null && tarFileSet.hasFileModeBeenSet()) {
                ((TarEntry)object2).setMode(tarFileSet.getMode());
            }
        } else if (tarFileSet != null && tarFileSet.hasDirModeBeenSet()) {
            ((TarEntry)object2).setMode(tarFileSet.getDirMode(this.getProject()));
        }
        if (tarFileSet != null) {
            if (tarFileSet.hasUserNameBeenSet()) {
                ((TarEntry)object2).setUserName(tarFileSet.getUserName());
            }
            if (tarFileSet.hasGroupBeenSet()) {
                ((TarEntry)object2).setGroupName(tarFileSet.getGroup());
            }
            if (tarFileSet.hasUserIdBeenSet()) {
                ((TarEntry)object2).setUserId(tarFileSet.getUid());
            }
            if (tarFileSet.hasGroupIdBeenSet()) {
                ((TarEntry)object2).setGroupId(tarFileSet.getGid());
            }
        }
        InputStream inputStream = null;
        try {
            tarOutputStream.putNextEntry((TarEntry)object2);
            if (!resource.isDirectory()) {
                inputStream = resource.getInputStream();
                object = new byte[8192];
                int n = 0;
                do {
                    tarOutputStream.write((byte[])object, 0, n);
                } while ((n = inputStream.read((byte[])object, 0, ((Object)object).length)) != -1);
            }
            tarOutputStream.closeEntry();
        }
        catch (Throwable throwable) {
            FileUtils.close(inputStream);
            throw throwable;
        }
        FileUtils.close(inputStream);
    }

    protected boolean archiveIsUpToDate(String[] stringArray) {
        return this.archiveIsUpToDate(stringArray, this.baseDir);
    }

    protected boolean archiveIsUpToDate(String[] stringArray, File file) {
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        MergingMapper mergingMapper = new MergingMapper();
        mergingMapper.setTo(this.tarFile.getAbsolutePath());
        return sourceFileScanner.restrict(stringArray, file, null, mergingMapper).length == 0;
    }

    protected boolean archiveIsUpToDate(Resource resource) {
        return SelectorUtils.isOutOfDate((Resource)new FileResource(this.tarFile), resource, FileUtils.getFileUtils().getFileTimestampGranularity());
    }

    protected boolean supportsNonFileResources() {
        return this.getClass().equals(Tar.class);
    }

    protected boolean check(ResourceCollection resourceCollection) {
        boolean bl = true;
        if (Tar.isFileFileSet(resourceCollection)) {
            FileSet fileSet = (FileSet)resourceCollection;
            bl = this.check(fileSet.getDir(this.getProject()), Tar.getFileNames(fileSet));
        } else {
            if (!resourceCollection.isFilesystemOnly() && !this.supportsNonFileResources()) {
                throw new BuildException("only filesystem resources are supported");
            }
            if (resourceCollection.isFilesystemOnly()) {
                String[] stringArray;
                Serializable serializable;
                HashSet<File> hashSet = new HashSet<File>();
                HashMap hashMap = new HashMap();
                Iterator iterator = resourceCollection.iterator();
                while (iterator.hasNext()) {
                    FileResource comparable = (FileResource)iterator.next();
                    serializable = comparable.getBaseDir();
                    if (serializable == null) {
                        serializable = Copy.NULL_FILE_PLACEHOLDER;
                    }
                    hashSet.add((File)serializable);
                    stringArray = (String[])hashMap.get(serializable);
                    if (stringArray == null) {
                        stringArray = new Vector();
                        hashMap.put(serializable, new Vector());
                    }
                    stringArray.add(comparable.getName());
                }
                for (File file : hashSet) {
                    serializable = (Vector)hashMap.get(file);
                    stringArray = ((Vector)serializable).toArray(new String[((Vector)serializable).size()]);
                    bl &= this.check(file == Copy.NULL_FILE_PLACEHOLDER ? null : file, stringArray);
                }
            } else {
                Iterator iterator = resourceCollection.iterator();
                while (bl && iterator.hasNext()) {
                    Resource resource = (Resource)iterator.next();
                    bl = this.archiveIsUpToDate(resource);
                }
            }
        }
        return bl;
    }

    protected boolean check(File file, String[] stringArray) {
        boolean bl = true;
        if (!this.archiveIsUpToDate(stringArray, file)) {
            bl = false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.tarFile.equals(new File(file, stringArray[i]))) continue;
            throw new BuildException("A tar file cannot include itself", this.getLocation());
        }
        return bl;
    }

    protected void tar(ResourceCollection resourceCollection, TarOutputStream tarOutputStream) throws IOException {
        ArchiveFileSet archiveFileSet = null;
        if (resourceCollection instanceof ArchiveFileSet) {
            archiveFileSet = (ArchiveFileSet)resourceCollection;
        }
        if (archiveFileSet != null && archiveFileSet.size() > 1 && archiveFileSet.getFullpath(this.getProject()).length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        TarFileSet tarFileSet = this.asTarFileSet(archiveFileSet);
        if (Tar.isFileFileSet(resourceCollection)) {
            FileSet fileSet = (FileSet)resourceCollection;
            String[] stringArray = Tar.getFileNames(fileSet);
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(fileSet.getDir(this.getProject()), stringArray[i]);
                String string = stringArray[i].replace(File.separatorChar, '/');
                this.tarFile(file, tarOutputStream, string, tarFileSet);
            }
        } else if (resourceCollection.isFilesystemOnly()) {
            Iterator iterator = resourceCollection.iterator();
            while (iterator.hasNext()) {
                FileResource fileResource = (FileResource)iterator.next();
                File file = fileResource.getFile();
                if (file == null) {
                    file = new File(fileResource.getBaseDir(), fileResource.getName());
                }
                this.tarFile(file, tarOutputStream, file.getName(), tarFileSet);
            }
        } else {
            Iterator iterator = resourceCollection.iterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                this.tarResource(resource, tarOutputStream, resource.getName(), tarFileSet);
            }
        }
    }

    protected static final boolean isFileFileSet(ResourceCollection resourceCollection) {
        return resourceCollection instanceof FileSet && resourceCollection.isFilesystemOnly();
    }

    protected static final String[] getFileNames(FileSet fileSet) {
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(fileSet.getProject());
        String[] stringArray = directoryScanner.getIncludedDirectories();
        String[] stringArray2 = directoryScanner.getIncludedFiles();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    protected TarFileSet asTarFileSet(ArchiveFileSet archiveFileSet) {
        TarFileSet tarFileSet = null;
        if (archiveFileSet != null && archiveFileSet instanceof TarFileSet) {
            tarFileSet = (TarFileSet)archiveFileSet;
        } else {
            tarFileSet = new TarFileSet();
            tarFileSet.setProject(this.getProject());
            if (archiveFileSet != null) {
                tarFileSet.setPrefix(archiveFileSet.getPrefix(this.getProject()));
                tarFileSet.setFullpath(archiveFileSet.getFullpath(this.getProject()));
                if (archiveFileSet.hasFileModeBeenSet()) {
                    tarFileSet.integerSetFileMode(archiveFileSet.getFileMode(this.getProject()));
                }
                if (archiveFileSet.hasDirModeBeenSet()) {
                    tarFileSet.integerSetDirMode(archiveFileSet.getDirMode(this.getProject()));
                }
                if (archiveFileSet instanceof org.apache.tools.ant.types.TarFileSet) {
                    org.apache.tools.ant.types.TarFileSet tarFileSet2 = (org.apache.tools.ant.types.TarFileSet)archiveFileSet;
                    if (tarFileSet2.hasUserNameBeenSet()) {
                        tarFileSet.setUserName(tarFileSet2.getUserName());
                    }
                    if (tarFileSet2.hasGroupBeenSet()) {
                        tarFileSet.setGroup(tarFileSet2.getGroup());
                    }
                    if (tarFileSet2.hasUserIdBeenSet()) {
                        tarFileSet.setUid(tarFileSet2.getUid());
                    }
                    if (tarFileSet2.hasGroupIdBeenSet()) {
                        tarFileSet.setGid(tarFileSet2.getGid());
                    }
                }
            }
        }
        return tarFileSet;
    }

    public static final class TarCompressionMethod
    extends EnumeratedAttribute {
        private static final String NONE = "none";
        private static final String GZIP = "gzip";
        private static final String BZIP2 = "bzip2";

        public TarCompressionMethod() {
            this.setValue(NONE);
        }

        @Override
        public String[] getValues() {
            return new String[]{NONE, GZIP, BZIP2};
        }

        private OutputStream compress(OutputStream outputStream) throws IOException {
            String string = this.getValue();
            if (GZIP.equals(string)) {
                return new GZIPOutputStream(outputStream);
            }
            if (BZIP2.equals(string)) {
                outputStream.write(66);
                outputStream.write(90);
                return new CBZip2OutputStream(outputStream);
            }
            return outputStream;
        }
    }

    public static class TarLongFileMode
    extends EnumeratedAttribute {
        public static final String WARN = "warn";
        public static final String FAIL = "fail";
        public static final String TRUNCATE = "truncate";
        public static final String GNU = "gnu";
        public static final String OMIT = "omit";
        private final String[] validModes = new String[]{"warn", "fail", "truncate", "gnu", "omit"};

        public TarLongFileMode() {
            this.setValue("warn");
        }

        @Override
        public String[] getValues() {
            return this.validModes;
        }

        public boolean isTruncateMode() {
            return "truncate".equalsIgnoreCase(this.getValue());
        }

        public boolean isWarnMode() {
            return "warn".equalsIgnoreCase(this.getValue());
        }

        public boolean isGnuMode() {
            return "gnu".equalsIgnoreCase(this.getValue());
        }

        public boolean isFailMode() {
            return "fail".equalsIgnoreCase(this.getValue());
        }

        public boolean isOmitMode() {
            return "omit".equalsIgnoreCase(this.getValue());
        }
    }

    public static class TarFileSet
    extends org.apache.tools.ant.types.TarFileSet {
        private String[] files = null;
        private boolean preserveLeadingSlashes = false;

        public TarFileSet(FileSet fileSet) {
            super(fileSet);
        }

        public TarFileSet() {
        }

        public String[] getFiles(Project project) {
            if (this.files == null) {
                this.files = Tar.getFileNames(this);
            }
            return this.files;
        }

        public void setMode(String string) {
            this.setFileMode(string);
        }

        public int getMode() {
            return this.getFileMode(this.getProject());
        }

        public void setPreserveLeadingSlashes(boolean bl) {
            this.preserveLeadingSlashes = bl;
        }

        public boolean getPreserveLeadingSlashes() {
            return this.preserveLeadingSlashes;
        }
    }
}

