/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.selectors.BaseSelectorContainer;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.NoneSelector;

public class Sync
extends Task {
    private MyCopy myCopy;
    private SyncTarget syncTarget;

    @Override
    public void init() throws BuildException {
        this.myCopy = new MyCopy();
        this.configureTask(this.myCopy);
        this.myCopy.setFiltering(false);
        this.myCopy.setIncludeEmptyDirs(false);
        this.myCopy.setPreserveLastModified(true);
    }

    private void configureTask(Task task) {
        task.setProject(this.getProject());
        task.setTaskName(this.getTaskName());
        task.setOwningTarget(this.getOwningTarget());
        task.init();
    }

    @Override
    public void execute() throws BuildException {
        File file = this.myCopy.getToDir();
        Set set = this.myCopy.nonOrphans;
        boolean bl = !file.exists() || file.list().length < 1;
        this.log("PASS#1: Copying files to " + file, 4);
        this.myCopy.execute();
        if (bl) {
            this.log("NO removing necessary in " + file, 4);
            return;
        }
        this.log("PASS#2: Removing orphan files from " + file, 4);
        int[] nArray = this.removeOrphanFiles(set, file);
        this.logRemovedCount(nArray[0], "dangling director", "y", "ies");
        this.logRemovedCount(nArray[1], "dangling file", "", "s");
        if (!this.myCopy.getIncludeEmptyDirs()) {
            this.log("PASS#3: Removing empty directories from " + file, 4);
            int n = this.removeEmptyDirectories(file, false);
            this.logRemovedCount(n, "empty director", "y", "ies");
        }
    }

    private void logRemovedCount(int n, String string, String string2, String string3) {
        File file = this.myCopy.getToDir();
        String string4 = string == null ? "" : string;
        string4 = string4 + (n < 2 ? string2 : string3);
        if (n > 0) {
            this.log("Removed " + n + " " + string4 + " from " + file, 2);
        } else {
            this.log("NO " + string4 + " to remove from " + file, 3);
        }
    }

    private int[] removeOrphanFiles(Set set, File file) {
        Object object;
        FileSelector[] fileSelectorArray;
        String[] stringArray;
        int[] nArray = new int[]{0, 0};
        String[] stringArray2 = set.toArray(new String[set.size() + 1]);
        stringArray2[set.size()] = "";
        DirectoryScanner directoryScanner = null;
        if (this.syncTarget != null) {
            stringArray = new FileSet();
            stringArray.setDir(file);
            stringArray.setCaseSensitive(this.syncTarget.isCaseSensitive());
            stringArray.setFollowSymlinks(this.syncTarget.isFollowSymlinks());
            PatternSet patternSet = this.syncTarget.mergePatterns(this.getProject());
            stringArray.appendExcludes(patternSet.getIncludePatterns(this.getProject()));
            stringArray.appendIncludes(patternSet.getExcludePatterns(this.getProject()));
            stringArray.setDefaultexcludes(!this.syncTarget.getDefaultexcludes());
            fileSelectorArray = this.syncTarget.getSelectors(this.getProject());
            if (fileSelectorArray.length > 0) {
                object = new NoneSelector();
                for (int i = 0; i < fileSelectorArray.length; ++i) {
                    ((BaseSelectorContainer)object).appendSelector(fileSelectorArray[i]);
                }
                stringArray.appendSelector((FileSelector)object);
            }
            directoryScanner = stringArray.getDirectoryScanner(this.getProject());
        } else {
            directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(file);
        }
        directoryScanner.addExcludes(stringArray2);
        directoryScanner.scan();
        stringArray = directoryScanner.getIncludedFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            fileSelectorArray = new File(file, stringArray[i]);
            this.log("Removing orphan file: " + fileSelectorArray, 4);
            fileSelectorArray.delete();
            nArray[1] = nArray[1] + 1;
        }
        String[] stringArray3 = directoryScanner.getIncludedDirectories();
        for (int i = stringArray3.length - 1; i >= 0; --i) {
            object = new File(file, stringArray3[i]);
            if (((File)object).list().length >= 1) continue;
            this.log("Removing orphan directory: " + object, 4);
            ((File)object).delete();
            nArray[0] = nArray[0] + 1;
        }
        return nArray;
    }

    private int removeEmptyDirectories(File file, boolean bl) {
        int n = 0;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.isDirectory()) continue;
                n += this.removeEmptyDirectories(file2, true);
            }
            if (fileArray.length > 0) {
                fileArray = file.listFiles();
            }
            if (fileArray.length < 1 && bl) {
                this.log("Removing empty directory: " + file, 4);
                file.delete();
                ++n;
            }
        }
        return n;
    }

    public void setTodir(File file) {
        this.myCopy.setTodir(file);
    }

    public void setVerbose(boolean bl) {
        this.myCopy.setVerbose(bl);
    }

    public void setOverwrite(boolean bl) {
        this.myCopy.setOverwrite(bl);
    }

    public void setIncludeEmptyDirs(boolean bl) {
        this.myCopy.setIncludeEmptyDirs(bl);
    }

    public void setFailOnError(boolean bl) {
        this.myCopy.setFailOnError(bl);
    }

    public void addFileset(FileSet fileSet) {
        this.add(fileSet);
    }

    public void add(ResourceCollection resourceCollection) {
        this.myCopy.add(resourceCollection);
    }

    public void setGranularity(long l) {
        this.myCopy.setGranularity(l);
    }

    public void addPreserveInTarget(SyncTarget syncTarget) {
        if (this.syncTarget != null) {
            throw new BuildException("you must not specify multiple preserveintarget elements.");
        }
        this.syncTarget = syncTarget;
    }

    private static void assertTrue(String string, boolean bl) {
        if (!bl) {
            throw new BuildException("Assertion Error: " + string);
        }
    }

    public static class SyncTarget
    extends AbstractFileSet {
        @Override
        public void setDir(File file) throws BuildException {
            throw new BuildException("preserveintarget doesn't support the dir attribute");
        }
    }

    public static class MyCopy
    extends Copy {
        private Set nonOrphans = new HashSet();

        @Override
        protected void scan(File file, File file2, String[] stringArray, String[] stringArray2) {
            int n;
            Sync.assertTrue("No mapper", this.mapperElement == null);
            super.scan(file, file2, stringArray, stringArray2);
            for (n = 0; n < stringArray.length; ++n) {
                this.nonOrphans.add(stringArray[n]);
            }
            for (n = 0; n < stringArray2.length; ++n) {
                this.nonOrphans.add(stringArray2[n]);
            }
        }

        @Override
        protected Map scan(Resource[] resourceArray, File file) {
            Sync.assertTrue("No mapper", this.mapperElement == null);
            Map map = super.scan(resourceArray, file);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                this.nonOrphans.add(((Resource)iterator.next()).getName());
            }
            return map;
        }

        public File getToDir() {
            return this.destDir;
        }

        public boolean getIncludeEmptyDirs() {
            return this.includeEmpty;
        }

        @Override
        protected boolean supportsNonFileResources() {
            return true;
        }
    }
}

