/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamPumper
implements Runnable {
    private static final int SMALL_BUFFER_SIZE = 128;
    private InputStream is;
    private OutputStream os;
    private volatile boolean finish;
    private volatile boolean finished;
    private boolean closeWhenExhausted;
    private boolean autoflush = false;
    private Exception exception = null;
    private int bufferSize = 128;
    private boolean started = false;

    public StreamPumper(InputStream inputStream, OutputStream outputStream, boolean bl) {
        this.is = inputStream;
        this.os = outputStream;
        this.closeWhenExhausted = bl;
    }

    public StreamPumper(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, false);
    }

    void setAutoflush(boolean bl) {
        this.autoflush = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this;
        synchronized (object) {
            this.started = true;
        }
        this.finished = false;
        this.finish = false;
        object = new byte[this.bufferSize];
        try {
            int n;
            while ((n = this.is.read((byte[])object)) > 0 && !this.finish) {
                this.os.write((byte[])object, 0, n);
                if (!this.autoflush) continue;
                this.os.flush();
            }
            this.os.flush();
        }
        catch (Exception exception) {
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.exception = exception;
            }
        }
        finally {
            if (this.closeWhenExhausted) {
                try {
                    this.os.close();
                }
                catch (IOException iOException) {}
            }
            this.finished = true;
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.notifyAll();
            }
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
    }

    public synchronized void setBufferSize(int n) {
        if (this.started) {
            throw new IllegalStateException("Cannot set buffer size on a running StreamPumper");
        }
        this.bufferSize = n;
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    public synchronized Exception getException() {
        return this.exception;
    }

    synchronized void stop() {
        this.finish = true;
        this.notifyAll();
    }
}

