/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.JDBCTask;
import org.apache.tools.ant.taskdefs.StreamPumper;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class SQLExec
extends JDBCTask {
    private int goodSql = 0;
    private int totalSql = 0;
    private Connection conn = null;
    private Union resources = new Union();
    private Statement statement = null;
    private File srcFile = null;
    private String sqlCommand = "";
    private Vector transactions = new Vector();
    private String delimiter = ";";
    private String delimiterType = "normal";
    private boolean print = false;
    private boolean showheaders = true;
    private boolean showtrailers = true;
    private File output = null;
    private String onError = "abort";
    private String encoding = null;
    private boolean append = false;
    private boolean keepformat = false;
    private boolean escapeProcessing = true;
    private boolean expandProperties = true;
    private boolean rawBlobs;

    public void setSrc(File file) {
        this.srcFile = file;
    }

    public void setExpandProperties(boolean bl) {
        this.expandProperties = bl;
    }

    public boolean getExpandProperties() {
        return this.expandProperties;
    }

    public void addText(String string) {
        this.sqlCommand = this.sqlCommand + string;
    }

    public void addFileset(FileSet fileSet) {
        this.add(fileSet);
    }

    public void add(ResourceCollection resourceCollection) {
        this.resources.add(resourceCollection);
    }

    public Transaction createTransaction() {
        Transaction transaction = new Transaction();
        this.transactions.addElement(transaction);
        return transaction;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public void setDelimiterType(DelimiterType delimiterType) {
        this.delimiterType = delimiterType.getValue();
    }

    public void setPrint(boolean bl) {
        this.print = bl;
    }

    public void setShowheaders(boolean bl) {
        this.showheaders = bl;
    }

    public void setShowtrailers(boolean bl) {
        this.showtrailers = bl;
    }

    public void setOutput(File file) {
        this.output = file;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void setOnerror(OnError onError) {
        this.onError = onError.getValue();
    }

    public void setKeepformat(boolean bl) {
        this.keepformat = bl;
    }

    public void setEscapeProcessing(boolean bl) {
        this.escapeProcessing = bl;
    }

    public void setRawBlobs(boolean bl) {
        this.rawBlobs = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        Vector vector = (Vector)this.transactions.clone();
        String string = this.sqlCommand;
        this.sqlCommand = this.sqlCommand.trim();
        try {
            Object object;
            Object object2;
            if (this.srcFile == null && this.sqlCommand.length() == 0 && this.resources.size() == 0 && this.transactions.size() == 0) {
                throw new BuildException("Source file or resource collection, transactions or sql statement must be set!", this.getLocation());
            }
            if (this.srcFile != null && !this.srcFile.isFile()) {
                throw new BuildException("Source file " + this.srcFile + " is not a file!", this.getLocation());
            }
            Iterator iterator = this.resources.iterator();
            while (iterator.hasNext()) {
                object2 = (Resource)iterator.next();
                object = this.createTransaction();
                ((Transaction)object).setSrcResource((Resource)object2);
            }
            object2 = this.createTransaction();
            ((Transaction)object2).setSrc(this.srcFile);
            ((Transaction)object2).addText(this.sqlCommand);
            this.conn = this.getConnection();
            if (!this.isValidRdbms(this.conn)) {
                return;
            }
            try {
                this.statement = this.conn.createStatement();
                this.statement.setEscapeProcessing(this.escapeProcessing);
                object = System.out;
                try {
                    if (this.output != null) {
                        this.log("Opening PrintStream to output file " + this.output, 3);
                        object = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output.getAbsolutePath(), this.append)));
                    }
                    Enumeration enumeration = this.transactions.elements();
                    while (enumeration.hasMoreElements()) {
                        ((Transaction)enumeration.nextElement()).runTransaction((PrintStream)object);
                        if (this.isAutocommit()) continue;
                        this.log("Committing transaction", 3);
                        this.conn.commit();
                    }
                }
                finally {
                    FileUtils.close((OutputStream)object);
                }
            }
            catch (IOException iOException) {
                this.closeQuietly();
                throw new BuildException(iOException, this.getLocation());
            }
            catch (SQLException sQLException) {
                this.closeQuietly();
                throw new BuildException(sQLException, this.getLocation());
            }
            finally {
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
                try {
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            this.log(this.goodSql + " of " + this.totalSql + " SQL statements executed successfully");
        }
        finally {
            this.transactions = vector;
            this.sqlCommand = string;
        }
    }

    protected void runStatements(Reader reader, PrintStream printStream) throws SQLException, IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            StringTokenizer stringTokenizer;
            if (!this.keepformat) {
                string = string.trim();
            }
            if (this.expandProperties) {
                string = this.getProject().replaceProperties(string);
            }
            if (!this.keepformat && (string.startsWith("//") || string.startsWith("--") || (stringTokenizer = new StringTokenizer(string)).hasMoreTokens() && "REM".equalsIgnoreCase(string2 = stringTokenizer.nextToken()))) continue;
            stringBuffer.append(this.keepformat ? "\n" : " ").append(string);
            if (!this.keepformat && string.indexOf("--") >= 0) {
                stringBuffer.append("\n");
            }
            if ((!this.delimiterType.equals("normal") || !StringUtils.endsWith(stringBuffer, this.delimiter)) && (!this.delimiterType.equals("row") || !string.equals(this.delimiter))) continue;
            this.execSQL(stringBuffer.substring(0, stringBuffer.length() - this.delimiter.length()), printStream);
            stringBuffer.replace(0, stringBuffer.length(), "");
        }
        if (stringBuffer.length() > 0) {
            this.execSQL(stringBuffer.toString(), printStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execSQL(String string, PrintStream printStream) throws SQLException {
        if ("".equals(string.trim())) {
            return;
        }
        ResultSet resultSet = null;
        try {
            ++this.totalSql;
            this.log("SQL: " + string, 3);
            int n = 0;
            int n2 = 0;
            boolean bl = this.statement.execute(string);
            n = this.statement.getUpdateCount();
            resultSet = this.statement.getResultSet();
            do {
                if (!bl) {
                    if (n != -1) {
                        n2 += n;
                    }
                } else if (this.print) {
                    this.printResults(resultSet, printStream);
                }
                if (!(bl = this.statement.getMoreResults())) continue;
                n = this.statement.getUpdateCount();
                resultSet = this.statement.getResultSet();
            } while (bl);
            this.log(n2 + " rows affected", 3);
            if (this.print && this.showtrailers) {
                printStream.println(n2 + " rows affected");
            }
            for (SQLWarning sQLWarning = this.conn.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                this.log(sQLWarning + " sql warning", 3);
            }
            this.conn.clearWarnings();
            ++this.goodSql;
        }
        catch (SQLException sQLException) {
            this.log("Failed to execute: " + string, 0);
            if (!this.onError.equals("continue")) {
                throw sQLException;
            }
            this.log(sQLException.toString(), 0);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printResults(PrintStream printStream) throws SQLException {
        ResultSet resultSet = this.statement.getResultSet();
        try {
            this.printResults(resultSet, printStream);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    protected void printResults(ResultSet resultSet, PrintStream printStream) throws SQLException {
        if (resultSet != null) {
            this.log("Processing new result set.", 3);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            if (n > 0) {
                int n2;
                if (this.showheaders) {
                    printStream.print(resultSetMetaData.getColumnName(1));
                    for (n2 = 2; n2 <= n; ++n2) {
                        printStream.write(44);
                        printStream.print(resultSetMetaData.getColumnName(n2));
                    }
                    printStream.println();
                }
                while (resultSet.next()) {
                    this.printValue(resultSet, 1, printStream);
                    for (n2 = 2; n2 <= n; ++n2) {
                        printStream.write(44);
                        this.printValue(resultSet, n2, printStream);
                    }
                    printStream.println();
                }
            }
        }
        printStream.println();
    }

    private void printValue(ResultSet resultSet, int n, PrintStream printStream) throws SQLException {
        if (this.rawBlobs && resultSet.getMetaData().getColumnType(n) == 2004) {
            new StreamPumper(resultSet.getBlob(n).getBinaryStream(), printStream).run();
        } else {
            printStream.print(resultSet.getString(n));
        }
    }

    private void closeQuietly() {
        if (!this.isAutocommit() && this.conn != null && this.onError.equals("abort")) {
            try {
                this.conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public class Transaction {
        private Resource tSrcResource = null;
        private String tSqlCommand = "";

        public void setSrc(File file) {
            if (file != null) {
                this.setSrcResource(new FileResource(file));
            }
        }

        public void setSrcResource(Resource resource) {
            if (this.tSrcResource != null) {
                throw new BuildException("only one resource per transaction");
            }
            this.tSrcResource = resource;
        }

        public void addText(String string) {
            if (string != null) {
                this.tSqlCommand = this.tSqlCommand + string;
            }
        }

        public void addConfigured(ResourceCollection resourceCollection) {
            if (resourceCollection.size() != 1) {
                throw new BuildException("only single argument resource collections are supported.");
            }
            this.setSrcResource((Resource)resourceCollection.iterator().next());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTransaction(PrintStream printStream) throws IOException, SQLException {
            if (this.tSqlCommand.length() != 0) {
                SQLExec.this.log("Executing commands", 2);
                SQLExec.this.runStatements(new StringReader(this.tSqlCommand), printStream);
            }
            if (this.tSrcResource != null) {
                SQLExec.this.log("Executing resource: " + this.tSrcResource.toString(), 2);
                InputStream inputStream = null;
                InputStreamReader inputStreamReader = null;
                try {
                    inputStream = this.tSrcResource.getInputStream();
                    inputStreamReader = SQLExec.this.encoding == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, SQLExec.this.encoding);
                    SQLExec.this.runStatements(inputStreamReader, printStream);
                }
                catch (Throwable throwable) {
                    FileUtils.close(inputStream);
                    FileUtils.close(inputStreamReader);
                    throw throwable;
                }
                FileUtils.close(inputStream);
                FileUtils.close(inputStreamReader);
            }
        }
    }

    public static class OnError
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"continue", "stop", "abort"};
        }
    }

    public static class DelimiterType
    extends EnumeratedAttribute {
        public static final String NORMAL = "normal";
        public static final String ROW = "row";

        @Override
        public String[] getValues() {
            return new String[]{NORMAL, ROW};
        }
    }
}

