/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.rmi.Remote;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapter;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapterFactory;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.ant.util.facade.FacadeTaskHelper;

public class Rmic
extends MatchingTask {
    public static final String ERROR_RMIC_FAILED = "Rmic failed; see the compiler error output for details.";
    private File baseDir;
    private String classname;
    private File sourceBase;
    private String stubVersion;
    private Path compileClasspath;
    private Path extDirs;
    private boolean verify = false;
    private boolean filtering = false;
    private boolean iiop = false;
    private String iiopOpts;
    private boolean idl = false;
    private String idlOpts;
    private boolean debug = false;
    private boolean includeAntRuntime = true;
    private boolean includeJavaRuntime = false;
    private Vector compileList = new Vector();
    private ClassLoader loader = null;
    private FacadeTaskHelper facade = new FacadeTaskHelper("default");
    public static final String ERROR_UNABLE_TO_VERIFY_CLASS = "Unable to verify class ";
    public static final String ERROR_NOT_FOUND = ". It could not be found.";
    public static final String ERROR_NOT_DEFINED = ". It is not defined.";
    public static final String ERROR_LOADING_CAUSED_EXCEPTION = ". Loading caused Exception: ";
    public static final String ERROR_NO_BASE_EXISTS = "base does not exist: ";
    public static final String ERROR_NOT_A_DIR = "base is not a directory:";
    public static final String ERROR_BASE_NOT_SET = "base attribute must be set!";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();

    public void setBase(File file) {
        this.baseDir = file;
    }

    public File getBase() {
        return this.baseDir;
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setSourceBase(File file) {
        this.sourceBase = file;
    }

    public File getSourceBase() {
        return this.sourceBase;
    }

    public void setStubVersion(String string) {
        this.stubVersion = string;
    }

    public String getStubVersion() {
        return this.stubVersion;
    }

    public void setFiltering(boolean bl) {
        this.filtering = bl;
    }

    public boolean getFiltering() {
        return this.filtering;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setClasspath(Path path) {
        if (this.compileClasspath == null) {
            this.compileClasspath = path;
        } else {
            this.compileClasspath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setVerify(boolean bl) {
        this.verify = bl;
    }

    public boolean getVerify() {
        return this.verify;
    }

    public void setIiop(boolean bl) {
        this.iiop = bl;
    }

    public boolean getIiop() {
        return this.iiop;
    }

    public void setIiopopts(String string) {
        this.iiopOpts = string;
    }

    public String getIiopopts() {
        return this.iiopOpts;
    }

    public void setIdl(boolean bl) {
        this.idl = bl;
    }

    public boolean getIdl() {
        return this.idl;
    }

    public void setIdlopts(String string) {
        this.idlOpts = string;
    }

    public String getIdlopts() {
        return this.idlOpts;
    }

    public Vector getFileList() {
        return this.compileList;
    }

    public void setIncludeantruntime(boolean bl) {
        this.includeAntRuntime = bl;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean bl) {
        this.includeJavaRuntime = bl;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public void setExtdirs(Path path) {
        if (this.extDirs == null) {
            this.extDirs = path;
        } else {
            this.extDirs.append(path);
        }
    }

    public Path createExtdirs() {
        if (this.extDirs == null) {
            this.extDirs = new Path(this.getProject());
        }
        return this.extDirs.createPath();
    }

    public Path getExtdirs() {
        return this.extDirs;
    }

    public Vector getCompileList() {
        return this.compileList;
    }

    public void setCompiler(String string) {
        if (string.length() > 0) {
            this.facade.setImplementation(string);
        }
    }

    public String getCompiler() {
        this.facade.setMagicValue(this.getProject().getProperty("build.rmic"));
        return this.facade.getImplementation();
    }

    public ImplementationSpecificArgument createCompilerArg() {
        ImplementationSpecificArgument implementationSpecificArgument = new ImplementationSpecificArgument();
        this.facade.addImplementationArgument(implementationSpecificArgument);
        return implementationSpecificArgument;
    }

    public String[] getCurrentCompilerArgs() {
        this.getCompiler();
        return this.facade.getArgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        if (this.baseDir == null) {
            throw new BuildException(ERROR_BASE_NOT_SET, this.getLocation());
        }
        if (!this.baseDir.exists()) {
            throw new BuildException(ERROR_NO_BASE_EXISTS + this.baseDir, this.getLocation());
        }
        if (!this.baseDir.isDirectory()) {
            throw new BuildException(ERROR_NOT_A_DIR + this.baseDir, this.getLocation());
        }
        if (this.verify) {
            this.log("Verify has been turned on.", 3);
        }
        RmicAdapter rmicAdapter = RmicAdapterFactory.getRmic(this.getCompiler(), this);
        rmicAdapter.setRmic(this);
        Path path = rmicAdapter.getClasspath();
        this.loader = this.getProject().createClassLoader(path);
        try {
            Object object;
            Object object2;
            if (this.classname == null) {
                object2 = this.getDirectoryScanner(this.baseDir);
                object = ((DirectoryScanner)object2).getIncludedFiles();
                this.scanDir(this.baseDir, (String[])object, rmicAdapter.getMapper());
            } else {
                object2 = this.classname.replace('.', File.separatorChar) + ".class";
                object = new File(this.baseDir, (String)object2);
                if (((File)object).isFile()) {
                    this.scanDir(this.baseDir, new String[]{object2}, rmicAdapter.getMapper());
                } else {
                    this.compileList.add(this.classname);
                }
            }
            int n = this.compileList.size();
            if (n > 0) {
                this.log("RMI Compiling " + n + " class" + (n > 1 ? "es" : "") + " to " + this.baseDir, 2);
                if (!rmicAdapter.execute()) {
                    throw new BuildException(ERROR_RMIC_FAILED, this.getLocation());
                }
            }
            if (null != this.sourceBase && !this.baseDir.equals(this.sourceBase) && n > 0) {
                if (this.idl) {
                    this.log("Cannot determine sourcefiles in idl mode, ", 1);
                    this.log("sourcebase attribute will be ignored.", 1);
                } else {
                    for (int i = 0; i < n; ++i) {
                        this.moveGeneratedFile(this.baseDir, this.sourceBase, (String)this.compileList.elementAt(i), rmicAdapter);
                    }
                }
            }
        }
        finally {
            this.compileList.removeAllElements();
        }
    }

    private void moveGeneratedFile(File file, File file2, String string, RmicAdapter rmicAdapter) throws BuildException {
        String string2 = string.replace('.', File.separatorChar) + ".class";
        String[] stringArray = rmicAdapter.getMapper().mapFileName(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string3;
            File file3;
            String string4 = stringArray[i];
            if (!string4.endsWith(".class") || !(file3 = new File(file, string3 = string4.substring(0, n = string4.length() - ".class".length()) + ".java")).exists()) continue;
            File file4 = new File(file2, string3);
            try {
                if (this.filtering) {
                    FILE_UTILS.copyFile(file3, file4, new FilterSetCollection(this.getProject().getGlobalFilterSet()));
                } else {
                    FILE_UTILS.copyFile(file3, file4);
                }
                file3.delete();
                continue;
            }
            catch (IOException iOException) {
                String string5 = "Failed to copy " + file3 + " to " + file4 + " due to " + iOException.getMessage();
                throw new BuildException(string5, iOException, this.getLocation());
            }
        }
    }

    protected void scanDir(File file, String[] stringArray, FileNameMapper fileNameMapper) {
        String[] stringArray2 = stringArray;
        if (this.idl) {
            this.log("will leave uptodate test to rmic implementation in idl mode.", 3);
        } else if (this.iiop && this.iiopOpts != null && this.iiopOpts.indexOf("-always") > -1) {
            this.log("no uptodate test as -always option has been specified", 3);
        } else {
            SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
            stringArray2 = sourceFileScanner.restrict(stringArray, file, file, fileNameMapper);
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i].replace(File.separatorChar, '.');
            string = string.substring(0, string.lastIndexOf(".class"));
            this.compileList.addElement(string);
        }
    }

    public boolean isValidRmiRemote(String string) {
        try {
            Class<?> clazz = this.loader.loadClass(string);
            if (clazz.isInterface() && !this.iiop && !this.idl) {
                return false;
            }
            return this.isValidRmiRemote(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log(ERROR_UNABLE_TO_VERIFY_CLASS + string + ERROR_NOT_FOUND, 1);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.log(ERROR_UNABLE_TO_VERIFY_CLASS + string + ERROR_NOT_DEFINED, 1);
        }
        catch (Throwable throwable) {
            this.log(ERROR_UNABLE_TO_VERIFY_CLASS + string + ERROR_LOADING_CAUSED_EXCEPTION + throwable.getMessage(), 1);
        }
        return false;
    }

    public Class getRemoteInterface(Class clazz) {
        Class<?>[] classArray;
        if (Remote.class.isAssignableFrom(clazz) && (classArray = clazz.getInterfaces()) != null) {
            for (int i = 0; i < classArray.length; ++i) {
                if (!Remote.class.isAssignableFrom(classArray[i])) continue;
                return classArray[i];
            }
        }
        return null;
    }

    private boolean isValidRmiRemote(Class clazz) {
        return this.getRemoteInterface(clazz) != null;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public class ImplementationSpecificArgument
    extends org.apache.tools.ant.util.facade.ImplementationSpecificArgument {
        public void setCompiler(String string) {
            super.setImplementation(string);
        }
    }
}

