/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class Replace
extends MatchingTask {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File src = null;
    private NestedString token = null;
    private NestedString value = new NestedString();
    private File propertyFile = null;
    private File replaceFilterFile = null;
    private Properties properties = null;
    private Vector replacefilters = new Vector();
    private File dir = null;
    private int fileCount;
    private int replaceCount;
    private boolean summary = false;
    private String encoding = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        Object object;
        String[] stringArray;
        Object object2;
        Properties properties;
        Vector vector = (Vector)this.replacefilters.clone();
        Properties properties2 = properties = this.properties == null ? null : (Properties)this.properties.clone();
        if (this.token != null) {
            object2 = new StringBuffer(this.value.getText());
            this.stringReplace((StringBuffer)object2, "\r\n", "\n");
            this.stringReplace((StringBuffer)object2, "\n", StringUtils.LINE_SEP);
            stringArray = new StringBuffer(this.token.getText());
            this.stringReplace((StringBuffer)stringArray, "\r\n", "\n");
            this.stringReplace((StringBuffer)stringArray, "\n", StringUtils.LINE_SEP);
            object = this.createPrimaryfilter();
            ((Replacefilter)object).setToken(stringArray.toString());
            ((Replacefilter)object).setValue(((StringBuffer)object2).toString());
        }
        try {
            Object object3;
            if (this.replaceFilterFile != null) {
                object2 = this.getProperties(this.replaceFilterFile);
                stringArray = ((Properties)object2).keys();
                while (stringArray.hasMoreElements()) {
                    object = stringArray.nextElement().toString();
                    object3 = this.createReplacefilter();
                    ((Replacefilter)object3).setToken((String)object);
                    ((Replacefilter)object3).setValue(((Properties)object2).getProperty((String)object));
                }
            }
            this.validateAttributes();
            if (this.propertyFile != null) {
                this.properties = this.getProperties(this.propertyFile);
            }
            this.validateReplacefilters();
            this.fileCount = 0;
            this.replaceCount = 0;
            if (this.src != null) {
                this.processFile(this.src);
            }
            if (this.dir != null) {
                object2 = super.getDirectoryScanner(this.dir);
                stringArray = ((DirectoryScanner)object2).getIncludedFiles();
                for (int i = 0; i < stringArray.length; ++i) {
                    object3 = new File(this.dir, stringArray[i]);
                    this.processFile((File)object3);
                }
            }
            if (this.summary) {
                this.log("Replaced " + this.replaceCount + " occurrences in " + this.fileCount + " files.", 2);
            }
        }
        finally {
            this.replacefilters = vector;
            this.properties = properties;
        }
    }

    public void validateAttributes() throws BuildException {
        if (this.src == null && this.dir == null) {
            String string = "Either the file or the dir attribute must be specified";
            throw new BuildException(string, this.getLocation());
        }
        if (this.propertyFile != null && !this.propertyFile.exists()) {
            String string = "Property file " + this.propertyFile.getPath() + " does not exist.";
            throw new BuildException(string, this.getLocation());
        }
        if (this.token == null && this.replacefilters.size() == 0) {
            String string = "Either token or a nested replacefilter must be specified";
            throw new BuildException(string, this.getLocation());
        }
        if (this.token != null && "".equals(this.token.getText())) {
            String string = "The token attribute must not be an empty string.";
            throw new BuildException(string, this.getLocation());
        }
    }

    public void validateReplacefilters() throws BuildException {
        for (int i = 0; i < this.replacefilters.size(); ++i) {
            Replacefilter replacefilter = (Replacefilter)this.replacefilters.elementAt(i);
            replacefilter.validate();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties getProperties(File file) throws BuildException {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                String string = "Property file (" + file.getPath() + ") not found.";
                throw new BuildException(string);
                catch (IOException iOException) {
                    String string2 = "Property file (" + file.getPath() + ") cannot be loaded.";
                    throw new BuildException(string2);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(fileInputStream);
                throw throwable;
            }
        }
        FileUtils.close(fileInputStream);
        return properties;
    }

    private void processFile(File file) throws BuildException {
        if (!file.exists()) {
            throw new BuildException("Replace: source file " + file.getPath() + " doesn't exist", this.getLocation());
        }
        File file2 = null;
        FileInput fileInput = null;
        FileOutput fileOutput = null;
        try {
            boolean bl;
            fileInput = new FileInput(file);
            file2 = FILE_UTILS.createTempFile("rep", ".tmp", file.getParentFile(), false, true);
            fileOutput = new FileOutput(file2);
            int n = this.replaceCount;
            this.logFilterChain(file.getPath());
            fileOutput.setInputBuffer(this.buildFilterChain(fileInput.getOutputBuffer()));
            while (fileInput.readChunk()) {
                if (!this.processFilterChain()) continue;
                fileOutput.process();
            }
            this.flushFilterChain();
            fileOutput.flush();
            fileInput.close();
            fileInput = null;
            fileOutput.close();
            fileOutput = null;
            boolean bl2 = bl = this.replaceCount != n;
            if (bl) {
                ++this.fileCount;
                FILE_UTILS.rename(file2, file);
                file2 = null;
            }
        }
        catch (IOException iOException) {
            throw new BuildException("IOException in " + file + " - " + iOException.getClass().getName() + ":" + iOException.getMessage(), iOException, this.getLocation());
        }
        finally {
            if (null != fileInput) {
                fileInput.closeQuietly();
            }
            if (null != fileOutput) {
                fileOutput.closeQuietly();
            }
            if (file2 != null && !file2.delete()) {
                file2.deleteOnExit();
            }
        }
    }

    private void flushFilterChain() {
        for (int i = 0; i < this.replacefilters.size(); ++i) {
            Replacefilter replacefilter = (Replacefilter)this.replacefilters.elementAt(i);
            replacefilter.flush();
        }
    }

    private boolean processFilterChain() {
        for (int i = 0; i < this.replacefilters.size(); ++i) {
            Replacefilter replacefilter = (Replacefilter)this.replacefilters.elementAt(i);
            if (replacefilter.process()) continue;
            return false;
        }
        return true;
    }

    private StringBuffer buildFilterChain(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        for (int i = 0; i < this.replacefilters.size(); ++i) {
            Replacefilter replacefilter = (Replacefilter)this.replacefilters.elementAt(i);
            replacefilter.setInputBuffer(stringBuffer2);
            stringBuffer2 = replacefilter.getOutputBuffer();
        }
        return stringBuffer2;
    }

    private void logFilterChain(String string) {
        for (int i = 0; i < this.replacefilters.size(); ++i) {
            Replacefilter replacefilter = (Replacefilter)this.replacefilters.elementAt(i);
            this.log("Replacing in " + string + ": " + replacefilter.getToken() + " --> " + replacefilter.getReplaceValue(), 3);
        }
    }

    public void setFile(File file) {
        this.src = file;
    }

    public void setSummary(boolean bl) {
        this.summary = bl;
    }

    public void setReplaceFilterFile(File file) {
        this.replaceFilterFile = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setToken(String string) {
        this.createReplaceToken().addText(string);
    }

    public void setValue(String string) {
        this.createReplaceValue().addText(string);
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public NestedString createReplaceToken() {
        if (this.token == null) {
            this.token = new NestedString();
        }
        return this.token;
    }

    public NestedString createReplaceValue() {
        return this.value;
    }

    public void setPropertyFile(File file) {
        this.propertyFile = file;
    }

    public Replacefilter createReplacefilter() {
        Replacefilter replacefilter = new Replacefilter();
        this.replacefilters.addElement(replacefilter);
        return replacefilter;
    }

    private Replacefilter createPrimaryfilter() {
        Replacefilter replacefilter = new Replacefilter();
        this.replacefilters.insertElementAt(replacefilter, 0);
        return replacefilter;
    }

    private void stringReplace(StringBuffer stringBuffer, String string, String string2) {
        int n = stringBuffer.toString().indexOf(string);
        while (n >= 0) {
            stringBuffer.replace(n, n + string.length(), string2);
            n = stringBuffer.toString().indexOf(string, n + string2.length());
        }
    }

    private class FileOutput {
        private StringBuffer inputBuffer;
        private Writer writer;

        FileOutput(File file) throws IOException {
            this.writer = Replace.this.encoding == null ? new BufferedWriter(new FileWriter(file)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Replace.this.encoding));
        }

        void setInputBuffer(StringBuffer stringBuffer) {
            this.inputBuffer = stringBuffer;
        }

        boolean process() throws IOException {
            this.writer.write(this.inputBuffer.toString());
            this.inputBuffer.delete(0, this.inputBuffer.length());
            return false;
        }

        void flush() throws IOException {
            this.process();
            this.writer.flush();
        }

        void close() throws IOException {
            this.writer.close();
        }

        void closeQuietly() {
            FileUtils.close(this.writer);
        }
    }

    private class FileInput {
        private StringBuffer outputBuffer = new StringBuffer();
        private Reader reader;
        private char[] buffer = new char[4096];
        private static final int BUFF_SIZE = 4096;

        FileInput(File file) throws IOException {
            this.reader = Replace.this.encoding == null ? new BufferedReader(new FileReader(file)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Replace.this.encoding));
        }

        StringBuffer getOutputBuffer() {
            return this.outputBuffer;
        }

        boolean readChunk() throws IOException {
            int n = 0;
            n = this.reader.read(this.buffer);
            if (n < 0) {
                return false;
            }
            this.outputBuffer.append(new String(this.buffer, 0, n));
            return true;
        }

        void close() throws IOException {
            this.reader.close();
        }

        void closeQuietly() {
            FileUtils.close(this.reader);
        }
    }

    public class Replacefilter {
        private String token;
        private String value;
        private String replaceValue;
        private String property;
        private StringBuffer inputBuffer;
        private StringBuffer outputBuffer = new StringBuffer();

        public void validate() throws BuildException {
            if (this.token == null) {
                String string = "token is a mandatory attribute of replacefilter.";
                throw new BuildException(string);
            }
            if ("".equals(this.token)) {
                String string = "The token attribute must not be an empty string.";
                throw new BuildException(string);
            }
            if (this.value != null && this.property != null) {
                String string = "Either value or property can be specified, but a replacefilter element cannot have both.";
                throw new BuildException(string);
            }
            if (this.property != null) {
                if (Replace.this.propertyFile == null) {
                    String string = "The replacefilter's property attribute can only be used with the replacetask's propertyFile attribute.";
                    throw new BuildException(string);
                }
                if (Replace.this.properties == null || Replace.this.properties.getProperty(this.property) == null) {
                    String string = "property \"" + this.property + "\" was not found in " + Replace.this.propertyFile.getPath();
                    throw new BuildException(string);
                }
            }
            this.replaceValue = this.getReplaceValue();
        }

        public String getReplaceValue() {
            if (this.property != null) {
                return Replace.this.properties.getProperty(this.property);
            }
            if (this.value != null) {
                return this.value;
            }
            if (Replace.this.value != null) {
                return Replace.this.value.getText();
            }
            return "";
        }

        public void setToken(String string) {
            this.token = string;
        }

        public String getToken() {
            return this.token;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setProperty(String string) {
            this.property = string;
        }

        public String getProperty() {
            return this.property;
        }

        StringBuffer getOutputBuffer() {
            return this.outputBuffer;
        }

        void setInputBuffer(StringBuffer stringBuffer) {
            this.inputBuffer = stringBuffer;
        }

        boolean process() {
            if (this.inputBuffer.length() > this.token.length()) {
                int n = this.replace();
                n = Math.max(this.inputBuffer.length() - this.token.length(), n);
                this.outputBuffer.append(this.inputBuffer.substring(0, n));
                this.inputBuffer.delete(0, n);
                return true;
            }
            return false;
        }

        void flush() {
            this.replace();
            this.outputBuffer.append(this.inputBuffer.toString());
            this.inputBuffer.delete(0, this.inputBuffer.length());
        }

        private int replace() {
            int n = this.inputBuffer.toString().indexOf(this.token);
            int n2 = -1;
            while (n >= 0) {
                this.inputBuffer.replace(n, n + this.token.length(), this.replaceValue);
                n2 = n + this.replaceValue.length();
                n = this.inputBuffer.toString().indexOf(this.token, n2);
                ++Replace.this.replaceCount;
            }
            return n2;
        }
    }

    public class NestedString {
        private StringBuffer buf = new StringBuffer();

        public void addText(String string) {
            this.buf.append(string);
        }

        public String getText() {
            return this.buf.toString();
        }
    }
}

