/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.StreamPumper;
import org.apache.tools.ant.util.ConcatFileInputStream;
import org.apache.tools.ant.util.KeepAliveOutputStream;
import org.apache.tools.ant.util.LazyFileOutputStream;
import org.apache.tools.ant.util.LeadPipeInputStream;
import org.apache.tools.ant.util.OutputStreamFunneler;
import org.apache.tools.ant.util.ReaderInputStream;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.ant.util.TeeOutputStream;

public class Redirector {
    private static final int ONE_SECOND = 1000;
    private static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    private File[] input;
    private File[] out;
    private File[] error;
    private boolean logError = false;
    private PropertyOutputStream baos = null;
    private PropertyOutputStream errorBaos = null;
    private String outputProperty;
    private String errorProperty;
    private String inputString;
    private boolean append = false;
    private boolean alwaysLog = false;
    private boolean createEmptyFiles = true;
    private ProjectComponent managingTask;
    private OutputStream outputStream = null;
    private OutputStream errorStream = null;
    private InputStream inputStream = null;
    private PrintStream outPrintStream = null;
    private PrintStream errorPrintStream = null;
    private Vector outputFilterChains;
    private Vector errorFilterChains;
    private Vector inputFilterChains;
    private String outputEncoding = DEFAULT_ENCODING;
    private String errorEncoding = DEFAULT_ENCODING;
    private String inputEncoding = DEFAULT_ENCODING;
    private boolean appendProperties = true;
    private ThreadGroup threadGroup = new ThreadGroup("redirector");
    private boolean logInputString = true;

    public Redirector(Task task) {
        this((ProjectComponent)task);
    }

    public Redirector(ProjectComponent projectComponent) {
        this.managingTask = projectComponent;
    }

    public void setInput(File file) {
        File[] fileArray;
        if (file == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        this.setInput(fileArray);
    }

    public synchronized void setInput(File[] fileArray) {
        this.input = fileArray;
    }

    public synchronized void setInputString(String string) {
        this.inputString = string;
    }

    public void setLogInputString(boolean bl) {
        this.logInputString = bl;
    }

    void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setOutput(File file) {
        File[] fileArray;
        if (file == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        this.setOutput(fileArray);
    }

    public synchronized void setOutput(File[] fileArray) {
        this.out = fileArray;
    }

    public synchronized void setOutputEncoding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("outputEncoding must not be null");
        }
        this.outputEncoding = string;
    }

    public synchronized void setErrorEncoding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("errorEncoding must not be null");
        }
        this.errorEncoding = string;
    }

    public synchronized void setInputEncoding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("inputEncoding must not be null");
        }
        this.inputEncoding = string;
    }

    public synchronized void setLogError(boolean bl) {
        this.logError = bl;
    }

    public synchronized void setAppendProperties(boolean bl) {
        this.appendProperties = bl;
    }

    public void setError(File file) {
        File[] fileArray;
        if (file == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        this.setError(fileArray);
    }

    public synchronized void setError(File[] fileArray) {
        this.error = fileArray;
    }

    public synchronized void setOutputProperty(String string) {
        if (string == null || !string.equals(this.outputProperty)) {
            this.outputProperty = string;
            this.baos = null;
        }
    }

    public synchronized void setAppend(boolean bl) {
        this.append = bl;
    }

    public synchronized void setAlwaysLog(boolean bl) {
        this.alwaysLog = bl;
    }

    public synchronized void setCreateEmptyFiles(boolean bl) {
        this.createEmptyFiles = bl;
    }

    public synchronized void setErrorProperty(String string) {
        if (string == null || !string.equals(this.errorProperty)) {
            this.errorProperty = string;
            this.errorBaos = null;
        }
    }

    public synchronized void setInputFilterChains(Vector vector) {
        this.inputFilterChains = vector;
    }

    public synchronized void setOutputFilterChains(Vector vector) {
        this.outputFilterChains = vector;
    }

    public synchronized void setErrorFilterChains(Vector vector) {
        this.errorFilterChains = vector;
    }

    private void setPropertyFromBAOS(ByteArrayOutputStream byteArrayOutputStream, String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(Execute.toString(byteArrayOutputStream)));
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(StringUtils.LINE_SEP);
            }
            stringBuffer.append(string2);
        }
        this.managingTask.getProject().setNewProperty(string, stringBuffer.toString());
    }

    public synchronized void createStreams() {
        Object object;
        Reader reader;
        Closeable closeable;
        Object object2;
        this.outStreams();
        this.errorStreams();
        if (this.alwaysLog || this.outputStream == null) {
            object2 = new LogOutputStream(this.managingTask, 2);
            OutputStream outputStream = this.outputStream = this.outputStream == null ? object2 : new TeeOutputStream((OutputStream)object2, this.outputStream);
        }
        if (this.alwaysLog || this.errorStream == null) {
            object2 = new LogOutputStream(this.managingTask, 1);
            OutputStream outputStream = this.errorStream = this.errorStream == null ? object2 : new TeeOutputStream((OutputStream)object2, this.errorStream);
        }
        if (this.outputFilterChains != null && this.outputFilterChains.size() > 0 || !this.outputEncoding.equalsIgnoreCase(this.inputEncoding)) {
            try {
                object2 = new LeadPipeInputStream();
                ((LeadPipeInputStream)object2).setManagingComponent(this.managingTask);
                closeable = object2;
                reader = new InputStreamReader((InputStream)closeable, this.inputEncoding);
                if (this.outputFilterChains != null && this.outputFilterChains.size() > 0) {
                    object = new ChainReaderHelper();
                    ((ChainReaderHelper)object).setProject(this.managingTask.getProject());
                    ((ChainReaderHelper)object).setPrimaryReader(reader);
                    ((ChainReaderHelper)object).setFilterChains(this.outputFilterChains);
                    reader = ((ChainReaderHelper)object).getAssembledReader();
                }
                closeable = new ReaderInputStream(reader, this.outputEncoding);
                object = new Thread(this.threadGroup, new StreamPumper((InputStream)closeable, this.outputStream, true), "output pumper");
                ((Thread)object).setPriority(10);
                this.outputStream = new PipedOutputStream((PipedInputStream)object2);
                ((Thread)object).start();
            }
            catch (IOException iOException) {
                throw new BuildException("error setting up output stream", iOException);
            }
        }
        if (this.errorFilterChains != null && this.errorFilterChains.size() > 0 || !this.errorEncoding.equalsIgnoreCase(this.inputEncoding)) {
            try {
                object2 = new LeadPipeInputStream();
                ((LeadPipeInputStream)object2).setManagingComponent(this.managingTask);
                closeable = object2;
                reader = new InputStreamReader((InputStream)closeable, this.inputEncoding);
                if (this.errorFilterChains != null && this.errorFilterChains.size() > 0) {
                    object = new ChainReaderHelper();
                    ((ChainReaderHelper)object).setProject(this.managingTask.getProject());
                    ((ChainReaderHelper)object).setPrimaryReader(reader);
                    ((ChainReaderHelper)object).setFilterChains(this.errorFilterChains);
                    reader = ((ChainReaderHelper)object).getAssembledReader();
                }
                closeable = new ReaderInputStream(reader, this.errorEncoding);
                object = new Thread(this.threadGroup, new StreamPumper((InputStream)closeable, this.errorStream, true), "error pumper");
                ((Thread)object).setPriority(10);
                this.errorStream = new PipedOutputStream((PipedInputStream)object2);
                ((Thread)object).start();
            }
            catch (IOException iOException) {
                throw new BuildException("error setting up error stream", iOException);
            }
        }
        if (this.input != null && this.input.length > 0) {
            this.managingTask.log("Redirecting input from file" + (this.input.length == 1 ? "" : "s"), 3);
            try {
                this.inputStream = new ConcatFileInputStream(this.input);
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
            ((ConcatFileInputStream)this.inputStream).setManagingComponent(this.managingTask);
        } else if (this.inputString != null) {
            object2 = new StringBuffer("Using input ");
            if (this.logInputString) {
                ((StringBuffer)object2).append('\"').append(this.inputString).append('\"');
            } else {
                ((StringBuffer)object2).append("string");
            }
            this.managingTask.log(((StringBuffer)object2).toString(), 3);
            this.inputStream = new ByteArrayInputStream(this.inputString.getBytes());
        }
        if (this.inputStream != null && this.inputFilterChains != null && this.inputFilterChains.size() > 0) {
            object2 = new ChainReaderHelper();
            ((ChainReaderHelper)object2).setProject(this.managingTask.getProject());
            try {
                ((ChainReaderHelper)object2).setPrimaryReader(new InputStreamReader(this.inputStream, this.inputEncoding));
            }
            catch (IOException iOException) {
                throw new BuildException("error setting up input stream", iOException);
            }
            ((ChainReaderHelper)object2).setFilterChains(this.inputFilterChains);
            this.inputStream = new ReaderInputStream(((ChainReaderHelper)object2).getAssembledReader(), this.inputEncoding);
        }
    }

    private void outStreams() {
        Object object;
        if (this.out != null && this.out.length > 0) {
            object = new StringBuffer("Output ").append(this.append ? "appended" : "redirected").append(" to ").toString();
            this.outputStream = this.foldFiles(this.out, (String)object, 3);
        }
        if (this.outputProperty != null) {
            if (this.baos == null) {
                this.baos = new PropertyOutputStream(this.outputProperty);
                this.managingTask.log("Output redirected to property: " + this.outputProperty, 3);
            }
            object = new KeepAliveOutputStream(this.baos);
            this.outputStream = this.outputStream == null ? object : new TeeOutputStream(this.outputStream, (OutputStream)object);
        } else {
            this.baos = null;
        }
    }

    private void errorStreams() {
        Object object;
        if (this.error != null && this.error.length > 0) {
            object = new StringBuffer("Error ").append(this.append ? "appended" : "redirected").append(" to ").toString();
            this.errorStream = this.foldFiles(this.error, (String)object, 3);
        } else if (!this.logError && this.outputStream != null) {
            long l = 0L;
            OutputStreamFunneler outputStreamFunneler = new OutputStreamFunneler(this.outputStream, l);
            try {
                this.outputStream = outputStreamFunneler.getFunnelInstance();
                this.errorStream = outputStreamFunneler.getFunnelInstance();
            }
            catch (IOException iOException) {
                throw new BuildException("error splitting output/error streams", iOException);
            }
        }
        if (this.errorProperty != null) {
            if (this.errorBaos == null) {
                this.errorBaos = new PropertyOutputStream(this.errorProperty);
                this.managingTask.log("Error redirected to property: " + this.errorProperty, 3);
            }
            object = new KeepAliveOutputStream(this.errorBaos);
            this.errorStream = this.error == null || this.error.length == 0 ? object : new TeeOutputStream(this.errorStream, (OutputStream)object);
        } else {
            this.errorBaos = null;
        }
    }

    public synchronized ExecuteStreamHandler createHandler() throws BuildException {
        this.createStreams();
        return new PumpStreamHandler(this.outputStream, this.errorStream, this.inputStream);
    }

    protected synchronized void handleOutput(String string) {
        if (this.outPrintStream == null) {
            this.outPrintStream = new PrintStream(this.outputStream);
        }
        this.outPrintStream.print(string);
    }

    protected synchronized int handleInput(byte[] byArray, int n, int n2) throws IOException {
        if (this.inputStream == null) {
            return this.managingTask.getProject().defaultInput(byArray, n, n2);
        }
        return this.inputStream.read(byArray, n, n2);
    }

    protected synchronized void handleFlush(String string) {
        if (this.outPrintStream == null) {
            this.outPrintStream = new PrintStream(this.outputStream);
        }
        this.outPrintStream.print(string);
        this.outPrintStream.flush();
    }

    protected synchronized void handleErrorOutput(String string) {
        if (this.errorPrintStream == null) {
            this.errorPrintStream = new PrintStream(this.errorStream);
        }
        this.errorPrintStream.print(string);
    }

    protected synchronized void handleErrorFlush(String string) {
        if (this.errorPrintStream == null) {
            this.errorPrintStream = new PrintStream(this.errorStream);
        }
        this.errorPrintStream.print(string);
    }

    public synchronized OutputStream getOutputStream() {
        return this.outputStream;
    }

    public synchronized OutputStream getErrorStream() {
        return this.errorStream;
    }

    public synchronized InputStream getInputStream() {
        return this.inputStream;
    }

    public synchronized void complete() throws IOException {
        System.out.flush();
        System.err.flush();
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        this.outputStream.flush();
        this.outputStream.close();
        this.errorStream.flush();
        this.errorStream.close();
        while (this.threadGroup.activeCount() > 0) {
            try {
                this.managingTask.log("waiting for " + this.threadGroup.activeCount() + " Threads:", 4);
                Thread[] threadArray = new Thread[this.threadGroup.activeCount()];
                this.threadGroup.enumerate(threadArray);
                for (int i = 0; i < threadArray.length && threadArray[i] != null; ++i) {
                    try {
                        this.managingTask.log(threadArray[i].toString(), 4);
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setProperties();
        this.inputStream = null;
        this.outputStream = null;
        this.errorStream = null;
        this.outPrintStream = null;
        this.errorPrintStream = null;
    }

    public synchronized void setProperties() {
        if (this.baos != null) {
            try {
                this.baos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.errorBaos != null) {
            try {
                this.errorBaos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private OutputStream foldFiles(File[] fileArray, String string, int n) {
        LazyFileOutputStream lazyFileOutputStream = new LazyFileOutputStream(fileArray[0], this.append, this.createEmptyFiles);
        this.managingTask.log(string + fileArray[0], n);
        char[] cArray = new char[string.length()];
        Arrays.fill(cArray, ' ');
        String string2 = new String(cArray);
        for (int i = 1; i < fileArray.length; ++i) {
            this.outputStream = new TeeOutputStream(this.outputStream, new LazyFileOutputStream(fileArray[i], this.append, this.createEmptyFiles));
            this.managingTask.log(string2 + fileArray[i], n);
        }
        return lazyFileOutputStream;
    }

    private class PropertyOutputStream
    extends ByteArrayOutputStream {
        private String property;
        private boolean closed = false;

        PropertyOutputStream(String string) {
            this.property = string;
        }

        @Override
        public void close() throws IOException {
            if (!(this.closed || Redirector.this.append && Redirector.this.appendProperties)) {
                Redirector.this.setPropertyFromBAOS(this, this.property);
                this.closed = true;
            }
        }
    }
}

