/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.Hashtable;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.RecorderEntry;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.LogLevel;

public class Recorder
extends Task
implements SubBuildListener {
    private String filename = null;
    private Boolean append = null;
    private Boolean start = null;
    private int loglevel = -1;
    private boolean emacsMode = false;
    private static Hashtable recorderEntries = new Hashtable();

    @Override
    public void init() {
        this.getProject().addBuildListener(this);
    }

    public void setName(String string) {
        this.filename = string;
    }

    public void setAction(ActionChoices actionChoices) {
        this.start = actionChoices.getValue().equalsIgnoreCase("start") ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAppend(boolean bl) {
        this.append = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setEmacsMode(boolean bl) {
        this.emacsMode = bl;
    }

    public void setLoglevel(VerbosityLevelChoices verbosityLevelChoices) {
        this.loglevel = verbosityLevelChoices.getLevel();
    }

    @Override
    public void execute() throws BuildException {
        if (this.filename == null) {
            throw new BuildException("No filename specified");
        }
        this.getProject().log("setting a recorder for name " + this.filename, 4);
        RecorderEntry recorderEntry = this.getRecorder(this.filename, this.getProject());
        recorderEntry.setMessageOutputLevel(this.loglevel);
        recorderEntry.setEmacsMode(this.emacsMode);
        if (this.start != null) {
            if (this.start.booleanValue()) {
                recorderEntry.reopenFile();
                recorderEntry.setRecordState(this.start);
            } else {
                recorderEntry.setRecordState(this.start);
                recorderEntry.closeFile();
            }
        }
    }

    protected RecorderEntry getRecorder(String string, Project project) throws BuildException {
        RecorderEntry recorderEntry;
        Object v = recorderEntries.get(string);
        if (v == null) {
            recorderEntry = new RecorderEntry(string);
            if (this.append == null) {
                recorderEntry.openFile(false);
            } else {
                recorderEntry.openFile(this.append);
            }
            recorderEntry.setProject(project);
            recorderEntries.put(string, recorderEntry);
        } else {
            recorderEntry = (RecorderEntry)v;
        }
        return recorderEntry;
    }

    @Override
    public void buildStarted(BuildEvent buildEvent) {
    }

    @Override
    public void subBuildStarted(BuildEvent buildEvent) {
    }

    @Override
    public void targetStarted(BuildEvent buildEvent) {
    }

    @Override
    public void targetFinished(BuildEvent buildEvent) {
    }

    @Override
    public void taskStarted(BuildEvent buildEvent) {
    }

    @Override
    public void taskFinished(BuildEvent buildEvent) {
    }

    @Override
    public void messageLogged(BuildEvent buildEvent) {
    }

    @Override
    public void buildFinished(BuildEvent buildEvent) {
        this.cleanup();
    }

    @Override
    public void subBuildFinished(BuildEvent buildEvent) {
        if (buildEvent.getProject() == this.getProject()) {
            this.cleanup();
        }
    }

    private void cleanup() {
        recorderEntries.clear();
        this.getProject().removeBuildListener(this);
    }

    public static class VerbosityLevelChoices
    extends LogLevel {
    }

    public static class ActionChoices
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"start", "stop"};

        @Override
        public String[] getValues() {
            return VALUES;
        }
    }
}

