/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Property
extends Task {
    protected String name;
    protected String value;
    protected File file;
    protected URL url;
    protected String resource;
    protected Path classpath;
    protected String env;
    protected Reference ref;
    protected String prefix;
    private Project fallback;
    protected boolean userProperty;

    public Property() {
        this(false);
    }

    protected Property(boolean bl) {
        this(bl, null);
    }

    protected Property(boolean bl, Project project) {
        this.userProperty = bl;
        this.fallback = project;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(File file) {
        this.setValue(file.getAbsolutePath());
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setPrefix(String string) {
        this.prefix = string;
        if (!string.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setRefid(Reference reference) {
        this.ref = reference;
    }

    public Reference getRefid() {
        return this.ref;
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public String getResource() {
        return this.resource;
    }

    public void setEnvironment(String string) {
        this.env = string;
    }

    public String getEnvironment() {
        return this.env;
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setUserProperty(boolean bl) {
        this.log("DEPRECATED: Ignoring request to set user property in Property task.", 1);
    }

    public String toString() {
        return this.value == null ? "" : this.value;
    }

    @Override
    public void execute() throws BuildException {
        if (this.getProject() == null) {
            throw new IllegalStateException("project has not been set");
        }
        if (this.name != null) {
            if (this.value == null && this.ref == null) {
                throw new BuildException("You must specify value, location or refid with the name attribute", this.getLocation());
            }
        } else if (this.url == null && this.file == null && this.resource == null && this.env == null) {
            throw new BuildException("You must specify url, file, resource or environment when not using the name attribute", this.getLocation());
        }
        if (this.url == null && this.file == null && this.resource == null && this.prefix != null) {
            throw new BuildException("Prefix is only valid when loading from a url, file or resource", this.getLocation());
        }
        if (this.name != null && this.value != null) {
            this.addProperty(this.name, this.value);
        }
        if (this.file != null) {
            this.loadFile(this.file);
        }
        if (this.url != null) {
            this.loadUrl(this.url);
        }
        if (this.resource != null) {
            this.loadResource(this.resource);
        }
        if (this.env != null) {
            this.loadEnvironment(this.env);
        }
        if (this.name != null && this.ref != null) {
            try {
                this.addProperty(this.name, this.ref.getReferencedObject(this.getProject()).toString());
            }
            catch (BuildException buildException) {
                if (this.fallback != null) {
                    this.addProperty(this.name, this.ref.getReferencedObject(this.fallback).toString());
                }
                throw buildException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadUrl(URL uRL) throws BuildException {
        Properties properties = new Properties();
        this.log("Loading " + uRL, 3);
        try {
            InputStream inputStream = uRL.openStream();
            try {
                properties.load(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            this.addProperties(properties);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException, this.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFile(File file) throws BuildException {
        block8: {
            Properties properties = new Properties();
            this.log("Loading " + file.getAbsolutePath(), 3);
            try {
                if (file.exists()) {
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(file);
                        properties.load(fileInputStream);
                    }
                    finally {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    this.addProperties(properties);
                    break block8;
                }
                this.log("Unable to find property file: " + file.getAbsolutePath(), 3);
            }
            catch (IOException iOException) {
                throw new BuildException(iOException, this.getLocation());
            }
        }
    }

    protected void loadResource(String string) {
        Properties properties = new Properties();
        this.log("Resource Loading " + string, 3);
        InputStream inputStream = null;
        try {
            ClassLoader classLoader = null;
            classLoader = this.classpath != null ? this.getProject().createClassLoader(this.classpath) : this.getClass().getClassLoader();
            inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string) : classLoader.getResourceAsStream(string);
            if (inputStream != null) {
                properties.load(inputStream);
                this.addProperties(properties);
            } else {
                this.log("Unable to find resource " + string, 1);
            }
        }
        catch (IOException iOException) {
            throw new BuildException(iOException, this.getLocation());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void loadEnvironment(String string) {
        Properties properties = new Properties();
        if (!string.endsWith(".")) {
            string = string + ".";
        }
        this.log("Loading Environment " + string, 3);
        Vector vector = Execute.getProcEnvironment();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            int n = string2.indexOf(61);
            if (n == -1) {
                this.log("Ignoring: " + string2, 1);
                continue;
            }
            properties.put(string + string2.substring(0, n), string2.substring(n + 1));
        }
        this.addProperties(properties);
    }

    protected void addProperties(Properties properties) {
        this.resolveAllProperties(properties);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            String string3 = this.getProject().replaceProperties(string2);
            if (this.prefix != null) {
                string = this.prefix + string;
            }
            this.addProperty(string, string3);
        }
    }

    protected void addProperty(String string, String string2) {
        if (this.userProperty) {
            if (this.getProject().getUserProperty(string) == null) {
                this.getProject().setInheritedProperty(string, string2);
            } else {
                this.log("Override ignored for " + string, 3);
            }
        } else {
            this.getProject().setNewProperty(string, string2);
        }
    }

    private void resolveAllProperties(Properties properties) throws BuildException {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Stack stack = new Stack();
            this.resolve(properties, string, stack);
        }
    }

    private void resolve(Properties properties, String string, Stack stack) throws BuildException {
        if (stack.contains(string)) {
            throw new BuildException("Property " + string + " was circularly " + "defined.");
        }
        String string2 = properties.getProperty(string);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        PropertyHelper.getPropertyHelper(this.getProject()).parsePropertyString(string2, vector, vector2);
        if (vector2.size() != 0) {
            stack.push(string);
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = vector.elements();
            Enumeration enumeration2 = vector2.elements();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (string3 == null) {
                    String string4 = (String)enumeration2.nextElement();
                    string3 = this.getProject().getProperty(string4);
                    if (string3 == null) {
                        if (properties.containsKey(string4)) {
                            this.resolve(properties, string4, stack);
                            string3 = properties.getProperty(string4);
                        } else {
                            string3 = "${" + string4 + "}";
                        }
                    }
                }
                stringBuffer.append(string3);
            }
            string2 = stringBuffer.toString();
            properties.put(string, string2);
            stack.pop();
        }
    }
}

