/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.AntlibDefinition;

public class PreSetDef
extends AntlibDefinition
implements TaskContainer {
    private UnknownElement nestedTask;
    private String name;

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void addTask(Task task) {
        if (this.nestedTask != null) {
            throw new BuildException("Only one nested element allowed");
        }
        if (!(task instanceof UnknownElement)) {
            throw new BuildException("addTask called with a task that is not an unknown element");
        }
        this.nestedTask = (UnknownElement)task;
    }

    @Override
    public void execute() {
        String string;
        if (this.nestedTask == null) {
            throw new BuildException("Missing nested element");
        }
        if (this.name == null) {
            throw new BuildException("Name not specified");
        }
        this.name = ProjectHelper.genComponentName(this.getURI(), this.name);
        ComponentHelper componentHelper = ComponentHelper.getComponentHelper(this.getProject());
        AntTypeDefinition antTypeDefinition = componentHelper.getDefinition(string = ProjectHelper.genComponentName(this.nestedTask.getNamespace(), this.nestedTask.getTag()));
        if (antTypeDefinition == null) {
            throw new BuildException("Unable to find typedef " + string);
        }
        PreSetDefinition preSetDefinition = new PreSetDefinition(antTypeDefinition, this.nestedTask);
        preSetDefinition.setName(this.name);
        componentHelper.addDataTypeDefinition(preSetDefinition);
        this.log("defining preset " + this.name, 3);
    }

    public static class PreSetDefinition
    extends AntTypeDefinition {
        private AntTypeDefinition parent;
        private UnknownElement element;

        public PreSetDefinition(AntTypeDefinition antTypeDefinition, UnknownElement unknownElement) {
            if (antTypeDefinition instanceof PreSetDefinition) {
                PreSetDefinition preSetDefinition = (PreSetDefinition)antTypeDefinition;
                unknownElement.applyPreSet(preSetDefinition.element);
                antTypeDefinition = preSetDefinition.parent;
            }
            this.parent = antTypeDefinition;
            this.element = unknownElement;
        }

        @Override
        public void setClass(Class clazz) {
            throw new BuildException("Not supported");
        }

        @Override
        public void setClassName(String string) {
            throw new BuildException("Not supported");
        }

        @Override
        public String getClassName() {
            return this.parent.getClassName();
        }

        @Override
        public void setAdapterClass(Class clazz) {
            throw new BuildException("Not supported");
        }

        @Override
        public void setAdaptToClass(Class clazz) {
            throw new BuildException("Not supported");
        }

        @Override
        public void setClassLoader(ClassLoader classLoader) {
            throw new BuildException("Not supported");
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.parent.getClassLoader();
        }

        @Override
        public Class getExposedClass(Project project) {
            return this.parent.getExposedClass(project);
        }

        @Override
        public Class getTypeClass(Project project) {
            return this.parent.getTypeClass(project);
        }

        @Override
        public void checkClass(Project project) {
            this.parent.checkClass(project);
        }

        public Object createObject(Project project) {
            return this.parent.create(project);
        }

        public UnknownElement getPreSets() {
            return this.element;
        }

        @Override
        public Object create(Project project) {
            return this;
        }

        @Override
        public boolean sameDefinition(AntTypeDefinition antTypeDefinition, Project project) {
            return antTypeDefinition != null && antTypeDefinition.getClass() == this.getClass() && this.parent != null && this.parent.sameDefinition(((PreSetDefinition)antTypeDefinition).parent, project) && this.element.similar(((PreSetDefinition)antTypeDefinition).element);
        }

        @Override
        public boolean similarDefinition(AntTypeDefinition antTypeDefinition, Project project) {
            return antTypeDefinition != null && antTypeDefinition.getClass().getName().equals(this.getClass().getName()) && this.parent != null && this.parent.similarDefinition(((PreSetDefinition)antTypeDefinition).parent, project) && this.element.similar(((PreSetDefinition)antTypeDefinition).element);
        }
    }
}

