/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;

public class ManifestTask
extends Task {
    public static final String VALID_ATTRIBUTE_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ012345679-_";
    private Manifest nestedManifest = new Manifest();
    private File manifestFile;
    private Mode mode = new Mode();
    private String encoding;

    public ManifestTask() {
        this.mode.setValue("replace");
    }

    public void addConfiguredSection(Manifest.Section section) throws ManifestException {
        Enumeration enumeration = section.getAttributeKeys();
        while (enumeration.hasMoreElements()) {
            Manifest.Attribute attribute = section.getAttribute((String)enumeration.nextElement());
            this.checkAttribute(attribute);
        }
        this.nestedManifest.addConfiguredSection(section);
    }

    public void addConfiguredAttribute(Manifest.Attribute attribute) throws ManifestException {
        this.checkAttribute(attribute);
        this.nestedManifest.addConfiguredAttribute(attribute);
    }

    private void checkAttribute(Manifest.Attribute attribute) throws BuildException {
        String string = attribute.getName();
        char c = string.charAt(0);
        if (c == '-' || c == '_') {
            throw new BuildException("Manifest attribute names must not start with '" + c + "'.");
        }
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (VALID_ATTRIBUTE_CHARS.indexOf(c) >= 0) continue;
            throw new BuildException("Manifest attribute names must not contain '" + c + "'");
        }
    }

    public void setFile(File file) {
        this.manifestFile = file;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void execute() throws BuildException {
        Closeable closeable;
        Object object;
        if (this.manifestFile == null) {
            throw new BuildException("the file attribute is required");
        }
        Manifest manifest = Manifest.getDefaultManifest();
        Manifest manifest2 = null;
        BuildException buildException = null;
        if (this.manifestFile.exists()) {
            object = null;
            closeable = null;
            try {
                object = new FileInputStream(this.manifestFile);
                closeable = this.encoding == null ? new InputStreamReader((InputStream)object, "UTF-8") : new InputStreamReader((InputStream)object, this.encoding);
                manifest2 = new Manifest((Reader)closeable);
            }
            catch (ManifestException manifestException) {
                buildException = new BuildException("Existing manifest " + this.manifestFile + " is invalid", manifestException, this.getLocation());
                FileUtils.close(closeable);
            }
            catch (IOException iOException) {
                buildException = new BuildException("Failed to read " + this.manifestFile, iOException, this.getLocation());
                {
                    catch (Throwable throwable) {
                        FileUtils.close(closeable);
                        throw throwable;
                    }
                }
                FileUtils.close(closeable);
            }
            FileUtils.close(closeable);
        }
        object = this.nestedManifest.getWarnings();
        while (object.hasMoreElements()) {
            this.log("Manifest warning: " + (String)object.nextElement(), 1);
        }
        try {
            if (this.mode.getValue().equals("update") && this.manifestFile.exists()) {
                if (manifest2 != null) {
                    manifest.merge(manifest2);
                } else if (buildException != null) {
                    throw buildException;
                }
            }
            manifest.merge(this.nestedManifest);
        }
        catch (ManifestException manifestException) {
            throw new BuildException("Manifest is invalid", manifestException, this.getLocation());
        }
        if (manifest.equals(manifest2)) {
            this.log("Manifest has not changed, do not recreate", 3);
            return;
        }
        object = null;
        try {
            closeable = new FileOutputStream(this.manifestFile);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)closeable, "UTF-8");
            object = new PrintWriter(outputStreamWriter);
            manifest.write((PrintWriter)object);
        }
        catch (IOException iOException) {
            throw new BuildException("Failed to write " + this.manifestFile, iOException, this.getLocation());
        }
        finally {
            FileUtils.close((Writer)object);
        }
    }

    public static class Mode
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"update", "replace"};
        }
    }
}

