/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class MakeUrl
extends Task {
    private String property;
    private File file;
    private String separator = " ";
    private List filesets = new LinkedList();
    private List paths = new LinkedList();
    private boolean validate = true;
    public static final String ERROR_MISSING_FILE = "A source file is missing :";
    public static final String ERROR_NO_PROPERTY = "No property defined";
    public static final String ERROR_NO_FILES = "No files defined";

    public void setProperty(String string) {
        this.property = string;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void addFileSet(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }

    public void addPath(Path path) {
        this.paths.add(path);
    }

    private String filesetsToURL() {
        if (this.filesets.isEmpty()) {
            return "";
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        ListIterator listIterator = this.filesets.listIterator();
        while (listIterator.hasNext()) {
            FileSet fileSet = (FileSet)listIterator.next();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(directoryScanner.getBasedir(), stringArray[i]);
                this.validateFile(file);
                String string = this.toURL(file);
                stringBuffer.append(string);
                this.log(string, 4);
                stringBuffer.append(this.separator);
                ++n;
            }
        }
        return this.stripTrailingSeparator(stringBuffer, n);
    }

    private String stripTrailingSeparator(StringBuffer stringBuffer, int n) {
        if (n > 0) {
            stringBuffer.delete(stringBuffer.length() - this.separator.length(), stringBuffer.length());
            return new String(stringBuffer);
        }
        return "";
    }

    private String pathsToURL() {
        if (this.paths.isEmpty()) {
            return "";
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        ListIterator listIterator = this.paths.listIterator();
        while (listIterator.hasNext()) {
            Path path = (Path)listIterator.next();
            String[] stringArray = path.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                this.validateFile(file);
                String string = this.toURL(file);
                stringBuffer.append(string);
                this.log(string, 4);
                stringBuffer.append(this.separator);
                ++n;
            }
        }
        return this.stripTrailingSeparator(stringBuffer, n);
    }

    private void validateFile(File file) {
        if (this.validate && !file.exists()) {
            throw new BuildException(ERROR_MISSING_FILE + file.toString());
        }
    }

    @Override
    public void execute() throws BuildException {
        String string;
        String string2;
        this.validate();
        if (this.getProject().getProperty(this.property) != null) {
            return;
        }
        String string3 = this.filesetsToURL();
        if (this.file != null) {
            this.validateFile(this.file);
            string2 = this.toURL(this.file);
            if (string3.length() > 0) {
                string2 = string2 + this.separator + string3;
            }
        } else {
            string2 = string3;
        }
        if ((string = this.pathsToURL()).length() > 0) {
            string2 = string2.length() > 0 ? string2 + this.separator + string : string;
        }
        this.log("Setting " + this.property + " to URL " + string2, 3);
        this.getProject().setNewProperty(this.property, string2);
    }

    private void validate() {
        if (this.property == null) {
            throw new BuildException(ERROR_NO_PROPERTY);
        }
        if (this.file == null && this.filesets.isEmpty() && this.paths.isEmpty()) {
            throw new BuildException(ERROR_NO_FILES);
        }
    }

    private String toURL(File file) {
        String string = FileUtils.getFileUtils().toURI(file.getAbsolutePath());
        return string;
    }
}

