/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.MacroDef;

public class MacroInstance
extends Task
implements DynamicAttribute,
TaskContainer {
    private MacroDef macroDef;
    private Map map = new HashMap();
    private Map nsElements = null;
    private Map presentElements;
    private Hashtable localAttributes;
    private String text = null;
    private String implicitTag = null;
    private List unknownElements = new ArrayList();
    private static final int STATE_NORMAL = 0;
    private static final int STATE_EXPECT_BRACKET = 1;
    private static final int STATE_EXPECT_NAME = 2;

    public void setMacroDef(MacroDef macroDef) {
        this.macroDef = macroDef;
    }

    public MacroDef getMacroDef() {
        return this.macroDef;
    }

    @Override
    public void setDynamicAttribute(String string, String string2) {
        this.map.put(string, string2);
    }

    public Object createDynamicElement(String string) throws BuildException {
        throw new BuildException("Not implemented any more");
    }

    private Map getNsElements() {
        if (this.nsElements == null) {
            this.nsElements = new HashMap();
            for (Map.Entry entry : this.macroDef.getElements().entrySet()) {
                this.nsElements.put((String)entry.getKey(), entry.getValue());
                MacroDef.TemplateElement templateElement = (MacroDef.TemplateElement)entry.getValue();
                if (!templateElement.isImplicit()) continue;
                this.implicitTag = templateElement.getName();
            }
        }
        return this.nsElements;
    }

    @Override
    public void addTask(Task task) {
        this.unknownElements.add(task);
    }

    private void processTasks() {
        if (this.implicitTag != null) {
            return;
        }
        for (UnknownElement unknownElement : this.unknownElements) {
            String string = ProjectHelper.extractNameFromComponentName(unknownElement.getTag()).toLowerCase(Locale.US);
            if (this.getNsElements().get(string) == null) {
                throw new BuildException("unsupported element " + string);
            }
            if (this.presentElements.get(string) != null) {
                throw new BuildException("Element " + string + " already present");
            }
            this.presentElements.put(string, unknownElement);
        }
    }

    private String macroSubs(String string, Map map) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        int n = 0;
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (n) {
                case 0: {
                    if (c == '@') {
                        n = 1;
                        continue block10;
                    }
                    stringBuffer.append(c);
                    continue block10;
                }
                case 1: {
                    if (c == '{') {
                        n = 2;
                        stringBuffer2 = new StringBuffer();
                        continue block10;
                    }
                    if (c == '@') {
                        n = 0;
                        stringBuffer.append('@');
                        continue block10;
                    }
                    n = 0;
                    stringBuffer.append('@');
                    stringBuffer.append(c);
                    continue block10;
                }
                case 2: {
                    if (c == '}') {
                        n = 0;
                        String string2 = stringBuffer2.toString().toLowerCase(Locale.US);
                        String string3 = (String)map.get(string2);
                        if (string3 == null) {
                            stringBuffer.append("@{");
                            stringBuffer.append(string2);
                            stringBuffer.append("}");
                        } else {
                            stringBuffer.append(string3);
                        }
                        stringBuffer2 = null;
                        continue block10;
                    }
                    stringBuffer2.append(c);
                    continue block10;
                }
            }
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                stringBuffer.append('@');
                break;
            }
            case 2: {
                stringBuffer.append("@{");
                stringBuffer.append(stringBuffer2.toString());
                break;
            }
        }
        return stringBuffer.toString();
    }

    public void addText(String string) {
        this.text = string;
    }

    private UnknownElement copy(UnknownElement unknownElement, boolean bl) {
        Object object;
        UnknownElement unknownElement2 = new UnknownElement(unknownElement.getTag());
        unknownElement2.setNamespace(unknownElement.getNamespace());
        unknownElement2.setProject(this.getProject());
        unknownElement2.setQName(unknownElement.getQName());
        unknownElement2.setTaskType(unknownElement.getTaskType());
        unknownElement2.setTaskName(unknownElement.getTaskName());
        unknownElement2.setLocation(this.macroDef.getBackTrace() ? unknownElement.getLocation() : this.getLocation());
        if (this.getOwningTarget() == null) {
            object = new Target();
            ((Target)object).setProject(this.getProject());
            unknownElement2.setOwningTarget((Target)object);
        } else {
            unknownElement2.setOwningTarget(this.getOwningTarget());
        }
        object = new RuntimeConfigurable(unknownElement2, unknownElement.getTaskName());
        ((RuntimeConfigurable)object).setPolyType(unknownElement.getWrapper().getPolyType());
        Hashtable hashtable = unknownElement.getWrapper().getAttributeMap();
        for (Map.Entry object2 : hashtable.entrySet()) {
            ((RuntimeConfigurable)object).setAttribute((String)object2.getKey(), this.macroSubs((String)object2.getValue(), this.localAttributes));
        }
        ((RuntimeConfigurable)object).addText(this.macroSubs(unknownElement.getWrapper().getText().toString(), this.localAttributes));
        Enumeration enumeration = unknownElement.getWrapper().getChildren();
        while (enumeration.hasMoreElements()) {
            List list;
            Object object2;
            Object object3;
            MacroDef.TemplateElement templateElement;
            RuntimeConfigurable runtimeConfigurable = (RuntimeConfigurable)enumeration.nextElement();
            UnknownElement unknownElement3 = (UnknownElement)runtimeConfigurable.getProxy();
            String string = unknownElement3.getTaskType();
            if (string != null) {
                string = string.toLowerCase(Locale.US);
            }
            if ((templateElement = (MacroDef.TemplateElement)this.getNsElements().get(string)) == null || bl) {
                object3 = this.copy(unknownElement3, bl);
                ((RuntimeConfigurable)object).addChild(((UnknownElement)object3).getWrapper());
                unknownElement2.addChild((UnknownElement)object3);
                continue;
            }
            if (templateElement.isImplicit()) {
                if (this.unknownElements.size() == 0 && !templateElement.isOptional()) {
                    throw new BuildException("Missing nested elements for implicit element " + templateElement.getName());
                }
                object3 = this.unknownElements.iterator();
                while (object3.hasNext()) {
                    object2 = this.copy((UnknownElement)object3.next(), true);
                    ((RuntimeConfigurable)object).addChild(((UnknownElement)object2).getWrapper());
                    unknownElement2.addChild((UnknownElement)object2);
                }
                continue;
            }
            object3 = (UnknownElement)this.presentElements.get(string);
            if (object3 == null) {
                if (templateElement.isOptional()) continue;
                throw new BuildException("Required nested element " + templateElement.getName() + " missing");
            }
            object2 = ((UnknownElement)object3).getWrapper().getText().toString();
            if (!"".equals(object2)) {
                ((RuntimeConfigurable)object).addText(this.macroSubs((String)object2, this.localAttributes));
            }
            if ((list = ((UnknownElement)object3).getChildren()) == null) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                UnknownElement unknownElement4 = this.copy((UnknownElement)iterator.next(), true);
                ((RuntimeConfigurable)object).addChild(unknownElement4.getWrapper());
                unknownElement2.addChild(unknownElement4);
            }
        }
        return unknownElement2;
    }

    @Override
    public void execute() {
        Object object;
        this.presentElements = new HashMap();
        this.getNsElements();
        this.processTasks();
        this.localAttributes = new Hashtable();
        HashSet hashSet = new HashSet(this.map.keySet());
        for (MacroDef.Attribute attribute : this.macroDef.getAttributes()) {
            String string = (String)this.map.get(attribute.getName());
            if (string == null && "description".equals(attribute.getName())) {
                string = this.getDescription();
            }
            if (string == null) {
                string = attribute.getDefault();
                string = this.macroSubs(string, this.localAttributes);
            }
            if (string == null) {
                throw new BuildException("required attribute " + attribute.getName() + " not set");
            }
            this.localAttributes.put(attribute.getName(), string);
            hashSet.remove(attribute.getName());
        }
        if (hashSet.contains("id")) {
            hashSet.remove("id");
        }
        if (this.macroDef.getText() != null) {
            if (this.text == null) {
                object = this.macroDef.getText().getDefault();
                if (!this.macroDef.getText().getOptional() && object == null) {
                    throw new BuildException("required text missing");
                }
                Object object2 = this.text = object == null ? "" : object;
            }
            if (this.macroDef.getText().getTrim()) {
                this.text = this.text.trim();
            }
            this.localAttributes.put(this.macroDef.getText().getName(), this.text);
        } else if (this.text != null && !this.text.trim().equals("")) {
            throw new BuildException("The \"" + this.getTaskName() + "\" macro does not support" + " nested text data.");
        }
        if (hashSet.size() != 0) {
            throw new BuildException("Unknown attribute" + (hashSet.size() > 1 ? "s " : " ") + hashSet);
        }
        object = this.copy(this.macroDef.getNestedTask(), false);
        ((Task)object).init();
        try {
            ((Task)object).perform();
        }
        catch (BuildException buildException) {
            if (this.macroDef.getBackTrace()) {
                throw ProjectHelper.addLocationToBuildException(buildException, this.getLocation());
            }
            buildException.setLocation(this.getLocation());
            throw buildException;
        }
        finally {
            this.presentElements = null;
            this.localAttributes = null;
        }
    }

    public static class Element
    implements TaskContainer {
        private List unknownElements = new ArrayList();

        @Override
        public void addTask(Task task) {
            this.unknownElements.add(task);
        }

        public List getUnknownElements() {
            return this.unknownElements;
        }
    }
}

