/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.util.FileUtils;

public class LoadResource
extends Task {
    private Resource src;
    private boolean failOnError = true;
    private boolean quiet = false;
    private String encoding = null;
    private String property = null;
    private final Vector filterChains = new Vector();

    public final void setEncoding(String string) {
        this.encoding = string;
    }

    public final void setProperty(String string) {
        this.property = string;
    }

    public final void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
        if (bl) {
            this.failOnError = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public final void execute() throws BuildException {
        block18: {
            if (this.src == null) {
                throw new BuildException("source resource not defined");
            }
            if (this.property == null) {
                throw new BuildException("output property not defined");
            }
            if (this.quiet && this.failOnError) {
                throw new BuildException("quiet and failonerror cannot both be set to true");
            }
            if (!this.src.isExists()) {
                String string = this.src + " doesn't exist";
                if (this.failOnError) {
                    throw new BuildException(string);
                }
                this.log(string, this.quiet ? 1 : 0);
                return;
            }
            InputStream inputStream = null;
            BufferedInputStream bufferedInputStream = null;
            Reader reader = null;
            this.log("loading " + this.src + " into property " + this.property, 3);
            try {
                long l = this.src.getSize();
                this.log("resource size = " + (l != -1L ? String.valueOf(l) : "unknown"), 4);
                int n = (int)l;
                inputStream = this.src.getInputStream();
                bufferedInputStream = new BufferedInputStream(inputStream);
                reader = this.encoding == null ? new InputStreamReader(bufferedInputStream) : new InputStreamReader((InputStream)bufferedInputStream, this.encoding);
                String string = "";
                if (n != 0) {
                    ChainReaderHelper chainReaderHelper = new ChainReaderHelper();
                    if (l != -1L) {
                        chainReaderHelper.setBufferSize(n);
                    }
                    chainReaderHelper.setPrimaryReader(reader);
                    chainReaderHelper.setFilterChains(this.filterChains);
                    chainReaderHelper.setProject(this.getProject());
                    reader = chainReaderHelper.getAssembledReader();
                    string = chainReaderHelper.readFully(reader);
                } else {
                    this.log("Do not set property " + this.property + " as its length is 0.");
                }
                if (string != null && string.length() > 0) {
                    this.getProject().setNewProperty(this.property, string);
                    this.log("loaded " + string.length() + " characters", 3);
                    this.log(this.property + " := " + string, 4);
                }
                FileUtils.close(inputStream);
            }
            catch (IOException iOException) {
                String string = "Unable to load resource: " + iOException.toString();
                if (this.failOnError) {
                    throw new BuildException(string, iOException, this.getLocation());
                }
                this.log(string, this.quiet ? 3 : 0);
            }
            catch (BuildException buildException) {
                if (this.failOnError) {
                    throw buildException;
                }
                this.log(buildException.getMessage(), this.quiet ? 3 : 0);
                break block18;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                FileUtils.close(inputStream);
            }
        }
    }

    public final void addFilterChain(FilterChain filterChain) {
        this.filterChains.addElement(filterChain);
    }

    public void addConfigured(ResourceCollection resourceCollection) {
        if (resourceCollection.size() != 1) {
            throw new BuildException("only single argument resource collections are supported");
        }
        this.src = (Resource)resourceCollection.iterator().next();
    }
}

