/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.Comparison;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.PropertyOutputStream;

public class Length
extends Task
implements Condition {
    private static final String ALL = "all";
    private static final String EACH = "each";
    private static final String STRING = "string";
    private static final String LENGTH_REQUIRED = "Use of the Length condition requires that the length attribute be set.";
    private String property;
    private String string;
    private Boolean trim;
    private String mode = "all";
    private Comparison when = Comparison.EQUAL;
    private Long length;
    private Resources resources;

    public synchronized void setProperty(String string) {
        this.property = string;
    }

    public synchronized void setFile(File file) {
        this.add(new FileResource(file));
    }

    public synchronized void add(FileSet fileSet) {
        this.add((ResourceCollection)fileSet);
    }

    public synchronized void add(ResourceCollection resourceCollection) {
        if (resourceCollection == null) {
            return;
        }
        this.resources = this.resources == null ? new Resources() : this.resources;
        this.resources.add(resourceCollection);
    }

    public synchronized void setLength(long l) {
        this.length = new Long(l);
    }

    public synchronized void setWhen(When when) {
        this.setWhen((Comparison)when);
    }

    public synchronized void setWhen(Comparison comparison) {
        this.when = comparison;
    }

    public synchronized void setMode(FileMode fileMode) {
        this.mode = fileMode.getValue();
    }

    public synchronized void setString(String string) {
        this.string = string;
        this.mode = STRING;
    }

    public synchronized void setTrim(boolean bl) {
        this.trim = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean getTrim() {
        return this.trim != null && this.trim != false;
    }

    @Override
    public void execute() {
        this.validate();
        PrintStream printStream = new PrintStream(this.property != null ? new PropertyOutputStream(this.getProject(), this.property) : new LogOutputStream(this, 2));
        if (STRING.equals(this.mode)) {
            printStream.print(Length.getLength(this.string, this.getTrim()));
            printStream.close();
        } else if (EACH.equals(this.mode)) {
            this.handleResources(new EachHandler(printStream));
        } else if (ALL.equals(this.mode)) {
            this.handleResources(new AllHandler(printStream));
        }
    }

    @Override
    public boolean eval() {
        Long l;
        this.validate();
        if (this.length == null) {
            throw new BuildException(LENGTH_REQUIRED);
        }
        if (STRING.equals(this.mode)) {
            l = new Long(Length.getLength(this.string, this.getTrim()));
        } else {
            AccumHandler accumHandler = new AccumHandler();
            this.handleResources(accumHandler);
            l = new Long(accumHandler.getAccum());
        }
        return this.when.evaluate(l.compareTo(this.length));
    }

    private void validate() {
        if (this.string != null) {
            if (this.resources != null) {
                throw new BuildException("the string length function is incompatible with the file/resource length function");
            }
            if (!STRING.equals(this.mode)) {
                throw new BuildException("the mode attribute is for use with the file/resource length function");
            }
        } else if (this.resources != null) {
            if (!EACH.equals(this.mode) && !ALL.equals(this.mode)) {
                throw new BuildException("invalid mode setting for file/resource length function: \"" + this.mode + "\"");
            }
            if (this.trim != null) {
                throw new BuildException("the trim attribute is for use with the string length function only");
            }
        } else {
            throw new BuildException("you must set either the string attribute or specify one or more files using the file attribute or nested resource collections");
        }
    }

    private void handleResources(Handler handler) {
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!resource.isExists()) {
                this.log(resource + " does not exist", 0);
                continue;
            }
            if (resource.isDirectory()) {
                this.log(resource + " is a directory; length unspecified", 0);
                continue;
            }
            handler.handle(resource);
        }
        handler.complete();
    }

    private static long getLength(String string, boolean bl) {
        return (bl ? string.trim() : string).length();
    }

    private class AllHandler
    extends AccumHandler {
        AllHandler(PrintStream printStream) {
            super(printStream);
        }

        @Override
        void complete() {
            this.getPs().print(this.getAccum());
            super.complete();
        }
    }

    private class AccumHandler
    extends Handler {
        private long accum;

        AccumHandler() {
            super(null);
            this.accum = 0L;
        }

        protected AccumHandler(PrintStream printStream) {
            super(printStream);
            this.accum = 0L;
        }

        protected long getAccum() {
            return this.accum;
        }

        @Override
        protected synchronized void handle(Resource resource) {
            long l = resource.getSize();
            if (l == -1L) {
                Length.this.log("Size unknown for " + resource.toString(), 1);
            } else {
                this.accum += l;
            }
        }
    }

    private class EachHandler
    extends Handler {
        EachHandler(PrintStream printStream) {
            super(printStream);
        }

        @Override
        protected void handle(Resource resource) {
            this.getPs().print(resource.toString());
            this.getPs().print(" : ");
            long l = resource.getSize();
            if (l == -1L) {
                this.getPs().println("unknown");
            } else {
                this.getPs().println(l);
            }
        }
    }

    private abstract class Handler {
        private PrintStream ps;

        Handler(PrintStream printStream) {
            this.ps = printStream;
        }

        protected PrintStream getPs() {
            return this.ps;
        }

        protected abstract void handle(Resource var1);

        void complete() {
            FileUtils.close(this.ps);
        }
    }

    public static class When
    extends Comparison {
    }

    public static class FileMode
    extends EnumeratedAttribute {
        static final String[] MODES = new String[]{"each", "all"};

        @Override
        public String[] getValues() {
            return MODES;
        }
    }
}

