/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Javadoc
extends Task {
    private static final boolean JAVADOC_4 = !JavaEnvUtils.isJavaVersion("1.2") && !JavaEnvUtils.isJavaVersion("1.3");
    private static final boolean JAVADOC_5 = JAVADOC_4 && !JavaEnvUtils.isJavaVersion("1.4");
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private Commandline cmd = new Commandline();
    private boolean failOnError = false;
    private Path sourcePath = null;
    private File destDir = null;
    private Vector sourceFiles = new Vector();
    private Vector packageNames = new Vector();
    private Vector excludePackageNames = new Vector(1);
    private boolean author = true;
    private boolean version = true;
    private DocletInfo doclet = null;
    private Path classpath = null;
    private Path bootclasspath = null;
    private String group = null;
    private String packageList = null;
    private Vector links = new Vector();
    private Vector groups = new Vector();
    private Vector tags = new Vector();
    private boolean useDefaultExcludes = true;
    private Html doctitle = null;
    private Html header = null;
    private Html footer = null;
    private Html bottom = null;
    private boolean useExternalFile = false;
    private String source = null;
    private boolean linksource = false;
    private boolean breakiterator = false;
    private String noqualifier;
    private boolean includeNoSourcePackages = false;
    private boolean old = false;
    private String executable = null;
    private ResourceCollectionContainer nestedSourceFiles = new ResourceCollectionContainer();
    private Vector packageSets = new Vector();
    static final String[] SCOPE_ELEMENTS = new String[]{"overview", "packages", "types", "constructors", "methods", "fields"};

    private void addArgIf(boolean bl, String string) {
        if (bl) {
            this.cmd.createArgument().setValue(string);
        }
    }

    private void addArgIfNotEmpty(String string, String string2) {
        if (string2 != null && string2.length() != 0) {
            this.cmd.createArgument().setValue(string);
            this.cmd.createArgument().setValue(string2);
        } else {
            this.log("Warning: Leaving out empty argument '" + string + "'", 1);
        }
    }

    public void setUseExternalFile(boolean bl) {
        this.useExternalFile = bl;
    }

    public void setDefaultexcludes(boolean bl) {
        this.useDefaultExcludes = bl;
    }

    public void setMaxmemory(String string) {
        this.cmd.createArgument().setValue("-J-Xmx" + string);
    }

    public void setAdditionalparam(String string) {
        this.cmd.createArgument().setLine(string);
    }

    public Commandline.Argument createArg() {
        return this.cmd.createArgument();
    }

    public void setSourcepath(Path path) {
        if (this.sourcePath == null) {
            this.sourcePath = path;
        } else {
            this.sourcePath.append(path);
        }
    }

    public Path createSourcepath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(this.getProject());
        }
        return this.sourcePath.createPath();
    }

    public void setSourcepathRef(Reference reference) {
        this.createSourcepath().setRefid(reference);
    }

    public void setDestdir(File file) {
        this.destDir = file;
        this.cmd.createArgument().setValue("-d");
        this.cmd.createArgument().setFile(this.destDir);
    }

    public void setSourcefiles(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            SourceFile sourceFile = new SourceFile();
            sourceFile.setFile(this.getProject().resolveFile(string2.trim()));
            this.addSource(sourceFile);
        }
    }

    public void addSource(SourceFile sourceFile) {
        this.sourceFiles.addElement(sourceFile);
    }

    public void setPackagenames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            PackageName packageName = new PackageName();
            packageName.setName(string2);
            this.addPackage(packageName);
        }
    }

    public void addPackage(PackageName packageName) {
        this.packageNames.addElement(packageName);
    }

    public void setExcludePackageNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            PackageName packageName = new PackageName();
            packageName.setName(string2);
            this.addExcludePackage(packageName);
        }
    }

    public void addExcludePackage(PackageName packageName) {
        this.excludePackageNames.addElement(packageName);
    }

    public void setOverview(File file) {
        this.cmd.createArgument().setValue("-overview");
        this.cmd.createArgument().setFile(file);
    }

    public void setPublic(boolean bl) {
        this.addArgIf(bl, "-public");
    }

    public void setProtected(boolean bl) {
        this.addArgIf(bl, "-protected");
    }

    public void setPackage(boolean bl) {
        this.addArgIf(bl, "-package");
    }

    public void setPrivate(boolean bl) {
        this.addArgIf(bl, "-private");
    }

    public void setAccess(AccessType accessType) {
        this.cmd.createArgument().setValue("-" + accessType.getValue());
    }

    public void setDoclet(String string) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
            this.doclet.setProject(this.getProject());
        }
        this.doclet.setName(string);
    }

    public void setDocletPath(Path path) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
            this.doclet.setProject(this.getProject());
        }
        this.doclet.setPath(path);
    }

    public void setDocletPathRef(Reference reference) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
            this.doclet.setProject(this.getProject());
        }
        this.doclet.createPath().setRefid(reference);
    }

    public DocletInfo createDoclet() {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
        }
        return this.doclet;
    }

    public void addTaglet(ExtensionInfo extensionInfo) {
        this.tags.addElement(extensionInfo);
    }

    public void setOld(boolean bl) {
        this.old = bl;
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setBootclasspath(Path path) {
        if (this.bootclasspath == null) {
            this.bootclasspath = path;
        } else {
            this.bootclasspath.append(path);
        }
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.getProject());
        }
        return this.bootclasspath.createPath();
    }

    public void setBootClasspathRef(Reference reference) {
        this.createBootclasspath().setRefid(reference);
    }

    public void setExtdirs(String string) {
        this.cmd.createArgument().setValue("-extdirs");
        this.cmd.createArgument().setValue(string);
    }

    public void setExtdirs(Path path) {
        this.cmd.createArgument().setValue("-extdirs");
        this.cmd.createArgument().setPath(path);
    }

    public void setVerbose(boolean bl) {
        this.addArgIf(bl, "-verbose");
    }

    public void setLocale(String string) {
        this.cmd.createArgument(true).setValue(string);
        this.cmd.createArgument(true).setValue("-locale");
    }

    public void setEncoding(String string) {
        this.cmd.createArgument().setValue("-encoding");
        this.cmd.createArgument().setValue(string);
    }

    public void setVersion(boolean bl) {
        this.version = bl;
    }

    public void setUse(boolean bl) {
        this.addArgIf(bl, "-use");
    }

    public void setAuthor(boolean bl) {
        this.author = bl;
    }

    public void setSplitindex(boolean bl) {
        this.addArgIf(bl, "-splitindex");
    }

    public void setWindowtitle(String string) {
        this.addArgIfNotEmpty("-windowtitle", string);
    }

    public void setDoctitle(String string) {
        Html html = new Html();
        html.addText(string);
        this.addDoctitle(html);
    }

    public void addDoctitle(Html html) {
        this.doctitle = html;
    }

    public void setHeader(String string) {
        Html html = new Html();
        html.addText(string);
        this.addHeader(html);
    }

    public void addHeader(Html html) {
        this.header = html;
    }

    public void setFooter(String string) {
        Html html = new Html();
        html.addText(string);
        this.addFooter(html);
    }

    public void addFooter(Html html) {
        this.footer = html;
    }

    public void setBottom(String string) {
        Html html = new Html();
        html.addText(string);
        this.addBottom(html);
    }

    public void addBottom(Html html) {
        this.bottom = html;
    }

    public void setLinkoffline(String string) {
        LinkArgument linkArgument = this.createLink();
        linkArgument.setOffline(true);
        String string2 = "The linkoffline attribute must include a URL and a package-list file location separated by a space";
        if (string.trim().length() == 0) {
            throw new BuildException(string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        linkArgument.setHref(stringTokenizer.nextToken());
        if (!stringTokenizer.hasMoreTokens()) {
            throw new BuildException(string2);
        }
        linkArgument.setPackagelistLoc(this.getProject().resolveFile(stringTokenizer.nextToken()));
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public void setLink(String string) {
        this.createLink().setHref(string);
    }

    public void setNodeprecated(boolean bl) {
        this.addArgIf(bl, "-nodeprecated");
    }

    public void setNodeprecatedlist(boolean bl) {
        this.addArgIf(bl, "-nodeprecatedlist");
    }

    public void setNotree(boolean bl) {
        this.addArgIf(bl, "-notree");
    }

    public void setNoindex(boolean bl) {
        this.addArgIf(bl, "-noindex");
    }

    public void setNohelp(boolean bl) {
        this.addArgIf(bl, "-nohelp");
    }

    public void setNonavbar(boolean bl) {
        this.addArgIf(bl, "-nonavbar");
    }

    public void setSerialwarn(boolean bl) {
        this.addArgIf(bl, "-serialwarn");
    }

    public void setStylesheetfile(File file) {
        this.cmd.createArgument().setValue("-stylesheetfile");
        this.cmd.createArgument().setFile(file);
    }

    public void setHelpfile(File file) {
        this.cmd.createArgument().setValue("-helpfile");
        this.cmd.createArgument().setFile(file);
    }

    public void setDocencoding(String string) {
        this.cmd.createArgument().setValue("-docencoding");
        this.cmd.createArgument().setValue(string);
    }

    public void setPackageList(String string) {
        this.packageList = string;
    }

    public LinkArgument createLink() {
        LinkArgument linkArgument = new LinkArgument();
        this.links.addElement(linkArgument);
        return linkArgument;
    }

    public TagArgument createTag() {
        TagArgument tagArgument = new TagArgument();
        this.tags.addElement(tagArgument);
        return tagArgument;
    }

    public GroupArgument createGroup() {
        GroupArgument groupArgument = new GroupArgument();
        this.groups.addElement(groupArgument);
        return groupArgument;
    }

    public void setCharset(String string) {
        this.addArgIfNotEmpty("-charset", string);
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public void setExecutable(String string) {
        this.executable = string;
    }

    public void addPackageset(DirSet dirSet) {
        this.packageSets.addElement(dirSet);
    }

    public void addFileset(FileSet fileSet) {
        this.createSourceFiles().add(fileSet);
    }

    public ResourceCollectionContainer createSourceFiles() {
        return this.nestedSourceFiles;
    }

    public void setLinksource(boolean bl) {
        this.linksource = bl;
    }

    public void setBreakiterator(boolean bl) {
        this.breakiterator = bl;
    }

    public void setNoqualifier(String string) {
        this.noqualifier = string;
    }

    public void setIncludeNoSourcePackages(boolean bl) {
        this.includeNoSourcePackages = bl;
    }

    @Override
    public void execute() throws BuildException {
        this.checkTaskName();
        Vector vector = new Vector();
        Path path = new Path(this.getProject());
        this.checkPackageAndSourcePath();
        if (this.sourcePath != null) {
            path.addExisting(this.sourcePath);
        }
        this.parsePackages(vector, path);
        this.checkPackages(vector, path);
        Vector vector2 = (Vector)this.sourceFiles.clone();
        this.addSourceFiles(vector2);
        this.checkPackagesToDoc(vector, vector2);
        this.log("Generating Javadoc", 2);
        Commandline commandline = (Commandline)this.cmd.clone();
        if (this.executable != null) {
            commandline.setExecutable(this.executable);
        } else {
            commandline.setExecutable(JavaEnvUtils.getJdkExecutable("javadoc"));
        }
        this.generalJavadocArguments(commandline);
        this.doSourcePath(commandline, path);
        this.doDoclet(commandline);
        this.doBootPath(commandline);
        this.doLinks(commandline);
        this.doGroup(commandline);
        this.doGroups(commandline);
        if (JAVADOC_4 || this.executable != null) {
            this.doJava14(commandline);
            if (this.breakiterator && (this.doclet == null || JAVADOC_5)) {
                commandline.createArgument().setValue("-breakiterator");
            }
        } else {
            this.doNotJava14();
        }
        if (!JAVADOC_4 || this.executable != null) {
            if (this.old) {
                commandline.createArgument().setValue("-1.1");
            }
        } else if (this.old) {
            this.log("Javadoc 1.4 doesn't support the -1.1 switch anymore", 1);
        }
        if (this.useExternalFile && JAVADOC_4) {
            this.writeExternalArgs(commandline);
        }
        File file = null;
        PrintWriter printWriter = null;
        try {
            if (this.useExternalFile) {
                file = FILE_UTILS.createTempFile("javadoc", "", null, true, true);
                commandline.createArgument().setValue("@" + file.getAbsolutePath());
                printWriter = new PrintWriter(new FileWriter(file.getAbsolutePath(), true));
            }
            this.doSourceAndPackageNames(commandline, vector, vector2, this.useExternalFile, file, printWriter);
        }
        catch (IOException iOException) {
            file.delete();
            throw new BuildException("Error creating temporary file", iOException, this.getLocation());
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        if (this.packageList != null) {
            commandline.createArgument().setValue("@" + this.packageList);
        }
        this.log(commandline.describeCommand(), 3);
        this.log("Javadoc execution", 2);
        JavadocOutputStream javadocOutputStream = new JavadocOutputStream(2);
        JavadocOutputStream javadocOutputStream2 = new JavadocOutputStream(1);
        Execute execute = new Execute(new PumpStreamHandler(javadocOutputStream, javadocOutputStream2));
        execute.setAntRun(this.getProject());
        execute.setWorkingDirectory(null);
        try {
            execute.setCommandline(commandline.getCommandline());
            int n = execute.execute();
            if (n != 0 && this.failOnError) {
                throw new BuildException("Javadoc returned " + n, this.getLocation());
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Javadoc failed: " + iOException, iOException, this.getLocation());
        }
        finally {
            if (file != null) {
                file.delete();
                file = null;
            }
            javadocOutputStream.logFlush();
            javadocOutputStream2.logFlush();
            try {
                javadocOutputStream.close();
                javadocOutputStream2.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void checkTaskName() {
        if ("javadoc2".equals(this.getTaskType())) {
            this.log("Warning: the task name <javadoc2> is deprecated. Use <javadoc> instead.", 1);
        }
    }

    private void checkPackageAndSourcePath() {
        if (this.packageList != null && this.sourcePath == null) {
            String string = "sourcePath attribute must be set when specifying packagelist.";
            throw new BuildException(string);
        }
    }

    private void checkPackages(Vector vector, Path path) {
        if (vector.size() != 0 && path.size() == 0) {
            String string = "sourcePath attribute must be set when specifying package names.";
            throw new BuildException(string);
        }
    }

    private void checkPackagesToDoc(Vector vector, Vector vector2) {
        if (this.packageList == null && vector.size() == 0 && vector2.size() == 0) {
            throw new BuildException("No source files and no packages have been specified.");
        }
    }

    private void doSourcePath(Commandline commandline, Path path) {
        if (path.size() > 0) {
            commandline.createArgument().setValue("-sourcepath");
            commandline.createArgument().setPath(path);
        }
    }

    private void generalJavadocArguments(Commandline commandline) {
        if (this.doctitle != null) {
            commandline.createArgument().setValue("-doctitle");
            commandline.createArgument().setValue(this.expand(this.doctitle.getText()));
        }
        if (this.header != null) {
            commandline.createArgument().setValue("-header");
            commandline.createArgument().setValue(this.expand(this.header.getText()));
        }
        if (this.footer != null) {
            commandline.createArgument().setValue("-footer");
            commandline.createArgument().setValue(this.expand(this.footer.getText()));
        }
        if (this.bottom != null) {
            commandline.createArgument().setValue("-bottom");
            commandline.createArgument().setValue(this.expand(this.bottom.getText()));
        }
        this.classpath = this.classpath == null ? new Path(this.getProject()).concatSystemClasspath("last") : this.classpath.concatSystemClasspath("ignore");
        if (this.classpath.size() > 0) {
            commandline.createArgument().setValue("-classpath");
            commandline.createArgument().setPath(this.classpath);
        }
        if (this.version && this.doclet == null) {
            commandline.createArgument().setValue("-version");
        }
        if (this.author && this.doclet == null) {
            commandline.createArgument().setValue("-author");
        }
        if (this.doclet == null && this.destDir == null) {
            throw new BuildException("destdir attribute must be set!");
        }
    }

    private void doDoclet(Commandline commandline) {
        if (this.doclet != null) {
            Object object;
            if (this.doclet.getName() == null) {
                throw new BuildException("The doclet name must be specified.", this.getLocation());
            }
            commandline.createArgument().setValue("-doclet");
            commandline.createArgument().setValue(this.doclet.getName());
            if (this.doclet.getPath() != null && ((Path)(object = this.doclet.getPath().concatSystemClasspath("ignore"))).size() != 0) {
                commandline.createArgument().setValue("-docletpath");
                commandline.createArgument().setPath((Path)object);
            }
            object = this.doclet.getParams();
            while (object.hasMoreElements()) {
                DocletParam docletParam = (DocletParam)object.nextElement();
                if (docletParam.getName() == null) {
                    throw new BuildException("Doclet parameters must have a name");
                }
                commandline.createArgument().setValue(docletParam.getName());
                if (docletParam.getValue() == null) continue;
                commandline.createArgument().setValue(docletParam.getValue());
            }
        }
    }

    private void writeExternalArgs(Commandline commandline) {
        File file = null;
        PrintWriter printWriter = null;
        try {
            file = FILE_UTILS.createTempFile("javadocOptions", "", null, true, true);
            String[] stringArray = commandline.getArguments();
            commandline.clearArgs();
            commandline.createArgument().setValue("@" + file.getAbsolutePath());
            printWriter = new PrintWriter(new FileWriter(file.getAbsolutePath(), true));
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.startsWith("-J-")) {
                    commandline.createArgument().setValue(string);
                    continue;
                }
                if (string.startsWith("-")) {
                    printWriter.print(string);
                    printWriter.print(" ");
                    continue;
                }
                printWriter.println(this.quoteString(string));
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            try {
                if (file != null) {
                    file.delete();
                }
                throw new BuildException("Error creating or writing temporary file for javadoc options", iOException, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(printWriter);
                throw throwable;
            }
        }
        FileUtils.close(printWriter);
    }

    private void doBootPath(Commandline commandline) {
        Path path = new Path(this.getProject());
        if (this.bootclasspath != null) {
            path.append(this.bootclasspath);
        }
        if ((path = path.concatSystemBootClasspath("ignore")).size() > 0) {
            commandline.createArgument().setValue("-bootclasspath");
            commandline.createArgument().setPath(path);
        }
    }

    private void doLinks(Commandline commandline) {
        if (this.links.size() != 0) {
            Enumeration enumeration = this.links.elements();
            while (enumeration.hasMoreElements()) {
                Serializable serializable;
                LinkArgument linkArgument = (LinkArgument)enumeration.nextElement();
                if (linkArgument.getHref() == null || linkArgument.getHref().length() == 0) {
                    this.log("No href was given for the link - skipping", 3);
                    continue;
                }
                String string = null;
                if (linkArgument.shouldResolveLink() && (serializable = this.getProject().resolveFile(linkArgument.getHref())).exists()) {
                    try {
                        string = FILE_UTILS.getFileURL((File)serializable).toExternalForm();
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.log("Warning: link location was invalid " + serializable, 1);
                    }
                }
                if (string == null) {
                    try {
                        serializable = new URL("file://.");
                        new URL((URL)serializable, linkArgument.getHref());
                        string = linkArgument.getHref();
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.log("Link href \"" + linkArgument.getHref() + "\" is not a valid url - skipping link", 1);
                        continue;
                    }
                }
                if (linkArgument.isLinkOffline()) {
                    serializable = linkArgument.getPackagelistLoc();
                    if (serializable == null) {
                        throw new BuildException("The package list location for link " + linkArgument.getHref() + " must be provided " + "because the link is " + "offline");
                    }
                    File file = new File((File)serializable, "package-list");
                    if (file.exists()) {
                        try {
                            String string2 = FILE_UTILS.getFileURL((File)serializable).toExternalForm();
                            commandline.createArgument().setValue("-linkoffline");
                            commandline.createArgument().setValue(string);
                            commandline.createArgument().setValue(string2);
                        }
                        catch (MalformedURLException malformedURLException) {
                            this.log("Warning: Package list location was invalid " + serializable, 1);
                        }
                        continue;
                    }
                    this.log("Warning: No package list was found at " + serializable, 3);
                    continue;
                }
                commandline.createArgument().setValue("-link");
                commandline.createArgument().setValue(string);
            }
        }
    }

    private void doGroup(Commandline commandline) {
        if (this.group != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.group, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                int n = string.indexOf(" ");
                if (n <= 0) continue;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                commandline.createArgument().setValue("-group");
                commandline.createArgument().setValue(string2);
                commandline.createArgument().setValue(string3);
            }
        }
    }

    private void doGroups(Commandline commandline) {
        if (this.groups.size() != 0) {
            Enumeration enumeration = this.groups.elements();
            while (enumeration.hasMoreElements()) {
                GroupArgument groupArgument = (GroupArgument)enumeration.nextElement();
                String string = groupArgument.getTitle();
                String string2 = groupArgument.getPackages();
                if (string == null || string2 == null) {
                    throw new BuildException("The title and packages must be specified for group elements.");
                }
                commandline.createArgument().setValue("-group");
                commandline.createArgument().setValue(this.expand(string));
                commandline.createArgument().setValue(string2);
            }
        }
    }

    private void doJava14(Commandline commandline) {
        Object object = this.tags.elements();
        while (object.hasMoreElements()) {
            Object object2;
            ProjectComponent projectComponent;
            Object e = object.nextElement();
            if (e instanceof TagArgument) {
                projectComponent = (TagArgument)e;
                object2 = ((AbstractFileSet)projectComponent).getDir(this.getProject());
                if (object2 == null) {
                    commandline.createArgument().setValue("-tag");
                    commandline.createArgument().setValue(((TagArgument)projectComponent).getParameter());
                    continue;
                }
                DirectoryScanner directoryScanner = ((AbstractFileSet)projectComponent).getDirectoryScanner(this.getProject());
                String[] stringArray = directoryScanner.getIncludedFiles();
                for (int i = 0; i < stringArray.length; ++i) {
                    File file = new File((File)object2, stringArray[i]);
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                        String string = null;
                        while ((string = bufferedReader.readLine()) != null) {
                            commandline.createArgument().setValue("-tag");
                            commandline.createArgument().setValue(string);
                        }
                        bufferedReader.close();
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new BuildException("Couldn't read  tag file from " + file.getAbsolutePath(), iOException);
                    }
                }
                continue;
            }
            projectComponent = (ExtensionInfo)e;
            commandline.createArgument().setValue("-taglet");
            commandline.createArgument().setValue(((ExtensionInfo)projectComponent).getName());
            if (((ExtensionInfo)projectComponent).getPath() == null || ((Path)(object2 = ((ExtensionInfo)projectComponent).getPath().concatSystemClasspath("ignore"))).size() == 0) continue;
            commandline.createArgument().setValue("-tagletpath");
            commandline.createArgument().setPath((Path)object2);
        }
        Object object3 = object = this.source != null ? this.source : this.getProject().getProperty("ant.build.javac.source");
        if (object != null) {
            commandline.createArgument().setValue("-source");
            commandline.createArgument().setValue((String)object);
        }
        if (this.linksource && this.doclet == null) {
            commandline.createArgument().setValue("-linksource");
        }
        if (this.noqualifier != null && this.doclet == null) {
            commandline.createArgument().setValue("-noqualifier");
            commandline.createArgument().setValue(this.noqualifier);
        }
    }

    private void doNotJava14() {
        if (!this.tags.isEmpty()) {
            this.log("-tag and -taglet options not supported on Javadoc < 1.4", 3);
        }
        if (this.source != null) {
            this.log("-source option not supported on Javadoc < 1.4", 3);
        }
        if (this.linksource) {
            this.log("-linksource option not supported on Javadoc < 1.4", 3);
        }
        if (this.breakiterator) {
            this.log("-breakiterator option not supported on Javadoc < 1.4", 3);
        }
        if (this.noqualifier != null) {
            this.log("-noqualifier option not supported on Javadoc < 1.4", 3);
        }
    }

    private void doSourceAndPackageNames(Commandline commandline, Vector vector, Vector vector2, boolean bl, File file, PrintWriter printWriter) throws IOException {
        Object object;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (bl) {
                printWriter.println((String)object);
                continue;
            }
            commandline.createArgument().setValue((String)object);
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (SourceFile)enumeration.nextElement();
            String string = ((SourceFile)object).getFile().getAbsolutePath();
            if (bl) {
                if (JAVADOC_4 && string.indexOf(" ") > -1) {
                    String string2 = string;
                    if (File.separatorChar == '\\') {
                        string2 = string.replace(File.separatorChar, '/');
                    }
                    printWriter.println("\"" + string2 + "\"");
                    continue;
                }
                printWriter.println(string);
                continue;
            }
            commandline.createArgument().setValue(string);
        }
    }

    private String quoteString(String string) {
        if (string.indexOf(32) == -1 && string.indexOf(39) == -1 && string.indexOf(34) == -1) {
            return string;
        }
        if (string.indexOf(39) == -1) {
            return this.quoteString(string, '\'');
        }
        return this.quoteString(string, '\"');
    }

    private String quoteString(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        stringBuffer.append(c);
        if (string.indexOf(92) != -1) {
            string = this.replace(string, '\\', "\\\\");
        }
        if (string.indexOf(c) != -1) {
            string = this.replace(string, c, "\\" + c);
        }
        stringBuffer.append(string);
        stringBuffer.append(c);
        return stringBuffer.toString();
    }

    private String replace(String string, char c, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private void addSourceFiles(Vector vector) {
        Iterator iterator = this.nestedSourceFiles.iterator();
        while (iterator.hasNext()) {
            Object object;
            ResourceCollection resourceCollection = (ResourceCollection)iterator.next();
            if (!resourceCollection.isFilesystemOnly()) {
                throw new BuildException("only file system based resources are supported by javadoc");
            }
            if (resourceCollection instanceof FileSet && !((AbstractFileSet)(object = (FileSet)resourceCollection)).hasPatterns() && !((AbstractFileSet)object).hasSelectors()) {
                FileSet fileSet = (FileSet)((FileSet)object).clone();
                fileSet.createInclude().setName("**/*.java");
                if (this.includeNoSourcePackages) {
                    fileSet.createInclude().setName("**/package.html");
                }
                resourceCollection = fileSet;
            }
            object = resourceCollection.iterator();
            while (object.hasNext()) {
                vector.addElement(new SourceFile(((FileResource)object.next()).getFile()));
            }
        }
    }

    private void parsePackages(Vector vector, Path path) {
        String[] stringArray;
        Object object;
        Enumeration enumeration;
        Object object2;
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = (Vector)this.packageSets.clone();
        if (this.sourcePath != null) {
            String string;
            object2 = new PatternSet();
            if (this.packageNames.size() > 0) {
                enumeration = this.packageNames.elements();
                while (enumeration.hasMoreElements()) {
                    object = (PackageName)enumeration.nextElement();
                    string = object.getName().replace('.', '/');
                    if (string.endsWith("*")) {
                        string = string + "*";
                    }
                    ((PatternSet)object2).createInclude().setName(string);
                }
            } else {
                ((PatternSet)object2).createInclude().setName("**");
            }
            enumeration = this.excludePackageNames.elements();
            while (enumeration.hasMoreElements()) {
                object = (PackageName)enumeration.nextElement();
                string = object.getName().replace('.', '/');
                if (string.endsWith("*")) {
                    string = string + "*";
                }
                ((PatternSet)object2).createExclude().setName(string);
            }
            object = this.sourcePath.list();
            for (int i = 0; i < ((String[])object).length; ++i) {
                stringArray = new File(object[i]);
                if (stringArray.isDirectory()) {
                    DirSet dirSet = new DirSet();
                    dirSet.setDefaultexcludes(this.useDefaultExcludes);
                    dirSet.setDir((File)stringArray);
                    dirSet.createPatternSet().addConfiguredPatternset((PatternSet)object2);
                    vector3.addElement(dirSet);
                    continue;
                }
                this.log("Skipping " + object[i] + " since it is no directory.", 1);
            }
        }
        object2 = vector3.elements();
        while (object2.hasMoreElements()) {
            enumeration = (DirSet)object2.nextElement();
            object = ((AbstractFileSet)((Object)enumeration)).getDir(this.getProject());
            this.log("scanning " + object + " for packages.", 4);
            DirectoryScanner directoryScanner = ((AbstractFileSet)((Object)enumeration)).getDirectoryScanner(this.getProject());
            stringArray = directoryScanner.getIncludedDirectories();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File((File)object, stringArray[i]);
                String[] stringArray2 = file.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.endsWith(".java") || Javadoc.this.includeNoSourcePackages && string.equals("package.html");
                    }
                });
                if (stringArray2.length <= 0) continue;
                if ("".equals(stringArray[i])) {
                    this.log(object + " contains source files in the default package," + " you must specify them as source files" + " not packages.", 1);
                    continue;
                }
                bl = true;
                String string = stringArray[i].replace(File.separatorChar, '.');
                if (vector2.contains(string)) continue;
                vector2.addElement(string);
                vector.addElement(string);
            }
            if (bl) {
                path.createPathElement().setLocation((File)object);
                continue;
            }
            this.log(object + " doesn't contain any packages, dropping it.", 3);
        }
    }

    protected String expand(String string) {
        return this.getProject().replaceProperties(string);
    }

    private class JavadocOutputStream
    extends LogOutputStream {
        private String queuedLine;

        JavadocOutputStream(int n) {
            super(Javadoc.this, n);
            this.queuedLine = null;
        }

        @Override
        protected void processLine(String string, int n) {
            if (n == 2 && string.startsWith("Generating ")) {
                if (this.queuedLine != null) {
                    super.processLine(this.queuedLine, 3);
                }
                this.queuedLine = string;
            } else {
                if (this.queuedLine != null) {
                    if (string.startsWith("Building ")) {
                        super.processLine(this.queuedLine, 3);
                    } else {
                        super.processLine(this.queuedLine, 2);
                    }
                    this.queuedLine = null;
                }
                super.processLine(string, n);
            }
        }

        protected void logFlush() {
            if (this.queuedLine != null) {
                super.processLine(this.queuedLine, 3);
                this.queuedLine = null;
            }
        }
    }

    public class GroupArgument {
        private Html title;
        private Vector packages = new Vector();

        public void setTitle(String string) {
            Html html = new Html();
            html.addText(string);
            this.addTitle(html);
        }

        public void addTitle(Html html) {
            this.title = html;
        }

        public String getTitle() {
            return this.title != null ? this.title.getText() : null;
        }

        public void setPackages(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                PackageName packageName = new PackageName();
                packageName.setName(string2);
                this.addPackage(packageName);
            }
        }

        public void addPackage(PackageName packageName) {
            this.packages.addElement(packageName);
        }

        public String getPackages() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.packages.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(":");
                }
                stringBuffer.append(this.packages.elementAt(i).toString());
            }
            return stringBuffer.toString();
        }
    }

    public class TagArgument
    extends FileSet {
        private String name = null;
        private boolean enabled = true;
        private String scope = "a";

        public void setName(String string) {
            this.name = string;
        }

        public void setScope(String string) throws BuildException {
            int n;
            CharSequence charSequence;
            string = string.toLowerCase(Locale.US);
            boolean[] blArray = new boolean[SCOPE_ELEMENTS.length];
            boolean bl = false;
            boolean bl2 = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                charSequence = stringTokenizer.nextToken().trim();
                if (((String)charSequence).equals("all")) {
                    if (bl) {
                        this.getProject().log("Repeated tag scope element: all", 3);
                    }
                    bl = true;
                    continue;
                }
                for (n = 0; n < SCOPE_ELEMENTS.length && !((String)charSequence).equals(SCOPE_ELEMENTS[n]); ++n) {
                }
                if (n == SCOPE_ELEMENTS.length) {
                    throw new BuildException("Unrecognised scope element: " + (String)charSequence);
                }
                if (blArray[n]) {
                    this.getProject().log("Repeated tag scope element: " + (String)charSequence, 3);
                }
                blArray[n] = true;
                bl2 = true;
            }
            if (bl2 && bl) {
                throw new BuildException("Mixture of \"all\" and other scope elements in tag parameter.");
            }
            if (!bl2 && !bl) {
                throw new BuildException("No scope elements specified in tag parameter.");
            }
            if (bl) {
                this.scope = "a";
            } else {
                charSequence = new StringBuffer(blArray.length);
                for (n = 0; n < blArray.length; ++n) {
                    if (!blArray[n]) continue;
                    ((StringBuffer)charSequence).append(SCOPE_ELEMENTS[n].charAt(0));
                }
                this.scope = ((StringBuffer)charSequence).toString();
            }
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public String getParameter() throws BuildException {
            if (this.name == null || this.name.equals("")) {
                throw new BuildException("No name specified for custom tag.");
            }
            if (this.getDescription() != null) {
                return this.name + ":" + (this.enabled ? "" : "X") + this.scope + ":" + this.getDescription();
            }
            if (!this.enabled || !"a".equals(this.scope)) {
                return this.name + ":" + (this.enabled ? "" : "X") + this.scope;
            }
            return this.name;
        }
    }

    public class LinkArgument {
        private String href;
        private boolean offline = false;
        private File packagelistLoc;
        private boolean resolveLink = false;

        public void setHref(String string) {
            this.href = string;
        }

        public String getHref() {
            return this.href;
        }

        public void setPackagelistLoc(File file) {
            this.packagelistLoc = file;
        }

        public File getPackagelistLoc() {
            return this.packagelistLoc;
        }

        public void setOffline(boolean bl) {
            this.offline = bl;
        }

        public boolean isLinkOffline() {
            return this.offline;
        }

        public void setResolveLink(boolean bl) {
            this.resolveLink = bl;
        }

        public boolean shouldResolveLink() {
            return this.resolveLink;
        }
    }

    public class ResourceCollectionContainer {
        private ArrayList rcs = new ArrayList();

        public void add(ResourceCollection resourceCollection) {
            this.rcs.add(resourceCollection);
        }

        private Iterator iterator() {
            return this.rcs.iterator();
        }
    }

    public static class AccessType
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"protected", "public", "package", "private"};
        }
    }

    public static class Html {
        private StringBuffer text = new StringBuffer();

        public void addText(String string) {
            this.text.append(string);
        }

        public String getText() {
            return this.text.substring(0);
        }
    }

    public static class SourceFile {
        private File file;

        public SourceFile() {
        }

        public SourceFile(File file) {
            this.file = file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }

    public static class PackageName {
        private String name;

        public void setName(String string) {
            this.name = string.trim();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public class DocletInfo
    extends ExtensionInfo {
        private Vector params = new Vector();

        public DocletParam createParam() {
            DocletParam docletParam = new DocletParam();
            this.params.addElement(docletParam);
            return docletParam;
        }

        public Enumeration getParams() {
            return this.params.elements();
        }
    }

    public static class ExtensionInfo
    extends ProjectComponent {
        private String name;
        private Path path;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setPath(Path path) {
            if (this.path == null) {
                this.path = path;
            } else {
                this.path.append(path);
            }
        }

        public Path getPath() {
            return this.path;
        }

        public Path createPath() {
            if (this.path == null) {
                this.path = new Path(this.getProject());
            }
            return this.path.createPath();
        }

        public void setPathRef(Reference reference) {
            this.createPath().setRefid(reference);
        }
    }

    public class DocletParam {
        private String name;
        private String value;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }
    }
}

