/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ExitException;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteJava;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Assertions;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Permissions;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.RedirectorElement;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.KeepAliveInputStream;

public class Java
extends Task {
    private CommandlineJava cmdl = new CommandlineJava();
    private Environment env = new Environment();
    private boolean fork = false;
    private boolean newEnvironment = false;
    private File dir = null;
    private boolean failOnError = false;
    private Long timeout = null;
    private String inputString;
    private File input;
    private File output;
    private File error;
    protected Redirector redirector = new Redirector(this);
    protected RedirectorElement redirectorElement;
    private String resultProperty;
    private Permissions perm = null;
    private boolean spawn = false;
    private boolean incompatibleWithSpawn = false;

    public Java() {
    }

    public Java(Task task) {
        this.bindToOwner(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        File file = this.dir;
        Permissions permissions = this.perm;
        int n = -1;
        try {
            this.checkConfiguration();
            n = this.executeJava();
            if (n != 0) {
                if (this.failOnError) {
                    throw new ExitStatusException("Java returned: " + n, n, this.getLocation());
                }
                this.log("Java Result: " + n, 0);
            }
            this.maybeSetResultPropertyValue(n);
        }
        finally {
            this.dir = file;
            this.perm = permissions;
        }
    }

    public int executeJava() throws BuildException {
        return this.executeJava(this.getCommandLine());
    }

    protected void checkConfiguration() throws BuildException {
        String string = this.getCommandLine().getClassname();
        if (string == null && this.getCommandLine().getJar() == null) {
            throw new BuildException("Classname must not be null.");
        }
        if (!this.fork && this.getCommandLine().getJar() != null) {
            throw new BuildException("Cannot execute a jar in non-forked mode. Please set fork='true'. ");
        }
        if (this.spawn && !this.fork) {
            throw new BuildException("Cannot spawn a java process in non-forked mode. Please set fork='true'. ");
        }
        if (this.getCommandLine().getClasspath() != null && this.getCommandLine().getJar() != null) {
            this.log("When using 'jar' attribute classpath-settings are ignored. See the manual for more information.", 3);
        }
        if (this.spawn && this.incompatibleWithSpawn) {
            this.getProject().log("spawn does not allow attributes related to input, output, error, result", 0);
            this.getProject().log("spawn also does not allow timeout", 0);
            this.getProject().log("finally, spawn is not compatible with a nested I/O <redirector>", 0);
            throw new BuildException("You have used an attribute or nested element which is not compatible with spawn");
        }
        if (this.getCommandLine().getAssertions() != null && !this.fork) {
            this.log("Assertion statements are currently ignored in non-forked mode");
        }
        if (this.fork) {
            if (this.perm != null) {
                this.log("Permissions can not be set this way in forked mode.", 1);
            }
            this.log(this.getCommandLine().describeCommand(), 3);
        } else {
            if (this.getCommandLine().getVmCommand().size() > 1) {
                this.log("JVM args ignored when same JVM is used.", 1);
            }
            if (this.dir != null) {
                this.log("Working directory ignored when same JVM is used.", 1);
            }
            if (this.newEnvironment || null != this.env.getVariables()) {
                this.log("Changes to environment variables are ignored when same JVM is used.", 1);
            }
            if (this.getCommandLine().getBootclasspath() != null) {
                this.log("bootclasspath ignored when same JVM is used.", 1);
            }
            if (this.perm == null) {
                this.perm = new Permissions(true);
                this.log("running " + this.getCommandLine().getClassname() + " with default permissions (exit forbidden)", 3);
            }
            this.log("Running in same VM " + this.getCommandLine().describeJavaCommand(), 3);
        }
        this.setupRedirector();
    }

    protected int executeJava(CommandlineJava commandlineJava) {
        try {
            if (this.fork) {
                if (!this.spawn) {
                    return this.fork(commandlineJava.getCommandline());
                }
                this.spawn(commandlineJava.getCommandline());
                return 0;
            }
            try {
                this.run(commandlineJava);
                return 0;
            }
            catch (ExitException exitException) {
                return exitException.getStatus();
            }
        }
        catch (BuildException buildException) {
            if (buildException.getLocation() == null && this.getLocation() != null) {
                buildException.setLocation(this.getLocation());
            }
            if (this.failOnError) {
                throw buildException;
            }
            this.log(buildException);
            return -1;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            if (this.failOnError) {
                throw new BuildException(throwable, this.getLocation());
            }
            this.log(throwable);
            return -1;
        }
    }

    public void setSpawn(boolean bl) {
        this.spawn = bl;
    }

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public Path createClasspath() {
        return this.getCommandLine().createClasspath(this.getProject()).createPath();
    }

    public Path createBootclasspath() {
        return this.getCommandLine().createBootclasspath(this.getProject()).createPath();
    }

    public Permissions createPermissions() {
        this.perm = this.perm == null ? new Permissions() : this.perm;
        return this.perm;
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setJar(File file) throws BuildException {
        if (this.getCommandLine().getClassname() != null) {
            throw new BuildException("Cannot use 'jar' and 'classname' attributes in same command.");
        }
        this.getCommandLine().setJar(file.getAbsolutePath());
    }

    public void setClassname(String string) throws BuildException {
        if (this.getCommandLine().getJar() != null) {
            throw new BuildException("Cannot use 'jar' and 'classname' attributes in same command");
        }
        this.getCommandLine().setClassname(string);
    }

    public void setArgs(String string) {
        this.log("The args attribute is deprecated. Please use nested arg elements.", 1);
        this.getCommandLine().createArgument().setLine(string);
    }

    public void setCloneVm(boolean bl) {
        this.getCommandLine().setCloneVm(bl);
    }

    public Commandline.Argument createArg() {
        return this.getCommandLine().createArgument();
    }

    public void setResultProperty(String string) {
        this.resultProperty = string;
        this.incompatibleWithSpawn = true;
    }

    protected void maybeSetResultPropertyValue(int n) {
        String string = Integer.toString(n);
        if (this.resultProperty != null) {
            this.getProject().setNewProperty(this.resultProperty, string);
        }
    }

    public void setFork(boolean bl) {
        this.fork = bl;
    }

    public void setJvmargs(String string) {
        this.log("The jvmargs attribute is deprecated. Please use nested jvmarg elements.", 1);
        this.getCommandLine().createVmArgument().setLine(string);
    }

    public Commandline.Argument createJvmarg() {
        return this.getCommandLine().createVmArgument();
    }

    public void setJvm(String string) {
        this.getCommandLine().setVm(string);
    }

    public void addSysproperty(Environment.Variable variable) {
        this.getCommandLine().addSysproperty(variable);
    }

    public void addSyspropertyset(PropertySet propertySet) {
        this.getCommandLine().addSyspropertyset(propertySet);
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
        this.incompatibleWithSpawn |= bl;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setOutput(File file) {
        this.output = file;
        this.incompatibleWithSpawn = true;
    }

    public void setInput(File file) {
        if (this.inputString != null) {
            throw new BuildException("The \"input\" and \"inputstring\" attributes cannot both be specified");
        }
        this.input = file;
        this.incompatibleWithSpawn = true;
    }

    public void setInputString(String string) {
        if (this.input != null) {
            throw new BuildException("The \"input\" and \"inputstring\" attributes cannot both be specified");
        }
        this.inputString = string;
        this.incompatibleWithSpawn = true;
    }

    public void setLogError(boolean bl) {
        this.redirector.setLogError(bl);
        this.incompatibleWithSpawn |= bl;
    }

    public void setError(File file) {
        this.error = file;
        this.incompatibleWithSpawn = true;
    }

    public void setOutputproperty(String string) {
        this.redirector.setOutputProperty(string);
        this.incompatibleWithSpawn = true;
    }

    public void setErrorProperty(String string) {
        this.redirector.setErrorProperty(string);
        this.incompatibleWithSpawn = true;
    }

    public void setMaxmemory(String string) {
        this.getCommandLine().setMaxmemory(string);
    }

    public void setJVMVersion(String string) {
        this.getCommandLine().setVmversion(string);
    }

    public void addEnv(Environment.Variable variable) {
        this.env.addVariable(variable);
    }

    public void setNewenvironment(boolean bl) {
        this.newEnvironment = bl;
    }

    public void setAppend(boolean bl) {
        this.redirector.setAppend(bl);
        this.incompatibleWithSpawn = true;
    }

    public void setTimeout(Long l) {
        this.timeout = l;
        this.incompatibleWithSpawn |= this.timeout != null;
    }

    public void addAssertions(Assertions assertions) {
        if (this.getCommandLine().getAssertions() != null) {
            throw new BuildException("Only one assertion declaration is allowed");
        }
        this.getCommandLine().setAssertions(assertions);
    }

    public void addConfiguredRedirector(RedirectorElement redirectorElement) {
        if (this.redirectorElement != null) {
            throw new BuildException("cannot have > 1 nested redirectors");
        }
        this.redirectorElement = redirectorElement;
        this.incompatibleWithSpawn = true;
    }

    @Override
    protected void handleOutput(String string) {
        if (this.redirector.getOutputStream() != null) {
            this.redirector.handleOutput(string);
        } else {
            super.handleOutput(string);
        }
    }

    @Override
    public int handleInput(byte[] byArray, int n, int n2) throws IOException {
        return this.redirector.handleInput(byArray, n, n2);
    }

    @Override
    protected void handleFlush(String string) {
        if (this.redirector.getOutputStream() != null) {
            this.redirector.handleFlush(string);
        } else {
            super.handleFlush(string);
        }
    }

    @Override
    protected void handleErrorOutput(String string) {
        if (this.redirector.getErrorStream() != null) {
            this.redirector.handleErrorOutput(string);
        } else {
            super.handleErrorOutput(string);
        }
    }

    @Override
    protected void handleErrorFlush(String string) {
        if (this.redirector.getErrorStream() != null) {
            this.redirector.handleErrorFlush(string);
        } else {
            super.handleErrorOutput(string);
        }
    }

    protected void setupRedirector() {
        this.redirector.setInput(this.input);
        this.redirector.setInputString(this.inputString);
        this.redirector.setOutput(this.output);
        this.redirector.setError(this.error);
        if (this.redirectorElement != null) {
            this.redirectorElement.configure(this.redirector);
        }
        if (!this.spawn && this.input == null && this.inputString == null) {
            this.redirector.setInputStream(new KeepAliveInputStream(this.getProject().getDefaultInputStream()));
        }
    }

    private void run(CommandlineJava commandlineJava) throws BuildException {
        try {
            ExecuteJava executeJava = new ExecuteJava();
            executeJava.setJavaCommand(commandlineJava.getJavaCommand());
            executeJava.setClasspath(commandlineJava.getClasspath());
            executeJava.setSystemProperties(commandlineJava.getSystemProperties());
            executeJava.setPermissions(this.perm);
            executeJava.setTimeout(this.timeout);
            this.redirector.createStreams();
            executeJava.execute(this.getProject());
            this.redirector.complete();
            if (executeJava.killedProcess()) {
                throw new BuildException("Timeout: killed the sub-process");
            }
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    private int fork(String[] stringArray) throws BuildException {
        Execute execute = new Execute(this.redirector.createHandler(), this.createWatchdog());
        this.setupExecutable(execute, stringArray);
        try {
            int n = execute.execute();
            this.redirector.complete();
            if (execute.killedProcess()) {
                throw new BuildException("Timeout: killed the sub-process");
            }
            return n;
        }
        catch (IOException iOException) {
            throw new BuildException(iOException, this.getLocation());
        }
    }

    private void spawn(String[] stringArray) throws BuildException {
        Execute execute = new Execute();
        this.setupExecutable(execute, stringArray);
        try {
            execute.spawn();
        }
        catch (IOException iOException) {
            throw new BuildException(iOException, this.getLocation());
        }
    }

    private void setupExecutable(Execute execute, String[] stringArray) {
        execute.setAntRun(this.getProject());
        this.setupWorkingDir(execute);
        this.setupEnvironment(execute);
        this.setupCommandLine(execute, stringArray);
    }

    private void setupEnvironment(Execute execute) {
        String[] stringArray = this.env.getVariables();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.log("Setting environment variable: " + stringArray[i], 3);
            }
        }
        execute.setNewenvironment(this.newEnvironment);
        execute.setEnvironment(stringArray);
    }

    private void setupWorkingDir(Execute execute) {
        if (this.dir == null) {
            this.dir = this.getProject().getBaseDir();
        } else if (!this.dir.exists() || !this.dir.isDirectory()) {
            throw new BuildException(this.dir.getAbsolutePath() + " is not a valid directory", this.getLocation());
        }
        execute.setWorkingDirectory(this.dir);
    }

    private void setupCommandLine(Execute execute, String[] stringArray) {
        if (Os.isFamily("openvms")) {
            this.setupCommandLineForVMS(execute, stringArray);
        } else {
            execute.setCommandline(stringArray);
        }
    }

    private void setupCommandLineForVMS(Execute execute, String[] stringArray) {
        ExecuteJava.setupCommandLineForVMS(execute, stringArray);
    }

    protected void run(String string, Vector vector) throws BuildException {
        CommandlineJava commandlineJava = new CommandlineJava();
        commandlineJava.setClassname(string);
        for (int i = 0; i < vector.size(); ++i) {
            commandlineJava.createArgument().setValue((String)vector.elementAt(i));
        }
        this.run(commandlineJava);
    }

    public void clearArgs() {
        this.getCommandLine().clearJavaArgs();
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout);
    }

    private void log(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        this.log(stringWriter.toString(), 0);
    }

    public CommandlineJava getCommandLine() {
        return this.cmdl;
    }

    public CommandlineJava.SysProperties getSysProperties() {
        return this.getCommandLine().getSystemProperties();
    }
}

