/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.spi.Service;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.JarMarker;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class Jar
extends Zip {
    private static final String INDEX_NAME = "META-INF/INDEX.LIST";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private List serviceList = new ArrayList();
    private Manifest configuredManifest;
    private Manifest savedConfiguredManifest;
    private Manifest filesetManifest;
    private Manifest originalManifest;
    private FilesetManifestConfig filesetManifestConfig;
    private boolean mergeManifestsMain = true;
    private Manifest manifest;
    private String manifestEncoding;
    private File manifestFile;
    private boolean index = false;
    private boolean createEmpty = false;
    private Vector rootEntries;
    private Path indexJars;
    private StrictMode strict = new StrictMode("ignore");
    private static final ZipExtraField[] JAR_MARKER = new ZipExtraField[]{JarMarker.getInstance()};

    public Jar() {
        this.archiveType = "jar";
        this.emptyBehavior = "create";
        this.setEncoding("UTF8");
        this.rootEntries = new Vector();
    }

    @Override
    public void setWhenempty(Zip.WhenEmpty whenEmpty) {
        this.log("JARs are never empty, they contain at least a manifest file", 1);
    }

    public void setWhenmanifestonly(Zip.WhenEmpty whenEmpty) {
        this.emptyBehavior = whenEmpty.getValue();
    }

    public void setStrict(StrictMode strictMode) {
        this.strict = strictMode;
    }

    public void setJarfile(File file) {
        this.setDestFile(file);
    }

    public void setIndex(boolean bl) {
        this.index = bl;
    }

    public void setManifestEncoding(String string) {
        this.manifestEncoding = string;
    }

    public void addConfiguredManifest(Manifest manifest) throws ManifestException {
        if (this.configuredManifest == null) {
            this.configuredManifest = manifest;
        } else {
            this.configuredManifest.merge(manifest);
        }
        this.savedConfiguredManifest = this.configuredManifest;
    }

    public void setManifest(File file) {
        if (!file.exists()) {
            throw new BuildException("Manifest file: " + file + " does not exist.", this.getLocation());
        }
        this.manifestFile = file;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest getManifest(File file) {
        Manifest manifest = null;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = this.manifestEncoding == null ? new InputStreamReader(fileInputStream) : new InputStreamReader((InputStream)fileInputStream, this.manifestEncoding);
            manifest = this.getManifest(inputStreamReader);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                throw new BuildException("Unsupported encoding while reading manifest: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                catch (IOException iOException) {
                    throw new BuildException("Unable to read manifest file: " + file + " (" + iOException.getMessage() + ")", iOException);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(inputStreamReader);
                throw throwable;
            }
        }
        FileUtils.close(inputStreamReader);
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifestFromJar(File file) throws IOException {
        java.util.zip.ZipFile zipFile = null;
        try {
            java.util.zip.ZipEntry zipEntry;
            zipFile = new java.util.zip.ZipFile(file);
            Enumeration<? extends java.util.zip.ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().equalsIgnoreCase(MANIFEST_NAME)) continue;
                InputStreamReader inputStreamReader = new InputStreamReader(zipFile.getInputStream(zipEntry), "UTF-8");
                Manifest manifest = this.getManifest(inputStreamReader);
                return manifest;
            }
            zipEntry = null;
            return zipEntry;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Manifest getManifest(Reader reader) {
        Manifest manifest = null;
        try {
            manifest = new Manifest(reader);
        }
        catch (ManifestException manifestException) {
            this.log("Manifest is invalid: " + manifestException.getMessage(), 0);
            throw new BuildException("Invalid Manifest: " + this.manifestFile, manifestException, this.getLocation());
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to read manifest file (" + iOException.getMessage() + ")", iOException);
        }
        return manifest;
    }

    public void setFilesetmanifest(FilesetManifestConfig filesetManifestConfig) {
        this.filesetManifestConfig = filesetManifestConfig;
        this.mergeManifestsMain = "merge".equals(filesetManifestConfig.getValue());
        if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.doubleFilePass = true;
        }
    }

    public void addMetainf(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("META-INF/");
        super.addFileset(zipFileSet);
    }

    public void addConfiguredIndexJars(Path path) {
        if (this.indexJars == null) {
            this.indexJars = new Path(this.getProject());
        }
        this.indexJars.append(path);
    }

    public void addConfiguredService(Service service) {
        service.check();
        this.serviceList.add(service);
    }

    private void writeServices(ZipOutputStream zipOutputStream) throws IOException {
        for (Service service : this.serviceList) {
            super.zipFile(service.getAsStream(), zipOutputStream, "META-INF/services/" + service.getType(), System.currentTimeMillis(), null, 33188);
        }
    }

    @Override
    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        if (!this.skipWriting) {
            Manifest manifest = this.createManifest();
            this.writeManifest(zipOutputStream, manifest);
            this.writeServices(zipOutputStream);
        }
    }

    private Manifest createManifest() throws BuildException {
        try {
            Manifest manifest = Manifest.getDefaultManifest();
            if (this.manifest == null && this.manifestFile != null) {
                this.manifest = this.getManifest(this.manifestFile);
            }
            if (this.isInUpdateMode()) {
                manifest.merge(this.originalManifest);
            }
            manifest.merge(this.filesetManifest);
            manifest.merge(this.configuredManifest);
            manifest.merge(this.manifest, !this.mergeManifestsMain);
            return manifest;
        }
        catch (ManifestException manifestException) {
            this.log("Manifest is invalid: " + manifestException.getMessage(), 0);
            throw new BuildException("Invalid Manifest", manifestException, this.getLocation());
        }
    }

    private void writeManifest(ZipOutputStream zipOutputStream, Manifest manifest) throws IOException {
        Object object = manifest.getWarnings();
        while (object.hasMoreElements()) {
            this.log("Manifest warning: " + object.nextElement(), 1);
        }
        this.zipDir(null, zipOutputStream, "META-INF/", 16877, JAR_MARKER);
        object = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        manifest.write(printWriter);
        printWriter.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
        super.zipFile(byteArrayInputStream, zipOutputStream, MANIFEST_NAME, System.currentTimeMillis(), null, 33188);
        super.initZipOutputStream(zipOutputStream);
    }

    @Override
    protected void finalizeZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        if (this.index) {
            this.createIndexList(zipOutputStream);
        }
    }

    private void createIndexList(ZipOutputStream zipOutputStream) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8"));
        printWriter.println("JarIndex-Version: 1.0");
        printWriter.println();
        printWriter.println(this.zipFile.getName());
        this.writeIndexLikeList(new ArrayList(this.addedDirs.keySet()), this.rootEntries, printWriter);
        printWriter.println();
        if (this.indexJars != null) {
            int n;
            Object object2;
            object = this.createManifest();
            Manifest.Attribute attribute = ((Manifest)object).getMainSection().getAttribute("Class-Path");
            String[] stringArray = null;
            if (attribute != null && attribute.getValue() != null) {
                object2 = new StringTokenizer(attribute.getValue(), " ");
                stringArray = new String[((StringTokenizer)object2).countTokens()];
                n = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    stringArray[n++] = ((StringTokenizer)object2).nextToken();
                }
            }
            object2 = this.indexJars.list();
            for (n = 0; n < ((String[])object2).length; ++n) {
                String string = Jar.findJarName((String)object2[n], stringArray);
                if (string == null) continue;
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                Jar.grabFilesAndDirs((String)object2[n], arrayList, arrayList2);
                if (arrayList.size() + arrayList2.size() <= 0) continue;
                printWriter.println(string);
                this.writeIndexLikeList(arrayList, arrayList2, printWriter);
                printWriter.println();
            }
        }
        printWriter.close();
        object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        super.zipFile((InputStream)object, zipOutputStream, INDEX_NAME, System.currentTimeMillis(), null, 33188);
    }

    @Override
    protected void zipFile(InputStream inputStream, ZipOutputStream zipOutputStream, String string, long l, File file, int n) throws IOException {
        if (MANIFEST_NAME.equalsIgnoreCase(string)) {
            if (!this.doubleFilePass || this.skipWriting) {
                this.filesetManifest(file, inputStream);
            }
        } else if (INDEX_NAME.equalsIgnoreCase(string) && this.index) {
            this.log("Warning: selected " + this.archiveType + " files include a META-INF/INDEX.LIST which will" + " be replaced by a newly generated one.", 1);
        } else {
            if (this.index && string.indexOf("/") == -1) {
                this.rootEntries.addElement(string);
            }
            super.zipFile(inputStream, zipOutputStream, string, l, file, n);
        }
    }

    private void filesetManifest(File file, InputStream inputStream) throws IOException {
        if (this.manifestFile != null && this.manifestFile.equals(file)) {
            this.log("Found manifest " + file, 3);
            try {
                if (inputStream != null) {
                    InputStreamReader inputStreamReader = this.manifestEncoding == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, this.manifestEncoding);
                    this.manifest = this.getManifest(inputStreamReader);
                }
                this.manifest = this.getManifest(file);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new BuildException("Unsupported encoding while reading manifest: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        } else if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.log("Found manifest to merge in file " + file, 3);
            try {
                Manifest manifest = null;
                if (inputStream != null) {
                    InputStreamReader inputStreamReader = this.manifestEncoding == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, this.manifestEncoding);
                    manifest = this.getManifest(inputStreamReader);
                } else {
                    manifest = this.getManifest(file);
                }
                if (this.filesetManifest == null) {
                    this.filesetManifest = manifest;
                } else {
                    this.filesetManifest.merge(manifest);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new BuildException("Unsupported encoding while reading manifest: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
            catch (ManifestException manifestException) {
                this.log("Manifest in file " + file + " is invalid: " + manifestException.getMessage(), 0);
                throw new BuildException("Invalid Manifest", manifestException, this.getLocation());
            }
        }
    }

    @Override
    protected Zip.ArchiveState getResourcesToAdd(ResourceCollection[] resourceCollectionArray, File file, boolean bl) throws BuildException {
        if (file.exists()) {
            try {
                this.originalManifest = this.getManifestFromJar(file);
                if (this.originalManifest == null) {
                    this.log("Updating jar since the current jar has no manifest", 3);
                    bl = true;
                } else {
                    Manifest manifest = this.createManifest();
                    if (!manifest.equals(this.originalManifest)) {
                        this.log("Updating jar since jar manifest has changed", 3);
                        bl = true;
                    }
                }
            }
            catch (Throwable throwable) {
                this.log("error while reading original manifest in file: " + file.toString() + throwable.getMessage(), 1);
                bl = true;
            }
        } else {
            bl = true;
        }
        this.createEmpty = bl;
        return super.getResourcesToAdd(resourceCollectionArray, file, bl);
    }

    @Override
    protected boolean createEmptyZip(File file) throws BuildException {
        if (!this.createEmpty) {
            return true;
        }
        if (this.emptyBehavior.equals("skip")) {
            this.log("Warning: skipping " + this.archiveType + " archive " + file + " because no files were included.", 1);
            return true;
        }
        if (this.emptyBehavior.equals("fail")) {
            throw new BuildException("Cannot create " + this.archiveType + " archive " + file + ": no files were included.", this.getLocation());
        }
        ZipOutputStream zipOutputStream = null;
        try {
            this.log("Building MANIFEST-only jar: " + this.getDestFile().getAbsolutePath());
            zipOutputStream = new ZipOutputStream(new FileOutputStream(this.getDestFile()));
            zipOutputStream.setEncoding(this.getEncoding());
            if (this.isCompress()) {
                zipOutputStream.setMethod(8);
            } else {
                zipOutputStream.setMethod(0);
            }
            this.initZipOutputStream(zipOutputStream);
            this.finalizeZipOutputStream(zipOutputStream);
        }
        catch (IOException iOException) {
            try {
                throw new BuildException("Could not create almost empty JAR archive (" + iOException.getMessage() + ")", iOException, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(zipOutputStream);
                this.createEmpty = false;
                throw throwable;
            }
        }
        FileUtils.close(zipOutputStream);
        this.createEmpty = false;
        return true;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this.checkJarSpec();
        if (!this.doubleFilePass || !this.skipWriting) {
            this.manifest = null;
            this.configuredManifest = this.savedConfiguredManifest;
            this.filesetManifest = null;
            this.originalManifest = null;
        }
        this.rootEntries.removeAllElements();
    }

    private void checkJarSpec() {
        Manifest.Section section;
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        Manifest.Section section2 = section = this.configuredManifest == null ? null : this.configuredManifest.getMainSection();
        if (section == null) {
            stringBuffer.append("No Implementation-Title set.");
            stringBuffer.append("No Implementation-Version set.");
            stringBuffer.append("No Implementation-Vendor set.");
        } else {
            if (section.getAttribute("Implementation-Title") == null) {
                stringBuffer.append("No Implementation-Title set.");
            }
            if (section.getAttribute("Implementation-Version") == null) {
                stringBuffer.append("No Implementation-Version set.");
            }
            if (section.getAttribute("Implementation-Vendor") == null) {
                stringBuffer.append("No Implementation-Vendor set.");
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append("Location: ").append(this.getLocation());
            stringBuffer.append(string);
            if (this.strict.getValue().equalsIgnoreCase("fail")) {
                throw new BuildException(stringBuffer.toString(), this.getLocation());
            }
            this.log(stringBuffer.toString(), this.strict.getLogLevel());
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.emptyBehavior = "create";
        this.configuredManifest = null;
        this.filesetManifestConfig = null;
        this.mergeManifestsMain = false;
        this.manifestFile = null;
        this.index = false;
    }

    protected final void writeIndexLikeList(List list, List list2, PrintWriter printWriter) throws IOException {
        Collections.sort(list);
        Collections.sort(list2);
        for (String string : list) {
            if ((string = string.replace('\\', '/')).startsWith("./")) {
                string = string.substring(2);
            }
            while (string.startsWith("/")) {
                string = string.substring(1);
            }
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(0, n);
            }
            if (string.startsWith("META-INF")) continue;
            printWriter.println(string);
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            printWriter.println(iterator.next());
        }
    }

    protected static String findJarName(String string, String[] stringArray) {
        if (stringArray == null) {
            return new File(string).getName();
        }
        string = string.replace(File.separatorChar, '/');
        TreeMap<String, String> treeMap = new TreeMap<String, String>(new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof String && object2 instanceof String) {
                    return ((String)object2).length() - ((String)object).length();
                }
                return 0;
            }
        });
        block0: for (int i = 0; i < stringArray.length; ++i) {
            if (string.endsWith(stringArray[i])) {
                treeMap.put(stringArray[i], stringArray[i]);
                continue;
            }
            int n = stringArray[i].indexOf("/");
            String string2 = stringArray[i];
            while (n > -1) {
                if (string.endsWith(string2 = string2.substring(n + 1))) {
                    treeMap.put(string2, stringArray[i]);
                    continue block0;
                }
                n = string2.indexOf("/");
            }
        }
        return treeMap.size() == 0 ? null : (String)treeMap.get(treeMap.firstKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void grabFilesAndDirs(String string, List list, List list2) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(string, "utf-8");
            Enumeration enumeration = zipFile.getEntries();
            HashSet<String> hashSet = new HashSet<String>();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (string2.startsWith("META-INF/")) continue;
                if (zipEntry.isDirectory()) {
                    hashSet.add(string2);
                    continue;
                }
                if (string2.indexOf("/") == -1) {
                    list2.add(string2);
                    continue;
                }
                hashSet.add(string2.substring(0, string2.lastIndexOf("/") + 1));
            }
            list.addAll(hashSet);
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    public static class StrictMode
    extends EnumeratedAttribute {
        public StrictMode() {
        }

        public StrictMode(String string) {
            this.setValue(string);
        }

        @Override
        public String[] getValues() {
            return new String[]{"fail", "warn", "ignore"};
        }

        public int getLogLevel() {
            return this.getValue().equals("ignore") ? 3 : 1;
        }
    }

    public static class FilesetManifestConfig
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"skip", "merge", "mergewithoutmain"};
        }
    }
}

