/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Unpack;
import org.apache.tools.ant.util.FileUtils;

public class GUnzip
extends Unpack {
    private static final int BUFFER_SIZE = 8192;
    private static final String DEFAULT_EXTENSION = ".gz";

    @Override
    protected String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    protected void extract() {
        if (this.source.lastModified() > this.dest.lastModified()) {
            this.log("Expanding " + this.source.getAbsolutePath() + " to " + this.dest.getAbsolutePath());
            FileOutputStream fileOutputStream = null;
            GZIPInputStream gZIPInputStream = null;
            InputStream inputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.dest);
                inputStream = this.srcResource.getInputStream();
                gZIPInputStream = new GZIPInputStream(inputStream);
                byte[] byArray = new byte[8192];
                int n = 0;
                do {
                    fileOutputStream.write(byArray, 0, n);
                } while ((n = gZIPInputStream.read(byArray, 0, byArray.length)) != -1);
            }
            catch (IOException iOException) {
                try {
                    String string = "Problem expanding gzip " + iOException.getMessage();
                    throw new BuildException(string, iOException, this.getLocation());
                }
                catch (Throwable throwable) {
                    FileUtils.close(inputStream);
                    FileUtils.close(fileOutputStream);
                    FileUtils.close(gZIPInputStream);
                    throw throwable;
                }
            }
            FileUtils.close(inputStream);
            FileUtils.close(fileOutputStream);
            FileUtils.close(gZIPInputStream);
        }
    }

    @Override
    protected boolean supportsNonFileResources() {
        return this.getClass().equals(GUnzip.class);
    }
}

